/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.bees;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.bees.BeeMutationTree;
import com.rwtema.careerbees.bees.BlockStateList;
import com.rwtema.careerbees.bees.CareerBeeEntry;
import com.rwtema.careerbees.bees.CustomBeeModel;
import com.rwtema.careerbees.bees.SpecialProperties;
import com.rwtema.careerbees.colors.QuantumBeeColors;
import com.rwtema.careerbees.colors.RainbowBeeColors;
import com.rwtema.careerbees.effects.EffectAcceleration;
import com.rwtema.careerbees.effects.EffectArmorer;
import com.rwtema.careerbees.effects.EffectAssassin;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.effects.EffectBuisness;
import com.rwtema.careerbees.effects.EffectBurning;
import com.rwtema.careerbees.effects.EffectButcher;
import com.rwtema.careerbees.effects.EffectClockwork;
import com.rwtema.careerbees.effects.EffectCreeper;
import com.rwtema.careerbees.effects.EffectCurative;
import com.rwtema.careerbees.effects.EffectDigging;
import com.rwtema.careerbees.effects.EffectDire;
import com.rwtema.careerbees.effects.EffectEffection;
import com.rwtema.careerbees.effects.EffectElectrifying;
import com.rwtema.careerbees.effects.EffectExplosion;
import com.rwtema.careerbees.effects.EffectHeal;
import com.rwtema.careerbees.effects.EffectHoneyCombIngotConvert;
import com.rwtema.careerbees.effects.EffectHoneyGlaze;
import com.rwtema.careerbees.effects.EffectHusbandry;
import com.rwtema.careerbees.effects.EffectJazz;
import com.rwtema.careerbees.effects.EffectLumber;
import com.rwtema.careerbees.effects.EffectMason;
import com.rwtema.careerbees.effects.EffectOreCrushing;
import com.rwtema.careerbees.effects.EffectPainting;
import com.rwtema.careerbees.effects.EffectPickup;
import com.rwtema.careerbees.effects.EffectPolitics;
import com.rwtema.careerbees.effects.EffectPower;
import com.rwtema.careerbees.effects.EffectPriest;
import com.rwtema.careerbees.effects.EffectRandomSwap;
import com.rwtema.careerbees.effects.EffectRepair;
import com.rwtema.careerbees.effects.EffectSharpen;
import com.rwtema.careerbees.effects.EffectSmelt;
import com.rwtema.careerbees.effects.EffectSoaring;
import com.rwtema.careerbees.effects.EffectStealMob;
import com.rwtema.careerbees.effects.EffectStealMobTaxation;
import com.rwtema.careerbees.effects.EffectStealPlayer;
import com.rwtema.careerbees.helpers.StringHelper;
import com.rwtema.careerbees.items.ItemIngredients;
import com.rwtema.careerbees.mutations.MutationRecentExplosion;
import com.rwtema.careerbees.recipes.PlayerSpawnHandler;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IMutationBuilder;
import forestry.api.genetics.IMutationCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

public class CareerBeeSpecies {
    public static final int BEE_YELLOW = 16768022;
    public static final Set<IAlleleBeeSpecies> registeredSpecies = new HashSet<IAlleleBeeSpecies>();
    public static final HashMap<String, IClassification> classificationHashMap = new HashMap();
    public static final CareerBeeEntry STUDENT = new CareerBeeEntry("student", false, ":discipulus", CareerBeeSpecies.col(90, 43, 25)).setCustomBeeModelProvider(new CustomBeeModel("student"));
    public static final CareerBeeEntry VOCATIONAL = new CareerBeeEntry("graduate", false, "consilium:graduati", CareerBeeSpecies.col(60, 60, 80)).setTemplateEffect(() -> EffectEffection.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("graduate"));
    public static final CareerBeeEntry ARTIST = new CareerBeeEntry("artist", false, "artifex", CareerBeeSpecies.col(40, 40, 40)).setTemplateEffect(() -> EffectPainting.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("artist"));
    public static final CareerBeeEntry BUISNESS = new CareerBeeEntry("buisnessman", false, "negotiator", CareerBeeSpecies.col(40, 40, 40), CareerBeeSpecies.col(80, 80, 80)).setCustomBeeModelProvider(new CustomBeeModel("tophat")).setTemplateEffect(() -> EffectBuisness.INSTANCE);
    public static final CareerBeeEntry JUNK = new CareerBeeEntry("junk_seller", false, "negotiator", CareerBeeSpecies.col(179, 89, 73), CareerBeeSpecies.col(220, 170, 94)).setCustomBeeModelProvider(new CustomBeeModel("junk")).setTemplateEffect(() -> EffectBuisness.JUNK);
    public static final CareerBeeEntry DIGGING_BASE = new CareerBeeEntry("digging", false, "digging:diggicus", CareerBeeSpecies.col(222, 122, 20)).setTemplateAllelleBool(EnumBeeChromosome.CAVE_DWELLING, true).setTemplateEffect(() -> EffectDigging.INSTANCE_NORMAL).setCustomBeeModelProvider(new CustomBeeModel("mining"));
    public static final CareerBeeEntry DIGGING_FORTUNE = new CareerBeeEntry("digging.fortune", false, "digging:diggicus", CareerBeeSpecies.col(175, 50, 20)).setTemplateAllelleBool(EnumBeeChromosome.CAVE_DWELLING, true).setTemplateEffect(() -> EffectDigging.INSTANCE_FORTUNE).setCustomBeeModelProvider(new CustomBeeModel("mining"));
    public static final CareerBeeEntry DIGGING_SILKY = new CareerBeeEntry("digging.silky", false, "digging:diggicus", CareerBeeSpecies.col(122, 102, 200)).setTemplateAllelleBool(EnumBeeChromosome.CAVE_DWELLING, true).setTemplateEffect(() -> EffectDigging.INSTANCE_SILKY).setCustomBeeModelProvider(new CustomBeeModel("mining"));
    public static final CareerBeeEntry THIEF = new CareerBeeEntry("thief", false, "thief:cleptus", CareerBeeSpecies.col(23, 23, 23), CareerBeeSpecies.col(100, 100, 100)).setNocturnal().setTemplateEffect(() -> EffectStealPlayer.PLAYER).setCustomBeeModelProvider(new CustomBeeModel("thief"));
    public static final CareerBeeEntry POLICE = new CareerBeeEntry("police", false, "thief:cleptus", CareerBeeSpecies.col(100, 140, 150), CareerBeeSpecies.col(22, 67, 165)).setTemplateEffect(() -> EffectStealMob.MOB).setCustomBeeModelProvider(new CustomBeeModel("police"));
    public static final CareerBeeEntry TAXCOLLECTOR = new CareerBeeEntry("taxcollector", false, "thief:cleptus", CareerBeeSpecies.col(110, 110, 119), CareerBeeSpecies.col(200, 200, 200)).setTemplateEffect(() -> EffectStealMobTaxation.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("tax_collector"));
    public static final CareerBeeEntry ACCELERATION = new CareerBeeEntry("acceleration", false, "tempus:fugit", CareerBeeSpecies.col(140, 50, 40)).setTemplateEffect(() -> EffectAcceleration.INSTANCE).setTemplate(EnumBeeChromosome.LIFESPAN, () -> SpecialProperties.ETERNAL).setCustomBeeModelProvider(new CustomBeeModel("acceleration"));
    public static final CareerBeeEntry REPAIR = new CareerBeeEntry("repair", false, "smithing:faber", CareerBeeSpecies.col(122, 122, 190), CareerBeeSpecies.col(224, 210, 255)).setTemplateEffect(() -> EffectRepair.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("hammer"));
    public static final CareerBeeEntry SHARPENER = new CareerBeeEntry("sharpening", false, "smithing:faber", CareerBeeSpecies.col(200, 200, 200), CareerBeeSpecies.col(120, 120, 120)).setTemplateEffect(() -> EffectSharpen.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("hammer"));
    public static final CareerBeeEntry ARMORER = new CareerBeeEntry("armorer", false, "smithing:faber", CareerBeeSpecies.col(100, 200, 200), CareerBeeSpecies.col(100, 120, 120)).setTemplateEffect(() -> EffectArmorer.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("hammer"));
    public static final CareerBeeEntry LUMBER = new CareerBeeEntry("lumber", false, "ligna:choppicus", CareerBeeSpecies.col(96, 71, 0)).setTemplateEffect(() -> EffectLumber.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("axe"));
    public static final CareerBeeEntry HUSBANDRYIST = new CareerBeeEntry("husbandry", false, "medicus:easpariunt", CareerBeeSpecies.col(122, 122, 190), CareerBeeSpecies.col(224, 210, 255)).setTemplateEffect(() -> EffectHusbandry.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("midwife"));
    public static final CareerBeeEntry BUTCHER = new CareerBeeEntry("butcher", false, "macello:caedes", CareerBeeSpecies.col(250, 150, 150)).setTemplateEffect(() -> EffectButcher.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("butcher"));
    public static final CareerBeeEntry WOMBLING = new CareerBeeEntry("collectors", false, "lectica:coactore", CareerBeeSpecies.col(197, 60, 60)).setCustomBeeModelProvider(new CustomBeeModel("wombling")).setTemplateEffect(() -> EffectPickup.INSTANCE);
    public static final CareerBeeEntry COOK = new CareerBeeEntry("cook", false, "cook:cookus", CareerBeeSpecies.col(255, 255, 255)).setCustomBeeModelProvider(new CustomBeeModel("chef")).setTemplateEffect(() -> EffectHoneyGlaze.INSTANCE);
    public static final CareerBeeEntry YENTE = new CareerBeeEntry("yente", false, "matchmaker", CareerBeeSpecies.col(44, 44, 51)).setCustomBeeModelProvider(new CustomBeeModel("yente"));
    public static final CareerBeeEntry RAINBOW = new CareerBeeEntry("rainbow", false, "rain:eritque.arcus", CareerBeeSpecies.col(255, 255, 255), CareerBeeSpecies.col(255, 255, 255)){
        {
            LinkedHashMultimap dyeRecipes = LinkedHashMultimap.create();
            dyeRecipes.putAll((Object)EnumDyeColor.ORANGE, (Iterable)ImmutableList.of((Object)EnumDyeColor.RED, (Object)EnumDyeColor.YELLOW));
            dyeRecipes.putAll((Object)EnumDyeColor.LIGHT_BLUE, (Iterable)ImmutableList.of((Object)EnumDyeColor.WHITE, (Object)EnumDyeColor.BLUE));
            dyeRecipes.putAll((Object)EnumDyeColor.PINK, (Iterable)ImmutableList.of((Object)EnumDyeColor.WHITE, (Object)EnumDyeColor.RED));
            dyeRecipes.putAll((Object)EnumDyeColor.GRAY, (Iterable)ImmutableList.of((Object)EnumDyeColor.WHITE, (Object)EnumDyeColor.BLACK));
            dyeRecipes.putAll((Object)EnumDyeColor.SILVER, (Iterable)ImmutableList.of((Object)EnumDyeColor.WHITE, (Object)EnumDyeColor.GRAY));
            dyeRecipes.putAll((Object)EnumDyeColor.LIME, (Iterable)ImmutableList.of((Object)EnumDyeColor.WHITE, (Object)EnumDyeColor.GREEN));
            dyeRecipes.putAll((Object)EnumDyeColor.PURPLE, (Iterable)ImmutableList.of((Object)EnumDyeColor.RED, (Object)EnumDyeColor.BLUE));
            dyeRecipes.putAll((Object)EnumDyeColor.CYAN, (Iterable)ImmutableList.of((Object)EnumDyeColor.GREEN, (Object)EnumDyeColor.BLUE));
            dyeRecipes.putAll((Object)EnumDyeColor.MAGENTA, (Iterable)ImmutableList.of((Object)EnumDyeColor.PURPLE, (Object)EnumDyeColor.PINK));
            HashMap<EnumDyeColor, Double> probabilities = new HashMap<EnumDyeColor, Double>();
            probabilities.put(EnumDyeColor.RED, 5.0);
            probabilities.put(EnumDyeColor.WHITE, 1.0);
            probabilities.put(EnumDyeColor.GREEN, 5.0);
            probabilities.put(EnumDyeColor.BLUE, 0.05);
            probabilities.put(EnumDyeColor.BLACK, 2.0);
            probabilities.put(EnumDyeColor.YELLOW, 5.0);
            probabilities.put(EnumDyeColor.BROWN, 0.5);
            for (EnumDyeColor enumDyeColor : dyeRecipes.keySet()) {
                Set enumDyeColors = dyeRecipes.get((Object)enumDyeColor);
                probabilities.put(enumDyeColor, enumDyeColors.stream().map(probabilities::get).reduce(0.0, Double::sum));
            }
            double sum = probabilities.values().stream().mapToDouble(Double::doubleValue).sum();
            double sum2 = probabilities.values().stream().mapToDouble(Double::doubleValue).map(t -> t * t).sum();
            double a = sum2 / 2.0;
            double b = sum;
            double c = -Math.log(0.5);
            double k = (b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
                float chance = CareerBeeEntry.roundSig((float)((Double)probabilities.get(enumDyeColor) * k), 20.0f);
                this.addProduct(new ItemStack(Items.field_151100_aR, 1, enumDyeColor.func_176767_b()), Float.valueOf(chance));
            }
        }
    }.setCustomBeeSpriteColourProvider(new RainbowBeeColors());
    public static final CareerBeeEntry DIRE = new CareerBeeEntry("dire", false, "dire", 44975, -12174683).setTemplateEffect(() -> EffectDire.INSTANCE).setIsSecret();
    public static final CareerBeeEntry SOARYN = new CareerBeeEntry("soaring", false, "soaryn", CareerBeeSpecies.col(0, 0, 16), CareerBeeSpecies.col(80, 68, 99)).setTemplateEffect(() -> EffectSoaring.INSTANCE).setIsSecret();
    public static final CareerBeeEntry MASON = new CareerBeeEntry("mason", false, "mason:mason", CareerBeeSpecies.col(120, 120, 120)).setTemplateEffect(() -> EffectMason.INSTANCE);
    public static final CareerBeeEntry SMELTER = new CareerBeeEntry("smelter", false, "smelter:smelter", CareerBeeSpecies.col(81, 72, 64), CareerBeeSpecies.col(109, 81, 53)).setCustomBeeModelProvider(new CustomBeeModel("smelter")).setTemplateEffect(() -> EffectSmelt.INSTANCE);
    public static final CareerBeeEntry HONEY_SMELTER = new CareerBeeEntry("honey_smelter", false, "smelter:smelter", CareerBeeSpecies.col(230, 160, 10), CareerBeeSpecies.col(120, 50, 0)).setCustomBeeModelProvider(new CustomBeeModel("smelter")).setTemplateEffect(() -> EffectHoneyCombIngotConvert.INSTANCE);
    public static final CareerBeeEntry ORE_CRUSHER = new CareerBeeEntry("crusher", false, "crusher:crusher", CareerBeeSpecies.col(120, 120, 120), CareerBeeSpecies.col(80, 80, 80)).setCustomBeeModelProvider(new CustomBeeModel("saw")).setTemplateEffect(() -> EffectOreCrushing.INSTANCE);
    public static final CareerBeeEntry SCIENTIST = new CareerBeeEntry("science", false, "science", CareerBeeSpecies.col(158, 154, 159)).setCustomBeeModelProvider(new CustomBeeModel("einstein"));
    public static final CareerBeeEntry DOCTOR = new CareerBeeEntry("doctor", false, "science", CareerBeeSpecies.col(255, 255, 255)).setTemplateEffect(() -> EffectHeal.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("white_on_pinkish_cross"));
    public static final CareerBeeEntry PLAGUE_DOCTOR = new CareerBeeEntry("plaguedoctor", false, "medicine", CareerBeeSpecies.col(25, 25, 25), CareerBeeSpecies.col(140, 140, 140)).setTemplateEffect(() -> EffectCurative.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("plague_doctor"));
    public static final CareerBeeEntry PHD = new CareerBeeEntry("phd", false, "consilium:graduati", CareerBeeSpecies.col(160, 60, 80)).setTemplateEffect(() -> EffectEffection.INSTANCE).setCustomBeeModelProvider(new CustomBeeModel("graduate"));
    public static final CareerBeeEntry CLOCKWORK = new CareerBeeEntry("clock", false, "clockwork", CareerBeeSpecies.col(188, 181, 128), CareerBeeSpecies.col(78, 70, 57)).setCustomBeeModelProvider(new CustomBeeModel("clockwork")).setTemplateEffect(() -> EffectClockwork.INSTANCE);
    public static final CareerBeeEntry ENERGY = new CareerBeeEntry("energy", false, "redstoneflux", CareerBeeSpecies.col(255, 0, 0), CareerBeeSpecies.col(143, 0, 0)).setCustomBeeModelProvider(new CustomBeeModel("energy")).setTemplateEffect(() -> EffectPower.INSTANCE);
    public static final CareerBeeEntry ENGINEER = new CareerBeeEntry("engineer", false, "engineer", CareerBeeSpecies.col(48, 35, 188)).setCustomBeeModelProvider(new CustomBeeModel("engineer"));
    public static final CareerBeeEntry QUANTUM_CHARM = new CareerBeeEntry("quantum_charm", false, "science", CareerBeeSpecies.col(255, 255, 255), CareerBeeSpecies.col(0, 0, 0)).setCustomBeeSpriteColourProvider(new QuantumBeeColors(0.0f, 0.666f, 0.5f)).setTemplateEffect(() -> EffectRandomSwap.INSTANCE).setTemplateAllelleString(EnumBeeChromosome.SPEED, "forestry.speedFast").setTemplateAllelleString(EnumBeeChromosome.FERTILITY, "forestry.fertilityHigh").setTemplateAllelleString(EnumBeeChromosome.TEMPERATURE_TOLERANCE, "forestry.toleranceDown1").setTemplateAllelleString(EnumBeeChromosome.HUMIDITY_TOLERANCE, "forestry.toleranceUp1").setTemplateAllelleBool(EnumBeeChromosome.NEVER_SLEEPS, true).setTemplateAllelleBool(EnumBeeChromosome.TOLERATES_RAIN, false).setTemplateAllelleBool(EnumBeeChromosome.CAVE_DWELLING, true).setTemplateAllelleString(EnumBeeChromosome.FLOWERING, "forestry.floweringFast").setTemplateAllelleString(EnumBeeChromosome.TERRITORY, "forestry.territoryAverage").setTemplateAllelleString(EnumBeeChromosome.SPEED, "forestry.speedFast").removeVanillaProducts().addProduct(ItemIngredients.IngredientType.YING.get(), Float.valueOf(0.1f));
    public static final CareerBeeEntry QUANTUM_STRANGE = new CareerBeeEntry("quantum_strange", false, "science", CareerBeeSpecies.col(0, 0, 0), CareerBeeSpecies.col(255, 255, 255)).setCustomBeeSpriteColourProvider(new QuantumBeeColors(3.141f, 0.0f, 0.5f)).setTemplateEffect(() -> EffectRandomSwap.INSTANCE).setTemplateAllelleString(EnumBeeChromosome.SPEED, "forestry.speedSlow").setTemplateAllelleString(EnumBeeChromosome.FERTILITY, "forestry.fertilityHigh").setTemplateAllelleString(EnumBeeChromosome.TEMPERATURE_TOLERANCE, "forestry.toleranceUp1").setTemplateAllelleString(EnumBeeChromosome.HUMIDITY_TOLERANCE, "forestry.toleranceDown1").setTemplateAllelleBool(EnumBeeChromosome.NEVER_SLEEPS, false).setTemplateAllelleBool(EnumBeeChromosome.TOLERATES_RAIN, true).setTemplateAllelleBool(EnumBeeChromosome.CAVE_DWELLING, false).setTemplateAllelleString(EnumBeeChromosome.FLOWERING, "forestry.floweringSlow").setTemplateAllelleString(EnumBeeChromosome.TERRITORY, "forestry.territoryAverage").setTemplateAllelleString(EnumBeeChromosome.SPEED, "forestry.speedSlow").removeVanillaProducts().addProduct(ItemIngredients.IngredientType.YANG.get(), Float.valueOf(0.1f));
    public static final CareerBeeEntry MAD_SCIENTIST = new CareerBeeEntry("mad_scientist", false, "science", CareerBeeSpecies.col(84, 121, 132)).setCustomBeeModelProvider(new CustomBeeModel("mad_scientist")).setTemplateEffect(() -> EffectExplosion.INSTANCE);
    public static final CareerBeeEntry BENSEN = new CareerBeeEntry("bensen", true, "jazz", CareerBeeSpecies.col(255, 255, 255), CareerBeeSpecies.col(94, 46, 24)).setCustomBeeModelProvider(new CustomBeeModel("bensen")).setTemplateEffect(() -> EffectJazz.INSTANCE).setIsSecret();
    public static final CareerBeeEntry ELECTRICIAN = new CareerBeeEntry("electrician", false, "lightning", CareerBeeSpecies.col(255, 253, 234)).setCustomBeeModelProvider(new CustomBeeModel("electrician")).setTemplateEffect(() -> EffectElectrifying.INSTANCE);
    public static final CareerBeeEntry ASSASSIN = new CareerBeeEntry("assassin", false, "stab", CareerBeeSpecies.col(144, 47, 153)).setCustomBeeModelProvider(new CustomBeeModel("assassin")).setTemplateEffect(() -> EffectAssassin.INSTANCE);
    public static final CareerBeeEntry ROBOT = new CareerBeeEntry("robot", false, "beepboop", CareerBeeSpecies.col(70, 76, 81), CareerBeeSpecies.col(151, 175, 200)).setCustomBeeModelProvider(new CustomBeeModel("bender")).setTemplate(EnumBeeChromosome.SPEED, () -> SpecialProperties.ROBO_SPEED);
    public static final CareerBeeEntry DEVIL = new CareerBeeEntry("devil", false, "evil", CareerBeeSpecies.col(76, 0, 0), CareerBeeSpecies.col(255, 0, 0)).setCustomBeeModelProvider(new CustomBeeModel("devil")).setTemplateEffect(() -> EffectBurning.INSTANCE);
    public static final CareerBeeEntry PRIEST = new CareerBeeEntry("priest", false, "priestly", CareerBeeSpecies.col(144, 47, 153)).setCustomBeeModelProvider(new CustomBeeModel("priest")).setTemplateEffect(() -> EffectPriest.INSTANCE);
    public static final CareerBeeEntry POLITICIAN = new CareerBeeEntry("politician", false, "evil", CareerBeeSpecies.col(43, 69, 145)).setCustomBeeModelProvider(new CustomBeeModel("politician")).setTemplateEffect(() -> EffectPolitics.INSTANCE);
    public static final CareerBeeEntry NCA = new CareerBeeEntry("nca", false, "evil", CareerBeeSpecies.col(91, 212, 75), CareerBeeSpecies.col(26, 171, 25)).setCustomBeeModelProvider(new CustomBeeModel("creeper")).setTemplateEffect(() -> EffectCreeper.INSTANCE);
    static final BeeMutationTree tree = new BeeMutationTree();
    public static ArrayList<CareerBeeEntry> sorted_bee_entries;

    public static void register() {
        SpecialProperties.init();
        sorted_bee_entries = Lists.newArrayList(CareerBeeEntry.BEE_ENTRIES);
        Map<CareerBeeEntry, Integer> bee_complexity = sorted_bee_entries.stream().collect(Collectors.toMap(t -> t, s -> tree.getLeastParents((BeeMutationTree.SpeciesEntry)s).stream().mapToInt(Set::size).min().orElse(0)));
        Map<String, Double> bee_model_complexity = sorted_bee_entries.stream().collect(Collectors.groupingBy(s -> s.modelName, Collectors.collectingAndThen(Collectors.mapping(bee_complexity::get, Collectors.toList()), s -> s.stream().mapToInt(Integer::intValue).average().orElseThrow(RuntimeException::new))));
        sorted_bee_entries.sort(Comparator.comparing(CareerBeeEntry::isSecret).thenComparingDouble(t -> (Double)bee_model_complexity.get(t.modelName)).thenComparingInt(bee_complexity::get));
        sorted_bee_entries.forEach(CareerBeeEntry::build);
        CareerBeeEntry.BEE_ENTRIES.forEach(CareerBeeEntry::init);
        registeredSpecies.addAll(sorted_bee_entries.stream().map(t -> t.species).filter(Objects::nonNull).collect(Collectors.toSet()));
        PlayerSpawnHandler.registerBeeSpawn("dire", UUID.fromString("BBB87DBE-690F-4205-BDC5-72FFB8EBC29D"), DIRE);
        PlayerSpawnHandler.registerBeeSpawn("soaryn", UUID.fromString("4F3A8D1E-33C1-44E7-BCE8-E683027C7DAC"), SOARYN);
        PlayerSpawnHandler.registerBeeSpawn("rwtema", UUID.fromString("72DDAA05-7BBE-4AE2-9892-2C8D90EA0AD8"), ACCELERATION);
        if (BeeMod.deobf_folder) {
            StringBuilder[] strings = new StringBuilder[EnumBeeChromosome.values().length];
            for (int i = 0; i < EnumBeeChromosome.values().length; ++i) {
                strings[i] = new StringBuilder();
            }
            ArrayList registeredAlleles = Lists.newArrayList((Iterable)AlleleManager.alleleRegistry.getRegisteredAlleles((IChromosomeType)EnumBeeChromosome.SPECIES));
            registeredAlleles.sort(Comparator.comparing(IAllele::getModID).thenComparing(IAllele::getUID));
            for (IAlleleBeeSpecies iAllele : registeredAlleles) {
                IAllele[] template = BeeManager.beeRoot.getTemplate((IAlleleSpecies)iAllele);
                for (int i = 0; i < EnumBeeChromosome.values().length; ++i) {
                    EnumBeeChromosome chromosome = EnumBeeChromosome.values()[i];
                    HashMap<String, String> abbreviate = StringHelper.abbreviate(AlleleManager.alleleRegistry.getRegisteredAlleles((IChromosomeType)chromosome).stream().map(IAllele::getAlleleName)::iterator);
                    strings[i].append("\t").append(abbreviate.get(template[i].getAlleleName()));
                }
            }
            for (StringBuilder string : strings) {
                BeeMod.logger.info(string.toString());
            }
        }
        tree.registerMutations();
        if (BeeMod.deobf_folder) {
            BeeMod.logger.info(sorted_bee_entries.stream().map(CareerBeeEntry::get).map(IAllele::getAlleleName).collect(Collectors.joining("\n")));
            BeeMod.logger.info(sorted_bee_entries.stream().map(c -> {
                IAlleleBeeSpecies t = c.get();
                String alleleName = t.getAlleleName();
                Collection paths = BeeManager.beeRoot.getPaths((IAllele)t, (IChromosomeType)EnumBeeChromosome.SPECIES);
                if (paths.isEmpty()) {
                    return alleleName;
                }
                String mutationString = paths.stream().map(t2 -> {
                    String s = t2.getAllele0().getAlleleName() + " + " + t2.getAllele1().getAlleleName();
                    if (t2.getSpecialConditions().isEmpty()) {
                        return s;
                    }
                    return s + " " + t2.getSpecialConditions().stream().collect(Collectors.joining(", ", "(", ")"));
                }).collect(Collectors.joining(" "));
                String s = alleleName + " Bees:  " + mutationString + "\n - " + t.getDescription();
                EffectBase effectBase = EffectBase.registeredEffectSpecies.get(t);
                if (effectBase != null) {
                    s = s + "\n" + effectBase.getAlleleName() + ": " + I18n.func_135052_a((String)(effectBase.getUnlocalizedName() + ".desc"), (Object[])new Object[0]);
                }
                return s;
            }).collect(Collectors.joining("\n\n")));
        }
    }

    public static void init() {
        CareerBeeEntry.BEE_ENTRIES.forEach(CareerBeeEntry::preInit);
        CareerBeeSpecies.buildMutationList();
    }

    public static void buildMutationList() {
        BeeMutationTree.SpeciesEntry COMMON = CareerBeeSpecies.getSpecies("forestry.speciesCommon");
        BeeMutationTree.SpeciesEntry CULTIVATED = CareerBeeSpecies.getSpecies("forestry.speciesCultivated");
        BeeMutationTree.SpeciesEntry NOBLE = CareerBeeSpecies.getSpecies("forestry.speciesNoble");
        tree.add(COMMON, CULTIVATED, STUDENT, 1.0, v -> v.requireResource(new IBlockState[]{Blocks.field_150342_X.func_176223_P()}));
        tree.add(STUDENT, COMMON, VOCATIONAL, 0.5);
        tree.add(VOCATIONAL, ENGINEER, DIGGING_BASE, 0.1, v -> v.requireResource("blockIron"));
        tree.add(ENGINEER, DIGGING_BASE, DIGGING_SILKY, 0.1, v -> v.requireResource("blockGold"));
        tree.add(DIGGING_BASE, DIGGING_SILKY, DIGGING_FORTUNE, 0.1, v -> v.requireResource("blockDiamond"));
        tree.add(VOCATIONAL, CareerBeeSpecies.getFSpecies("Valiant"), POLICE, 0.1);
        tree.add(CareerBeeSpecies.getFSpecies("Sinister"), POLICE, THIEF, 0.1);
        tree.add(VOCATIONAL, VOCATIONAL, ARMORER, 0.1, v -> v.requireResource((IBlockState[])Blocks.field_150467_bQ.func_176194_O().func_177619_a().stream().toArray(IBlockState[]::new)));
        tree.add(VOCATIONAL, ARMORER, SHARPENER, 0.1);
        tree.add(ARMORER, SHARPENER, REPAIR, 0.05);
        tree.add(VOCATIONAL, CareerBeeSpecies.getFSpecies("Forest"), LUMBER, 0.5);
        tree.add(VOCATIONAL, LUMBER, BUTCHER, 0.5);
        tree.add(VOCATIONAL, CareerBeeSpecies.getFSpecies("Meadows"), HUSBANDRYIST, 0.5);
        tree.add(STUDENT, HUSBANDRYIST, YENTE, 0.5);
        tree.add(YENTE, VOCATIONAL, PRIEST, 0.2);
        tree.add(STUDENT, COMMON, WOMBLING, 0.5);
        tree.add(VOCATIONAL, SMELTER, MASON, 0.5);
        tree.add(SMELTER, ARTIST, COOK, 0.2);
        tree.add(ARTIST, CareerBeeSpecies.getFSpecies("Boggy"), BENSEN, 0.01);
        tree.add(SMELTER, VOCATIONAL, HONEY_SMELTER, 0.2);
        tree.add(VOCATIONAL, CareerBeeSpecies.getFSpecies("Modest"), SMELTER, 0.5, v -> v.requireResource(BlockStateList.of(Blocks.field_150460_al, Blocks.field_150470_am)));
        tree.add(MASON, SHARPENER, ORE_CRUSHER, 0.1);
        tree.add(STUDENT, VOCATIONAL, PHD, 0.3);
        tree.add(PHD, CareerBeeSpecies.getFSpecies("Industrious"), SCIENTIST, 0.2);
        tree.add(SMELTER, CareerBeeSpecies.getFSpecies("Demonic"), DEVIL, 0.05);
        tree.add(DEVIL, THIEF, POLITICIAN, 0.1);
        tree.add(DEVIL, POLITICIAN, NCA, 0.1);
        tree.add(DEVIL, POLICE, ASSASSIN, 0.2);
        tree.add(PHD, CareerBeeSpecies.getFSpecies("Imperial"), BUISNESS, 0.2);
        tree.add(COMMON, BUISNESS, JUNK, 0.4);
        tree.add(PHD, CareerBeeSpecies.getFSpecies("Noble"), ENGINEER, 0.3);
        tree.add(ENGINEER, SMELTER, CLOCKWORK, 0.2);
        tree.add(ENGINEER, CLOCKWORK, ELECTRICIAN, 0.2);
        tree.add(ELECTRICIAN, CLOCKWORK, ROBOT, 0.2);
        tree.add(REPAIR, CLOCKWORK, ENERGY, 0.05);
        tree.add(PHD, CareerBeeSpecies.getFSpecies("Majestic"), DOCTOR, 0.3);
        tree.add(DOCTOR, CareerBeeSpecies.getFSpecies("Sinister"), PLAGUE_DOCTOR, 0.3);
        tree.add(VOCATIONAL, CareerBeeSpecies.getFSpecies("Cultivated"), ARTIST, 0.4);
        tree.add(ARTIST, PHD, RAINBOW, 0.1);
        tree.add(POLICE, THIEF, TAXCOLLECTOR, 0.2);
        tree.add(MAD_SCIENTIST, CareerBeeSpecies.getFSpecies("Phantasmal"), QUANTUM_STRANGE, 0.5);
        tree.add(MAD_SCIENTIST, CareerBeeSpecies.getFSpecies("Phantasmal"), QUANTUM_CHARM, 0.5);
        tree.add(QUANTUM_CHARM, QUANTUM_CHARM, QUANTUM_STRANGE, 0.5);
        tree.add(QUANTUM_STRANGE, QUANTUM_STRANGE, QUANTUM_CHARM, 0.5);
        tree.add(QUANTUM_STRANGE, QUANTUM_CHARM, ACCELERATION, 0.01);
        tree.add(SCIENTIST, ENGINEER, MAD_SCIENTIST, 1.0, iBeeMutationBuilder -> iBeeMutationBuilder.addMutationCondition((IMutationCondition)new MutationRecentExplosion().forceMutation(MAD_SCIENTIST)));
        if (BeeMod.deobf) {
            HashSet entries = Sets.newHashSet(CareerBeeEntry.BEE_ENTRIES);
            entries.removeAll(CareerBeeSpecies.tree.recipes.keySet());
            entries.remove(STUDENT);
            entries.removeIf(BeeMutationTree.SpeciesEntry::isVanilla);
            BeeMod.logger.info(entries.stream().map(Object::toString).collect(Collectors.joining("\n")));
        }
    }

    @Nonnull
    private static BeeMutationTree.SpeciesEntry getFSpecies(String uuid) {
        return CareerBeeSpecies.getSpecies("forestry.species" + uuid);
    }

    @Nonnull
    private static BeeMutationTree.SpeciesEntry getSpecies(String uuid) {
        return new BeeMutationTree.VanillaEntry(uuid);
    }

    public static IMutationBuilder register(@Nonnull IAlleleBeeSpecies inA, @Nonnull IAlleleBeeSpecies inB, @Nonnull IAlleleBeeSpecies out, int chance) {
        return BeeManager.beeMutationFactory.createMutation(inA, inB, BeeManager.beeRoot.getTemplate((IAlleleSpecies)out), chance);
    }

    public static int col(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }
}

