/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lostcities.config.BiomeSelectionStrategy;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.world.BiomeTranslator;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.WorldTypeTools;
import mcjty.lostcities.dimensions.world.lost.CitySphere;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;

public class LostWorldFilteredBiomeProvider
extends BiomeProvider {
    private final World world;
    private final BiomeProvider original;
    private LostCityChunkGenerator provider;
    private final BiomeTranslator biomeTranslator;
    private final BiomeTranslator outsideTranslator;

    public LostWorldFilteredBiomeProvider(World world, BiomeProvider original, String[] allowedBiomeFactors, String[] manualBiomeMappings, BiomeSelectionStrategy strategy, String[] outsideBiomeFactors, String[] outsideManualBiomeMappings, BiomeSelectionStrategy outsideStrategy) {
        this.world = world;
        this.original = original;
        this.biomeTranslator = new BiomeTranslator(allowedBiomeFactors, manualBiomeMappings, strategy);
        this.outsideTranslator = new BiomeTranslator(outsideBiomeFactors.length == 0 ? allowedBiomeFactors : outsideBiomeFactors, outsideManualBiomeMappings, outsideStrategy);
    }

    private LostCityChunkGenerator getProvider() {
        if (this.provider == null) {
            this.provider = WorldTypeTools.getChunkGenerator(this.world.field_73011_w.getDimension());
        }
        return this.provider;
    }

    public Biome func_180631_a(BlockPos pos) {
        LostCityProfile profile = WorldTypeTools.getProfile(this.world);
        Biome originalBiome = this.original.func_180631_a(pos);
        if (!(this.world instanceof WorldServer)) {
            return originalBiome;
        }
        if (profile.isSpace() && profile.CITYSPHERE_LANDSCAPE_OUTSIDE) {
            int chunkZ;
            int chunkX = pos.func_177958_n() >> 4;
            CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ = pos.func_177952_p() >> 4, this.getProvider());
            if (sphere.isEnabled()) {
                int cz;
                float radius = sphere.getRadius();
                BlockPos cc = sphere.getCenterPos();
                double sqradiusOffset = (radius - 2.0f) * (radius - 2.0f);
                int cx = cc.func_177958_n();
                if (CitySphere.squaredDistance(cx, cz = cc.func_177952_p(), pos.func_177958_n(), pos.func_177952_p()) > sqradiusOffset) {
                    return this.outsideTranslator.translate(originalBiome);
                }
                if (sphere.getBiome() != null) {
                    return sphere.getBiome();
                }
            } else {
                return this.outsideTranslator.translate(originalBiome);
            }
        }
        return this.biomeTranslator.translate(originalBiome);
    }

    private void translateList(Biome[] biomes, int topx, int topz, int width, int height) {
        if (!(this.world instanceof WorldServer)) {
            return;
        }
        LostCityProfile profile = WorldTypeTools.getProfile(this.world);
        if (profile.isSpace() && profile.CITYSPHERE_LANDSCAPE_OUTSIDE) {
            int chunkX = topx >> 4;
            int chunkZ = topz >> 4;
            CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, this.getProvider());
            if (sphere.isEnabled()) {
                float radius = sphere.getRadius();
                double sqradiusOffset = (radius - 2.0f) * (radius - 2.0f);
                BlockPos cc = sphere.getCenterPos();
                int cx = cc.func_177958_n();
                int cz = cc.func_177952_p();
                for (int z = 0; z < height; ++z) {
                    for (int x = 0; x < width; ++x) {
                        int i = x + z * width;
                        biomes[i] = CitySphere.squaredDistance(cx, cz, topx + x, topz + z) > sqradiusOffset ? this.outsideTranslator.translate(biomes[i]) : (sphere.getBiome() != null ? sphere.getBiome() : this.biomeTranslator.translate(biomes[i]));
                    }
                }
            } else {
                for (int i = 0; i < biomes.length; ++i) {
                    biomes[i] = this.outsideTranslator.translate(biomes[i]);
                }
            }
            return;
        }
        for (int i = 0; i < biomes.length; ++i) {
            biomes[i] = this.biomeTranslator.translate(biomes[i]);
        }
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        biomes = this.original.func_76937_a(biomes, x, z, width, height);
        this.translateList(biomes, x, z, width, height);
        return biomes;
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        oldBiomeList = this.original.func_76933_b(oldBiomeList, x, z, width, depth);
        this.translateList(oldBiomeList, x, z, width, depth);
        return oldBiomeList;
    }

    public Biome[] getBiomesAlternate(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        oldBiomeList = this.original.func_76933_b(oldBiomeList, x, z, width, depth);
        for (int i = 0; i < oldBiomeList.length; ++i) {
            oldBiomeList[i] = this.outsideTranslator.translate(oldBiomeList[i]);
        }
        return oldBiomeList;
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        return this.func_76933_b(listToReuse, x, z, width, length);
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        return this.original.func_180630_a(x, z, range, biomes, random);
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        return true;
    }

    public boolean func_190944_c() {
        return false;
    }

    public Biome func_190943_d() {
        return null;
    }
}

