/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.common.MinecraftForge;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.event.PartVariableDrivenVariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanelVariableDriven;

public class ContainerPartDisplay<P extends PartTypePanelVariableDriven<P, S>, S extends PartTypePanelVariableDriven.State<P, S>>
extends ContainerMultipart<P, S> {
    private static final int SLOT_X = 79;
    private static final int SLOT_Y = 8;
    private final int readValueId = this.getNextValueId();
    private final int readColorId = this.getNextValueId();

    public ContainerPartDisplay(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType) {
        super(player, target, partContainer, (PartTypePanelVariableDriven)partType);
        SimpleInventory inventory = ((PartTypePanelVariableDriven.State)this.getPartState()).getInventory();
        inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.addInventory((IInventory)((PartTypePanelVariableDriven.State)this.getPartState()).getInventory(), 0, 80, 14, 1, 1);
        this.addPlayerInventory(player.field_71071_by, 8, 46);
    }

    protected Slot createNewSlot(IInventory inventory, int index, int x, int y) {
        if (inventory instanceof SimpleInventory) {
            return new SlotVariable(inventory, index, x, y);
        }
        return super.createNewSlot(inventory, index, x, y);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!MinecraftHelpers.isClientSide()) {
            String readValue = "";
            int readValueColor = 0;
            if (!NetworkHelpers.shouldWork()) {
                readValue = "SAFE-MODE";
            } else {
                IValue value = ((PartTypePanelVariableDriven.State)this.getPartState()).getDisplayValue();
                if (value != null) {
                    readValue = value.getType().toCompactString(value);
                    readValueColor = value.getType().getDisplayColor();
                }
            }
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readValueId, (String)readValue);
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readColorId, (int)readValueColor);
        }
    }

    public void onDirty() {
        if (!MinecraftHelpers.isClientSide()) {
            ((PartTypePanelVariableDriven.State)this.getPartState()).onVariableContentsUpdated(this.getPartType(), this.getTarget());
            INetwork network = NetworkHelpers.getNetwork(this.getTarget().getCenter());
            if (!((PartTypePanelVariableDriven.State)this.getPartState()).getInventory().func_191420_l()) {
                try {
                    IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(network);
                    IVariable variable = ((PartTypePanelVariableDriven.State)this.getPartState()).getVariable(this.getTarget(), partNetwork);
                    MinecraftForge.EVENT_BUS.post(new PartVariableDrivenVariableContentsUpdatedEvent(network, partNetwork, this.getTarget(), this.getPartType(), this.getPartState(), this.getPlayer(), variable, variable != null ? (IValue)variable.getValue() : null));
                }
                catch (EvaluationException evaluationException) {
                    // empty catch block
                }
            }
            if (network != null) {
                network.getEventBus().post(new VariableContentsUpdatedEvent(network));
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        ((PartTypePanelVariableDriven.State)this.getPartState()).getInventory().removeDirtyMarkListener((IDirtyMarkListener)this);
    }

    protected int getSizeInventory() {
        return ((PartTypePanelVariableDriven.State)this.getPartState()).getInventory().func_70302_i_();
    }

    public String getReadValue() {
        return ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)this.readValueId);
    }

    public int getReadValueColor() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.readColorId);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerPartDisplay)) {
            return false;
        }
        ContainerPartDisplay other = (ContainerPartDisplay)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getReadValueId() != other.getReadValueId()) {
            return false;
        }
        return this.getReadColorId() == other.getReadColorId();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ContainerPartDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReadValueId();
        result = result * 59 + this.getReadColorId();
        return result;
    }

    public int getReadValueId() {
        return this.readValueId;
    }

    public int getReadColorId() {
        return this.readColorId;
    }

    @Override
    public String toString() {
        return "ContainerPartDisplay(readValueId=" + this.getReadValueId() + ", readColorId=" + this.getReadColorId() + ")";
    }
}

