/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.core.evaluate.operator.CurriedOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class ValueHelpers {
    public static IValueType[] from(IVariable ... variables) {
        IValueType[] valueTypes = new IValueType[variables.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IVariable variable = variables[i];
            valueTypes[i] = variable == null ? null : variable.getType();
        }
        return valueTypes;
    }

    public static IValueType[] from(IVariableFacade ... variableFacades) {
        IValueType[] valueTypes = new IValueType[variableFacades.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IVariableFacade variableFacade = variableFacades[i];
            valueTypes[i] = variableFacade == null ? null : variableFacade.getOutputType();
        }
        return valueTypes;
    }

    public static L10NHelpers.UnlocalizedString[] from(IValueType ... valueTypes) {
        L10NHelpers.UnlocalizedString[] names = new L10NHelpers.UnlocalizedString[valueTypes.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IValueType valueType = valueTypes[i];
            names[i] = new L10NHelpers.UnlocalizedString(valueType.getTranslationKey(), new Object[0]);
        }
        return names;
    }

    public static boolean areValuesEqual(@Nullable IValue v1, @Nullable IValue v2) {
        return v1 == null && v2 == null || v1 != null && v2 != null && v1.equals(v2);
    }

    public static boolean correspondsTo(IValueType t1, IValueType t2) {
        return t1.correspondsTo(t2) || t2.correspondsTo(t1);
    }

    public static IValue evaluateOperator(IOperator operator, IValue ... values) throws EvaluationException {
        IVariable[] variables = new IVariable[values.length];
        for (int i = 0; i < variables.length; ++i) {
            IValue value = values[i];
            variables[i] = new Variable<IValue>(value.getType(), value);
        }
        return ValueHelpers.evaluateOperator(operator, variables);
    }

    public static IValue evaluateOperator(IOperator operator, IVariable ... variables) throws EvaluationException {
        if (operator.getRequiredInputLength() == variables.length) {
            return operator.evaluate(variables);
        }
        return ValueTypeOperator.ValueOperator.of(new CurriedOperator(operator, variables));
    }

    public static String serializeRaw(IValue value) {
        String raw = value.getType().serialize(value);
        if (raw.length() >= GeneralConfig.maxValueByteSize) {
            return "TOO LONG";
        }
        return raw;
    }

    public static NBTTagCompound serialize(IValue value) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("valueType", value.getType().getTranslationKey());
        tag.func_74778_a("value", ValueHelpers.serializeRaw(value));
        return tag;
    }

    public static IValue deserialize(NBTTagCompound tag) {
        IValueType valueType = ValueTypes.REGISTRY.getValueType(tag.func_74779_i("valueType"));
        if (valueType == null) {
            return null;
        }
        return ValueHelpers.deserializeRaw(valueType, tag.func_74779_i("value"));
    }

    public static <T extends IValue> T deserializeRaw(IValueType<T> valueType, String valueString) {
        if ("TOO LONG".equals(valueString)) {
            return valueType.getDefault();
        }
        return valueType.deserialize(valueString);
    }

    public static void validatePredicateOutput(IOperator predicate, IValue result) throws EvaluationException {
        if (!(result instanceof ValueTypeBoolean.ValueBoolean)) {
            L10NHelpers.UnlocalizedString error = new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrong_predicate", new Object[]{predicate.getLocalizedNameFull(), result.getType(), ValueTypes.BOOLEAN});
            throw new EvaluationException(error.localize());
        }
    }

    public static Pair<String, Integer> getSafeReadableValue(@Nullable IVariable variable) {
        String readValue = "";
        int readValueColor = 0;
        if (!NetworkHelpers.shouldWork()) {
            readValue = "SAFE-MODE";
        } else if (variable != null) {
            try {
                Object value = variable.getValue();
                readValue = value.getType().toCompactString(value);
                readValueColor = value.getType().getDisplayColor();
            }
            catch (NullPointerException | PartStateException | EvaluationException e) {
                readValue = "ERROR";
                readValueColor = Helpers.RGBToInt((int)255, (int)0, (int)0);
            }
        }
        return Pair.of((Object)readValue, (Object)readValueColor);
    }
}

