/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.crafttweaker;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shetiphian.terraqueous.api.machines.IStormForgeStackHandler;
import shetiphian.terraqueous.common.misc.StormForgeHelper;

class StormForgeStackHandler
implements IStormForgeStackHandler {
    private final IIngredient input;
    private final ItemStack output;
    private final ItemStack altResult;
    private final int ticksToComplete;
    private final boolean lightningStrikeOnComplete;

    StormForgeStackHandler(IItemStack result, IIngredient input, int ticksToComplete, boolean lightningStrikeOnComplete, IItemStack altResult) {
        this.output = CraftTweakerMC.getItemStack((IItemStack)result);
        this.input = input;
        this.altResult = CraftTweakerMC.getItemStack((IItemStack)altResult);
        this.ticksToComplete = Math.max(0, ticksToComplete);
        this.lightningStrikeOnComplete = lightningStrikeOnComplete;
    }

    @Override
    public boolean handleStack(@Nonnull ItemStack stack) {
        return this.input.matches(CraftTweakerMC.getIItemStack((ItemStack)stack));
    }

    @Override
    @Nonnull
    public ItemStack processStack(@Nonnull ItemStack stack, int ticks, boolean struck, World world, BlockPos pos) {
        if (struck && !this.altResult.func_190926_b()) {
            return this.altResult.func_77946_l();
        }
        if (ticks >= this.ticksToComplete || struck) {
            if (this.lightningStrikeOnComplete) {
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false));
                StormForgeHelper.moveFire(world, pos);
            }
            return this.output.func_77946_l();
        }
        return stack;
    }

    @Override
    public boolean isFinished(@Nonnull ItemStack stack, int ticks, boolean struck, World world, BlockPos pos) {
        return ticks >= this.ticksToComplete || struck;
    }

    @Override
    public boolean showBar(@Nonnull ItemStack stack) {
        return true;
    }

    @Override
    public int ticksToComplete(@Nonnull ItemStack stack) {
        return this.ticksToComplete;
    }
}

