/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.block.BlockTypeBase;
import shetiphian.terraqueous.common.tileentity.EnumPassageStatus;
import shetiphian.terraqueous.common.tileentity.TileEntityTypePassageBase;

public class TileEntityTypeDoor
extends TileEntityTypePassageBase {
    private static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    private static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    private static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    public byte style = 0;
    public boolean isTop = false;
    public boolean inverted = false;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("style", this.style);
        nbtTag.func_74757_a("top", this.isTop);
        nbtTag.func_74757_a("inverted", this.inverted);
        nbtTag.func_74774_a("status", this.getStatus().getValue());
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.style = nbtTag.func_74771_c("style");
        this.isTop = nbtTag.func_74767_n("top");
        this.inverted = nbtTag.func_74767_n("inverted");
        this.setStatus(EnumPassageStatus.byValue(nbtTag.func_74771_c("status")));
        this.setSavedType(null);
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        state = ((BlockTypeBase)this.func_145838_q()).getBlockType(state, this.style);
        if (this.getSavedType() == null) {
            String name = "door_" + (this.inverted ? "invert_" : "") + (this.isTop ? "top_" : "bottom_") + this.getFacing().func_176610_l();
            this.setSavedType(BlockTypeBase.EnumType.byName(name));
        }
        return state.func_177226_a(BlockTypeBase.VARIANT, (Comparable)((Object)this.getSavedType()));
    }

    @Override
    public AxisAlignedBB getBoxBounds() {
        switch (this.getFacing()) {
            case SOUTH: {
                return AABB_SOUTH;
            }
            case WEST: {
                return AABB_WEST;
            }
            case NORTH: {
                return AABB_NORTH;
            }
            case EAST: {
                return AABB_EAST;
            }
        }
        return Block.field_185505_j;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, ItemStack heldItem) {
        if (!this.func_145831_w().field_72995_K) {
            EnumPassageStatus newStatus = this.getStatus();
            boolean isOpen = this.getStatus().isOpen();
            boolean isPowered = this.func_145831_w().func_175640_z(this.func_174877_v());
            boolean changeState = true;
            switch (this.getStatus()) {
                case CLOSED: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.OPEN;
                    break;
                }
                case OPEN: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.CLOSED;
                    changeState = !isPowered;
                    break;
                }
                case CLOSED_POWERED: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.CLOSED;
                    changeState = isPowered;
                    break;
                }
                case OPEN_POWERED: {
                    EnumPassageStatus enumPassageStatus = newStatus = isPowered ? EnumPassageStatus.CLOSED_POWERED : EnumPassageStatus.CLOSED;
                }
            }
            if (changeState) {
                switch (this.getFacing()) {
                    case SOUTH: {
                        this.setFacing(this.inverted ? EnumFacing.EAST : EnumFacing.WEST);
                        break;
                    }
                    case WEST: {
                        this.setFacing(this.inverted ? EnumFacing.SOUTH : EnumFacing.NORTH);
                        break;
                    }
                    case NORTH: {
                        this.setFacing(this.inverted ? EnumFacing.WEST : EnumFacing.EAST);
                        break;
                    }
                    case EAST: {
                        this.setFacing(this.inverted ? EnumFacing.NORTH : EnumFacing.SOUTH);
                        break;
                    }
                }
                this.inverted = !this.inverted;
            }
            this.setStatus(newStatus);
            Function.syncTile((TileEntity)this);
            try {
                BlockPos oPos = this.isTop ? this.func_174877_v().func_177977_b() : this.func_174877_v().func_177984_a();
                TileEntityTypeDoor oTile = (TileEntityTypeDoor)this.func_145831_w().func_175625_s(oPos);
                oTile.setFacing(this.getFacing());
                oTile.inverted = this.inverted;
                oTile.setStatus(this.getStatus());
                Function.syncTile((TileEntity)oTile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isOpen != this.getStatus().isOpen()) {
                this.func_145831_w().func_180498_a(null, isOpen ? 1012 : 1006, this.func_174877_v(), 0);
            }
        }
        return true;
    }

    @Override
    public void neighborChanged(Block neighbor) {
        boolean isPowered;
        if (this.isTop) {
            if (this.func_145831_w().func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c() != this.func_145838_q()) {
                Function.removeBlock((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (boolean)true);
            }
        } else if (this.func_145831_w().func_180495_p(this.func_174877_v().func_177984_a()).func_177230_c() != this.func_145838_q()) {
            Function.removeBlock((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (boolean)true);
        } else if (this.func_145831_w().func_175623_d(this.func_174877_v().func_177977_b())) {
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)this.pickBlock(null, null));
            Function.removeBlock((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (boolean)true);
        }
        if ((isPowered = this.func_145831_w().func_175640_z(this.func_174877_v())) && !this.getStatus().isPowered() || !isPowered && this.getStatus().isPowered()) {
            this.blockActivated(null, null);
        }
    }

    @Override
    public boolean blockMovementAI() {
        return !this.getStatus().isOpen();
    }

    @Override
    public int getDamageValue() {
        return super.getDamageValue() + this.style;
    }
}

