/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockCrafting;
import shetiphian.terraqueous.common.tileentity.TileEntitySFStatic;

public class StormForgeHelper {
    private static StormForgeHelper INSTANCE = new StormForgeHelper();
    private static Map<String, Byte> mapBuiltToIndex = new HashMap<String, Byte>();
    private static Map<String, Byte> mapBrokenToIndex = new HashMap<String, Byte>();
    private static SFBlock[] blockStormForge = StormForgeHelper.populateArray();
    private static final byte[] mapSFBase = new byte[]{13, 18, 34, 34, 34, 34, 34, 18, 14, 17, 21, 28, 28, 29, 26, 26, 22, 19, 33, 25, 37, 37, 25, 37, 37, 25, 35, 33, 25, 37, 37, 25, 37, 37, 25, 35, 33, 32, 28, 28, 38, 26, 26, 30, 35, 33, 27, 37, 37, 27, 37, 37, 27, 35, 33, 27, 37, 37, 27, 37, 37, 27, 35, 17, 24, 28, 28, 31, 26, 26, 23, 19, 16, 20, 36, 36, 36, 36, 36, 20, 15};
    private static final byte[] mapSFRise = new byte[]{1, 2, -1, -1, -1, -1, -1, 1, 2, 4, 3, -1, -1, -1, -1, -1, 4, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, -1, -1, 1, 2, 4, 3, -1, -1, -1, -1, -1, 4, 3};
    private static final byte[] mapSFTop = new byte[]{1, 9, -1, -1, -1, -1, -1, 10, 2, 9, 5, -1, -1, -1, -1, -1, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 12, 8, -1, -1, -1, -1, -1, 7, 11, 4, 12, -1, -1, -1, -1, -1, 11, 3};

    public static boolean createStormForge(World world, BlockPos pos) {
        return INSTANCE.sfScanner(world, pos, EnumMode.SCAN_BUILD, true);
    }

    public static boolean removeStormForge(World world, BlockPos pos) {
        return INSTANCE.sfScanner(world, pos, EnumMode.REMOVE, true);
    }

    public static SFBlock getSFBlock(byte sfbId) {
        sfbId = (byte)MathHelper.func_76125_a((int)sfbId, (int)0, (int)(blockStormForge.length - 1));
        return blockStormForge[sfbId];
    }

    public static SFBlock getSFBlockByName(String name) {
        byte sfbId = 0;
        if (mapBuiltToIndex.containsKey(name)) {
            sfbId = mapBuiltToIndex.get(name);
        } else if (mapBrokenToIndex.containsKey(name)) {
            sfbId = mapBrokenToIndex.get(name);
        }
        return StormForgeHelper.getSFBlock(sfbId);
    }

    public static SFBlock getSFBlockByIndex(int layer, int index) {
        layer = MathHelper.func_76125_a((int)layer, (int)0, (int)7);
        index = MathHelper.func_76125_a((int)index, (int)0, (int)80);
        byte sfbId = layer == 0 ? mapSFBase[index] : (layer > 5 ? mapSFTop[index] : mapSFRise[index]);
        if (layer == 6) {
            sfbId = sfbId > 0 && sfbId < 5 ? (byte)0 : sfbId;
        } else if (layer == 7) {
            sfbId = (byte)(sfbId == -1 || sfbId > 4 ? -1 : sfbId + 4);
        }
        return sfbId < 0 ? null : blockStormForge[sfbId];
    }

    public static void moveFire(World world, BlockPos pos) {
        for (int sZ = -4; sZ < 5; sZ = (int)((byte)(sZ + 1))) {
            for (int sX = -4; sX < 5; sX = (int)((byte)(sX + 1))) {
                Block block;
                BlockPos place = pos.func_177982_a(sX, -1, sZ);
                int index = (sZ + 4) * 9 + (sX + 4);
                byte sfbId = mapSFBase[index];
                place = place.func_177984_a();
                if ((sfbId >= 25 && sfbId <= 32 || sfbId == 37) && ((block = world.func_180495_p(place).func_177230_c()) == Blocks.field_150480_ab || block instanceof BlockFire)) {
                    Function.removeBlock((World)world, (BlockPos)place, (boolean)true);
                }
                if (sfbId < 33 || sfbId > 36 || !world.func_175623_d(place)) continue;
                Function.setBlock((World)world, (BlockPos)place, (IBlockState)Blocks.field_150480_ab.func_176223_P(), (boolean)true);
            }
        }
    }

    private boolean sfScanner(World world, BlockPos pos, EnumMode mode, boolean doStrike) {
        for (int sY = -1; sY < 7; sY = (int)((byte)(sY + 1))) {
            for (int sZ = -4; sZ < 5; sZ = (int)((byte)(sZ + 1))) {
                block7: for (int sX = -4; sX < 5; sX = (int)((byte)(sX + 1))) {
                    BlockPos place = new BlockPos(pos.func_177958_n() + sX, pos.func_177956_o() + sY, pos.func_177952_p() + sZ);
                    if (place == pos) continue;
                    int index = (sZ + 4) * 9 + (sX + 4);
                    byte sfbId = sY == -1 ? mapSFBase[index] : (sY > 4 ? mapSFTop[index] : mapSFRise[index]);
                    if (sY == 5) {
                        sfbId = sfbId > 0 && sfbId < 5 ? (byte)0 : sfbId;
                    } else if (sY == 6) {
                        sfbId = (byte)(sfbId == -1 || sfbId > 4 ? -1 : sfbId + 4);
                    }
                    switch (mode) {
                        case SCAN: 
                        case SCAN_BUILD: {
                            if (this.spotCheck(world, place, sfbId)) continue block7;
                            return false;
                        }
                        case BUILD: {
                            this.placeStormForgeBlock(world, place, sfbId, !(sX != -3 && sX != 3 || sZ != -3 && sZ != 3), pos);
                            continue block7;
                        }
                        case REMOVE: {
                            this.removeStormForgeBlock(world, place, sfbId);
                        }
                    }
                }
            }
        }
        if (mode == EnumMode.SCAN_BUILD) {
            this.sfScanner(world, pos, EnumMode.BUILD, doStrike);
        }
        if (mode == EnumMode.BUILD) {
            IBlockState sfb = Values.blockCrafting.func_176223_P().func_177226_a(BlockCrafting.VARIANT, (Comparable)((Object)BlockCrafting.EnumType.SF_ALTER)).func_177226_a((IProperty)BlockCrafting.FACING, (Comparable)EnumFacing.func_176731_b((int)Function.random.nextInt(4)));
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)sfb, (boolean)false);
            if (doStrike) {
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, false));
            }
        }
        if (mode == EnumMode.BUILD || mode == EnumMode.REMOVE) {
            world.func_175704_b(pos.func_177982_a(-4, -1, -4), pos.func_177982_a(4, 8, 4));
        }
        return true;
    }

    private boolean spotCheck(World world, BlockPos pos, byte sfbId) {
        if (sfbId == -1) {
            return world.func_175623_d(pos);
        }
        IBlockState sfbs = blockStormForge[sfbId].getSourceBlock();
        IBlockState place = world.func_180495_p(pos);
        if (sfbs.func_177230_c() == Blocks.field_150355_j) {
            Block block = place.func_177230_c();
            return block == Blocks.field_150432_aD || block == Blocks.field_150355_j;
        }
        return place == sfbs;
    }

    private void placeStormForgeBlock(World world, BlockPos pos, byte sfbId, boolean doStrike, BlockPos alter) {
        if (sfbId == -1) {
            return;
        }
        SFBlock sfb = blockStormForge[sfbId];
        IBlockState sfbs = sfb.getForgeBlock();
        Function.setBlock((World)world, (BlockPos)pos, (IBlockState)sfbs, (boolean)false);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntitySFStatic) {
            ((TileEntitySFStatic)tile).setFacing(sfb.getFacing());
            ((TileEntitySFStatic)tile).setAlterPos(alter);
            ((TileEntitySFStatic)tile).setID(sfbId);
        }
        if (doStrike) {
            world.func_72942_c((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, false));
        }
    }

    private void removeStormForgeBlock(World world, BlockPos pos, byte sfbId) {
        if (sfbId == -1) {
            return;
        }
        IBlockState sfsb = blockStormForge[sfbId].getSourceBlock();
        Function.setBlock((World)world, (BlockPos)pos, (IBlockState)sfsb, (boolean)false);
    }

    public static boolean repairStormForge(World world, BlockPos pos) {
        BlockPos alter;
        IBlockState state;
        if (world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if ((state = world.func_180495_p(pos)).func_177230_c() != Values.blockCrafting) {
            return false;
        }
        int metadata = state.func_177230_c().func_176201_c(state);
        if (metadata < 14) {
            return false;
        }
        if (metadata == 15) {
            INSTANCE.sfScanner(world, pos, EnumMode.BUILD, false);
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntitySFStatic && (alter = ((TileEntitySFStatic)tile).getAlterPos()) != null) {
            INSTANCE.sfScanner(world, pos, EnumMode.BUILD, false);
            return true;
        }
        return false;
    }

    private static SFBlock[] populateArray() {
        SFBlock[] array = new SFBlock[]{new SFBlock(Blocks.field_150371_ca, 0, BlockCrafting.EnumType.SF_MONOLITH_SMOOTH, BlockCrafting.EnumType.SF_BROKEN_MONOLITH_SMOOTH, null), new SFBlock(Blocks.field_150371_ca, 1, BlockCrafting.EnumType.SF_MONOLITH, BlockCrafting.EnumType.SF_BROKEN_MONOLITH, EnumFacing.NORTH), new SFBlock(Blocks.field_150371_ca, 1, BlockCrafting.EnumType.SF_MONOLITH, BlockCrafting.EnumType.SF_BROKEN_MONOLITH, EnumFacing.EAST), new SFBlock(Blocks.field_150371_ca, 1, BlockCrafting.EnumType.SF_MONOLITH, BlockCrafting.EnumType.SF_BROKEN_MONOLITH, EnumFacing.SOUTH), new SFBlock(Blocks.field_150371_ca, 1, BlockCrafting.EnumType.SF_MONOLITH, BlockCrafting.EnumType.SF_BROKEN_MONOLITH, EnumFacing.WEST), new SFBlock(Blocks.field_150371_ca, 0, BlockCrafting.EnumType.SF_LOWPEAK, BlockCrafting.EnumType.SF_BROKEN_LOWPEAK, EnumFacing.NORTH), new SFBlock(Blocks.field_150371_ca, 0, BlockCrafting.EnumType.SF_LOWPEAK, BlockCrafting.EnumType.SF_BROKEN_LOWPEAK, EnumFacing.EAST), new SFBlock(Blocks.field_150371_ca, 0, BlockCrafting.EnumType.SF_LOWPEAK, BlockCrafting.EnumType.SF_BROKEN_LOWPEAK, EnumFacing.SOUTH), new SFBlock(Blocks.field_150371_ca, 0, BlockCrafting.EnumType.SF_LOWPEAK, BlockCrafting.EnumType.SF_BROKEN_LOWPEAK, EnumFacing.WEST), new SFBlock(Blocks.field_150371_ca, 0, BlockCrafting.EnumType.SF_HIGHPEAK, BlockCrafting.EnumType.SF_BROKEN_HIGHPEAK, EnumFacing.NORTH), new SFBlock(Blocks.field_150371_ca, 0, BlockCrafting.EnumType.SF_HIGHPEAK, BlockCrafting.EnumType.SF_BROKEN_HIGHPEAK, EnumFacing.EAST), new SFBlock(Blocks.field_150371_ca, 0, BlockCrafting.EnumType.SF_HIGHPEAK, BlockCrafting.EnumType.SF_BROKEN_HIGHPEAK, EnumFacing.SOUTH), new SFBlock(Blocks.field_150371_ca, 0, BlockCrafting.EnumType.SF_HIGHPEAK, BlockCrafting.EnumType.SF_BROKEN_HIGHPEAK, EnumFacing.WEST), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_CORNER, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_CORNER, EnumFacing.NORTH), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_CORNER, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_CORNER, EnumFacing.EAST), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_CORNER, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_CORNER, EnumFacing.SOUTH), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_CORNER, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_CORNER, EnumFacing.WEST), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_EDGE, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_EDGE, EnumFacing.NORTH), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_EDGE, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_EDGE, EnumFacing.EAST), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_EDGE, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_EDGE, EnumFacing.SOUTH), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_EDGE, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_EDGE, EnumFacing.WEST), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_AQUA, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_AQUA, EnumFacing.NORTH), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_AQUA, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_AQUA, EnumFacing.EAST), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_AQUA, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_AQUA, EnumFacing.SOUTH), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_PLATFORM_AQUA, BlockCrafting.EnumType.SF_BROKEN_PLATFORM_AQUA, EnumFacing.WEST), new SFBlock(Blocks.field_150359_w, 0, BlockCrafting.EnumType.SF_AQUADUCT, BlockCrafting.EnumType.SF_BROKEN_AQUADUCT, EnumFacing.NORTH), new SFBlock(Blocks.field_150359_w, 0, BlockCrafting.EnumType.SF_AQUADUCT, BlockCrafting.EnumType.SF_BROKEN_AQUADUCT, EnumFacing.EAST), new SFBlock(Blocks.field_150359_w, 0, BlockCrafting.EnumType.SF_AQUADUCT, BlockCrafting.EnumType.SF_BROKEN_AQUADUCT, EnumFacing.SOUTH), new SFBlock(Blocks.field_150359_w, 0, BlockCrafting.EnumType.SF_AQUADUCT, BlockCrafting.EnumType.SF_BROKEN_AQUADUCT, EnumFacing.WEST), new SFBlock((Block)Blocks.field_150355_j, 0, BlockCrafting.EnumType.SF_AQUADUCT_T, BlockCrafting.EnumType.SF_BROKEN_AQUADUCT_T, EnumFacing.NORTH), new SFBlock((Block)Blocks.field_150355_j, 0, BlockCrafting.EnumType.SF_AQUADUCT_T, BlockCrafting.EnumType.SF_BROKEN_AQUADUCT_T, EnumFacing.EAST), new SFBlock((Block)Blocks.field_150355_j, 0, BlockCrafting.EnumType.SF_AQUADUCT_T, BlockCrafting.EnumType.SF_BROKEN_AQUADUCT_T, EnumFacing.SOUTH), new SFBlock((Block)Blocks.field_150355_j, 0, BlockCrafting.EnumType.SF_AQUADUCT_T, BlockCrafting.EnumType.SF_BROKEN_AQUADUCT_T, EnumFacing.WEST), new SFBlock(Values.blockEarthOre, 4, BlockCrafting.EnumType.SF_BASE_EDGE, BlockCrafting.EnumType.SF_BROKEN_BASE_EDGE, EnumFacing.NORTH), new SFBlock(Values.blockEarthOre, 4, BlockCrafting.EnumType.SF_BASE_EDGE, BlockCrafting.EnumType.SF_BROKEN_BASE_EDGE, EnumFacing.EAST), new SFBlock(Values.blockEarthOre, 4, BlockCrafting.EnumType.SF_BASE_EDGE, BlockCrafting.EnumType.SF_BROKEN_BASE_EDGE, EnumFacing.SOUTH), new SFBlock(Values.blockEarthOre, 4, BlockCrafting.EnumType.SF_BASE_EDGE, BlockCrafting.EnumType.SF_BROKEN_BASE_EDGE, EnumFacing.WEST), new SFBlock(Blocks.field_150340_R, 0, BlockCrafting.EnumType.SF_BASE_FILL, BlockCrafting.EnumType.SF_BROKEN_BASE_FILL, null), new SFBlock(Values.blockEarthOre, 3, BlockCrafting.EnumType.SF_BASE_CENTER, BlockCrafting.EnumType.SF_BROKEN_BASE_CENTER, null)};
        StormForgeHelper.populateMaps(array);
        return array;
    }

    private static void populateMaps(SFBlock[] array) {
        mapBuiltToIndex.clear();
        mapBrokenToIndex.clear();
        byte counter = 0;
        for (SFBlock sfb : array) {
            String name = ((BlockCrafting.EnumType)((Object)sfb.forgeBlock.func_177229_b(BlockCrafting.VARIANT))).toString();
            if (!mapBuiltToIndex.containsKey(name)) {
                mapBuiltToIndex.put(name, counter);
            }
            if (!mapBrokenToIndex.containsKey(name = ((BlockCrafting.EnumType)((Object)sfb.brokenBlock.func_177229_b(BlockCrafting.VARIANT))).toString())) {
                mapBrokenToIndex.put(name, counter);
            }
            counter = (byte)(counter + 1);
        }
    }

    public static class SFBlock {
        private final Block sourceBlock;
        private final byte sourceMeta;
        private final IBlockState forgeBlock;
        private final IBlockState brokenBlock;
        private final EnumFacing blockFacing;

        SFBlock(Block sourceBlock, int sourceMeta, BlockCrafting.EnumType placeType, BlockCrafting.EnumType brokenType, EnumFacing facing) {
            this.sourceBlock = sourceBlock;
            this.sourceMeta = (byte)MathHelper.func_76125_a((int)sourceMeta, (int)0, (int)15);
            this.forgeBlock = Values.blockCrafting.func_176223_P().func_177226_a(BlockCrafting.VARIANT, (Comparable)((Object)placeType));
            this.brokenBlock = Values.blockCrafting.func_176223_P().func_177226_a(BlockCrafting.VARIANT, (Comparable)((Object)brokenType));
            this.blockFacing = facing;
        }

        public ItemStack getSourceStack() {
            if (this.sourceBlock == Blocks.field_150355_j) {
                return new ItemStack(Blocks.field_150432_aD);
            }
            return new ItemStack(this.sourceBlock, 1, (int)this.sourceMeta);
        }

        public IBlockState getSourceBlock() {
            return this.sourceBlock.func_176203_a((int)this.sourceMeta);
        }

        public IBlockState getForgeBlock() {
            return this.geBlockWithRotation(this.forgeBlock, null);
        }

        public IBlockState getForgeBlockWithRotation(EnumFacing facing) {
            return this.geBlockWithRotation(this.forgeBlock, facing);
        }

        public IBlockState getBrokenBlock() {
            return this.geBlockWithRotation(this.brokenBlock, null);
        }

        public IBlockState getBrokenBlockWithRotation(EnumFacing facing) {
            return this.geBlockWithRotation(this.brokenBlock, facing);
        }

        private IBlockState geBlockWithRotation(IBlockState state, EnumFacing rotation) {
            if (rotation == null) {
                rotation = this.getFacing();
            }
            return state.func_177226_a((IProperty)BlockCrafting.FACING, (Comparable)rotation);
        }

        public EnumFacing getFacing() {
            return this.blockFacing != null ? this.blockFacing : EnumFacing.func_176731_b((int)Function.random.nextInt(4));
        }
    }

    private static enum EnumMode {
        SCAN,
        SCAN_BUILD,
        BUILD,
        REMOVE;

    }
}

