/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import shetiphian.core.common.MyDamageSource;
import shetiphian.terraqueous.common.misc.FoodAction;

public class FoodData {
    private final String name;
    private String model;
    private int healAmount = 1;
    private float saturationModifier = 1.0f;
    private boolean[] dietInfo = new boolean[5];
    private ItemStack returnedItem = null;
    private EnumAction useAction = EnumAction.EAT;
    private int useDuration = 32;
    private int stackLimit = 64;
    private boolean alwaysEdible = false;
    private MyDamageSource damageSource = null;
    private float damageAmount = 0.0f;
    private FoodAction foodUseAction;
    private FoodAction foodFinishAction;
    private String tooltip;

    public FoodData(String name) {
        this.name = name;
        this.model = name;
    }

    public String getName() {
        return this.name;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    public FoodData setHealAmount(int healAmount) {
        this.healAmount = healAmount;
        return this;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public FoodData setSaturationModifier(float saturationModifier) {
        this.saturationModifier = saturationModifier;
        return this;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public FoodData setDietInfo(boolean herbivore, boolean omnivore, boolean carnivore, boolean mechavore, boolean sickIfEat) {
        this.dietInfo = new boolean[]{herbivore, omnivore, carnivore, mechavore, sickIfEat};
        return this;
    }

    public boolean[] getDietInfo() {
        return this.dietInfo;
    }

    public FoodData setReturnedItem(ItemStack returnedItem) {
        this.returnedItem = returnedItem;
        return this;
    }

    public FoodData setReturnedItem(Item returnedItem) {
        this.returnedItem = new ItemStack(returnedItem);
        return this;
    }

    public ItemStack getReturnedItem() {
        return this.returnedItem;
    }

    public FoodData setUseAction(EnumAction useAction) {
        this.useAction = useAction;
        return this;
    }

    public EnumAction getUseAction() {
        return this.useAction;
    }

    public FoodData setUseDuration(int useDuration) {
        this.useDuration = useDuration;
        return this;
    }

    public int getUseDuration() {
        return this.useDuration;
    }

    public FoodData setStackLimit(int stackLimit) {
        this.stackLimit = MathHelper.func_76125_a((int)stackLimit, (int)1, (int)64);
        return this;
    }

    public int getStackLimit() {
        return this.stackLimit;
    }

    public FoodData setAlwaysEdible(boolean alwaysEdible) {
        this.alwaysEdible = alwaysEdible;
        return this;
    }

    public boolean getAlwaysEdible() {
        return this.alwaysEdible;
    }

    public FoodData setDamage(MyDamageSource damageSource, float damageAmount) {
        this.damageSource = damageSource;
        this.damageAmount = damageAmount;
        return this;
    }

    public MyDamageSource getDamageSource() {
        return this.damageSource;
    }

    public float getDamageAmount() {
        return this.damageAmount;
    }

    public FoodData setFoodUseAction(FoodAction action) {
        this.foodUseAction = action;
        return this;
    }

    public FoodAction getFoodUseAction() {
        return this.foodUseAction;
    }

    public FoodData setFoodFinishAction(FoodAction action) {
        this.foodFinishAction = action;
        return this;
    }

    public FoodAction getFoodFinishAction() {
        return this.foodFinishAction;
    }

    public FoodData setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public String getTooltip() {
        return this.tooltip;
    }
}

