/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ThrowableImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.common.block.BlockEarthOre;
import shetiphian.terraqueous.common.block.BlockFlowerPot;
import shetiphian.terraqueous.common.block.BlockHay;
import shetiphian.terraqueous.common.crafting.CraftingHandler;
import shetiphian.terraqueous.common.entity.ai.EntityAIEatGrassAndHay;
import shetiphian.terraqueous.common.entity.ai.EntityAIMoultFeather;
import shetiphian.terraqueous.common.item.ItemBlockTreeTrunk;
import shetiphian.terraqueous.common.item.ItemMain;
import shetiphian.terraqueous.common.item.ItemMultiTool;
import shetiphian.terraqueous.common.item.ItemScythe;
import shetiphian.terraqueous.common.misc.BlueFlowerHandler;
import shetiphian.terraqueous.common.misc.DeathFruitHelper;
import shetiphian.terraqueous.common.misc.HayHelper;
import shetiphian.terraqueous.common.misc.PitchforkHelper;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.common.network.PacketEquipmentChange;
import shetiphian.terraqueous.common.potion.PotionDisplacement;
import shetiphian.terraqueous.common.worldgen.GenBase;

public class EventHandler {
    private static LootEntryItem getEntry(ItemStack stack, int min, int max, int weight, String entryName) {
        if (stack.func_190926_b()) {
            stack = new ItemStack(Items.field_151155_ap);
        }
        LootCondition[] conditions = new LootCondition[]{};
        LootFunction[] functions = new LootFunction[stack.func_77942_o() ? 3 : 2];
        functions[0] = new SetMetadata(conditions, new RandomValueRange((float)stack.func_77952_i(), (float)stack.func_77952_i()));
        functions[1] = new SetCount(conditions, new RandomValueRange((float)min, (float)max));
        if (stack.func_77942_o()) {
            functions[2] = new SetNBT(conditions, stack.func_77978_p());
        }
        return new LootEntryItem(stack.func_77973_b(), weight, 0, functions, conditions, entryName);
    }

    private static LootEntryItem getToolEntry(ItemStack stack, float dmgMin, float dmgMax, int weight, String entryName) {
        if (stack.func_190926_b()) {
            stack = new ItemStack(Items.field_151055_y);
        }
        LootCondition[] conditions = new LootCondition[]{};
        LootFunction[] functions = new LootFunction[stack.func_77942_o() ? 2 : 1];
        functions[0] = new SetDamage(conditions, new RandomValueRange(dmgMin, dmgMax));
        if (stack.func_77942_o()) {
            functions[1] = new SetNBT(conditions, stack.func_77978_p());
        }
        return new LootEntryItem(stack.func_77973_b(), weight, 0, functions, conditions, entryName);
    }

    public static class ForgeEventBus {
        private static Cache<IBlockState, ShardDrop> BREAK_BLOCK_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
        private Map<String, String> mapHeadLookup = null;
        private List<UUID> breakCache = new ArrayList<UUID>();
        private Cache<ResourceLocation, Byte> errorCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();

        @SubscribeEvent
        public void entityConstructingEvent(EntityEvent.EntityConstructing event) {
            Entity entity = event.getEntity();
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                player.func_110140_aT().func_111150_b(DeathFruitHelper.dfAddiction);
                player.func_110140_aT().func_111150_b(DeathFruitHelper.dfTimer);
            }
        }

        @SubscribeEvent
        public void onEntitySpawn(EntityJoinWorldEvent event) {
            ItemStack potionStack;
            Entity entity = event.getEntity();
            if (Configuration.TWEAKS.MOBS.enableMobDropTweaks && Configuration.TWEAKS.MOBS.enableChickenDropTweaks && entity instanceof EntityChicken) {
                EntityChicken chicken = (EntityChicken)entity;
                chicken.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoultFeather((EntityLiving)chicken));
            }
            if (Configuration.TWEAKS.MOBS.addHayAITasks && entity instanceof EntityAnimal && (Values.blockHay != null || Values.blockTallGrass != null)) {
                EntityAnimal animal = (EntityAnimal)entity;
                if (Values.blockHay != null && animal.func_70877_b(new ItemStack(Items.field_151015_O)) && animal.func_70661_as() instanceof PathNavigateGround) {
                    animal.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)animal, 1.1, Item.func_150898_a((Block)Values.blockHay), false));
                }
                if (animal.field_70714_bg != null) {
                    for (EntityAITasks.EntityAITaskEntry entry : animal.field_70714_bg.field_75782_a) {
                        if (entry.field_75733_a.getClass() != EntityAIEatGrass.class) continue;
                        animal.field_70714_bg.func_85156_a(entry.field_75733_a);
                        animal.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIEatGrassAndHay((EntityLiving)animal));
                        break;
                    }
                }
            }
            if (entity instanceof EntityPotion && !(potionStack = ((EntityPotion)entity).func_184543_l()).func_190926_b()) {
                List list = PotionUtils.func_185189_a((ItemStack)potionStack);
                for (PotionEffect effect : list) {
                    EntityLivingBase thrower;
                    String name = effect.func_76453_d();
                    if (name.equals("potion.terraqueous.firewater")) {
                        thrower = ((EntityPotion)entity).func_85052_h();
                        if (thrower == null) continue;
                        ((EntityPotion)entity).func_184538_a((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, -10.0f, 1.0f, 1.0f);
                        continue;
                    }
                    if (!name.equals("potion.terraqueous.displacement") || (thrower = ((EntityPotion)entity).func_85052_h()) == null) continue;
                    ((EntityPotion)entity).func_184538_a((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, 0.0f, 2.0f, 1.0f);
                }
            }
        }

        @SubscribeEvent
        public void itemCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
            CraftingHandler.INSTANCE.onCrafting(event.crafting, event.craftMatrix);
        }

        @SubscribeEvent
        public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
            IBlockState state;
            ItemStack stack;
            EntityPlayer player = event.getPlayer();
            if (player.field_71075_bZ.field_75098_d && !(stack = player.func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof ItemScythe) {
                if (stack.func_77973_b().onBlockStartBreak(stack, event.getPos(), player)) {
                    return;
                }
                stack.func_179548_a(event.getWorld(), event.getWorld().func_180495_p(event.getPos()), event.getPos(), player);
            }
            if (Configuration.TWEAKS.GLASSSHARDS.enableGlassShardDropsForBlocks && Values.itemMain != null && BREAK_BLOCK_CACHE.getIfPresent((Object)(state = event.getState())) == null) {
                int[] ids;
                Block block = state.func_177230_c();
                RayTraceResult rayTrace = Function.fakeMOP((World)event.getWorld(), (BlockPos)event.getPos(), (EnumFacing)EnumFacing.DOWN);
                ItemStack stack2 = block.getPickBlock(state, rayTrace, event.getWorld(), event.getPos(), player);
                ShardDrop shardDrop = ShardDrop.ZERO;
                if (!stack2.func_190926_b() && (ids = OreDictionary.getOreIDs((ItemStack)stack2)).length > 0) {
                    int blockId = OreDictionary.getOreID((String)"blockGlass");
                    int paneId = OreDictionary.getOreID((String)"paneGlass");
                    for (int id : ids) {
                        if (id == blockId) {
                            shardDrop = ShardDrop.MANY;
                            break;
                        }
                        if (id != paneId) continue;
                        shardDrop = ShardDrop.ONE;
                        break;
                    }
                }
                BREAK_BLOCK_CACHE.put((Object)state, (Object)shardDrop);
            }
        }

        @SubscribeEvent
        public void harvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
            ShardDrop shardDrop;
            if (event.isSilkTouching()) {
                return;
            }
            List drops = event.getDrops();
            if (drops == null) {
                return;
            }
            IBlockState state = event.getState();
            Block block = state.func_177230_c();
            if (block == Blocks.field_150398_cm) {
                ItemStack seed;
                if (Values.blockTallGrass != null && event.getState().func_177230_c().func_176201_c(event.getState()) == 2 && Function.random.nextInt(8) == 0 && !(seed = ForgeHooks.getGrassSeed((Random)Function.random, (int)event.getFortuneLevel())).func_190926_b()) {
                    drops.add(seed);
                }
                return;
            }
            if (drops.isEmpty() && Configuration.TWEAKS.GLASSSHARDS.enableGlassShardDropsForBlocks && Values.itemMain != null && (shardDrop = (ShardDrop)((Object)BREAK_BLOCK_CACHE.getIfPresent((Object)state))) != null) {
                if (shardDrop == ShardDrop.ONE) {
                    drops.add(Values.stacks.get("glass_shard", new int[0]));
                } else if (shardDrop == ShardDrop.MANY) {
                    drops.add(Values.stacks.get("glass_shard", new int[]{Function.random.nextInt(2) + 3}));
                }
                BREAK_BLOCK_CACHE.put((Object)state, (Object)shardDrop);
            }
            if (event.getHarvester() == null) {
                return;
            }
            EntityPlayer player = event.getHarvester();
            if (Values.itemMultiTool != null && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == Values.itemMultiTool) {
                ItemMultiTool.handleDrops(player.func_184614_ca(), player, drops);
            }
        }

        @SubscribeEvent
        public void livingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            if (entity instanceof EntityPlayer) {
                if (event.getSlot() == EntityEquipmentSlot.MAINHAND || event.getSlot() == EntityEquipmentSlot.OFFHAND) {
                    PitchforkHelper.INSTANCE.equipmentChange((EntityPlayer)entity);
                }
                if (entity instanceof EntityPlayerMP && entity.field_70170_p != null) {
                    NetworkHandler.sendToPlayer(new PacketEquipmentChange(event.getSlot(), event.getFrom(), event.getTo()), (EntityPlayerMP)entity);
                }
            } else {
                ForgeEventBus.processLivingEquipmentChangeEvent(entity, event.getSlot().func_188450_d(), event.getFrom(), event.getTo());
            }
        }

        public static void processLivingEquipmentChangeEvent(EntityLivingBase entity, String slotName, ItemStack sFrom, ItemStack sTo) {
            if (entity != null && entity.field_70170_p != null && entity instanceof EntityPlayer == entity.field_70170_p.field_72995_K) {
                boolean cwFrom = CloudAPI.isCloudWalkItem(sFrom);
                boolean cwTo = CloudAPI.isCloudWalkItem(sTo);
                if (cwFrom || cwTo) {
                    String keyTo;
                    String keyFrom = cwFrom ? slotName + ":" + sFrom.func_77973_b().getRegistryName() : "";
                    String string = keyTo = cwTo ? slotName + ":" + sTo.func_77973_b().getRegistryName() : "";
                    if (!keyTo.equals(keyFrom)) {
                        if (cwTo) {
                            CloudAPI.grantCloudWalk(entity, keyTo);
                        }
                        if (cwFrom) {
                            CloudAPI.revokeCloudWalk(entity, keyFrom);
                        }
                    }
                }
            }
        }

        @SubscribeEvent
        public void livingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                BlueFlowerHandler.INSTANCE.blueUpdate(player);
                DeathFruitHelper.INSTANCE.onPlayerUpdate(player);
                PitchforkHelper.INSTANCE.onPlayerUpdate(player);
            }
        }

        private Map<String, String> buildHeadLookup() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Creeper", "MHF_Creeper");
            map.put("Skeleton", "MHF_Skeleton");
            map.put("Spider", "MHF_Spider");
            map.put("Giant", "MHF_Zombie");
            map.put("Zombie", "MHF_Zombie");
            map.put("Slime", "MHF_Slime");
            map.put("Ghast", "MHF_Ghast");
            map.put("PigZombie", "MHF_PigZombie");
            map.put("Enderman", "MHF_Enderman");
            map.put("CaveSpider", "MHF_CaveSpider");
            map.put("Blaze", "MHF_Blaze");
            map.put("LavaSlime", "MHF_LavaSlime");
            map.put("EnderDragon", "MHF_EnderDragon");
            map.put("WitherBoss", "MHF_Wither");
            map.put("Witch", "MHF_Witch");
            map.put("Pig", "MHF_Pig");
            map.put("Sheep", "MHF_Sheep");
            map.put("Cow", "MHF_Cow");
            map.put("Chicken", "MHF_Chicken");
            map.put("Squid", "MHF_Squid");
            map.put("Wolf", "MHF_Wolf");
            map.put("MushroomCow", "MHF_MushroomCow");
            map.put("Ocelot", "MHF_Ocelot");
            map.put("VillagerGolem", "MHF_Golem");
            map.put("Villager", "MHF_Villager");
            return map;
        }

        private ItemStack getMobHead(String texture, String name) {
            ItemStack skull;
            if (texture.equals("MHF_Skeleton")) {
                skull = new ItemStack(Items.field_151144_bL, 1, 0);
            } else if (texture.equals("MHF_WSkeleton")) {
                skull = new ItemStack(Items.field_151144_bL, 1, 1);
            } else if (texture.equals("MHF_Zombie")) {
                skull = new ItemStack(Items.field_151144_bL, 1, 2);
            } else if (texture.equals("MHF_Creeper")) {
                skull = new ItemStack(Items.field_151144_bL, 1, 4);
            } else {
                skull = new ItemStack(Items.field_151144_bL, 1, 3);
                String nbt = "{SkullOwner:" + texture;
                if (!Strings.isNullOrEmpty((String)name)) {
                    nbt = nbt + ", display:{Name:" + name + "}";
                }
                nbt = nbt + "}";
                NBTTagCompound nbtbase = null;
                try {
                    nbtbase = JsonToNBT.func_180713_a((String)nbt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (nbtbase == null) {
                    skull = null;
                }
                if (skull != null) {
                    skull.func_77982_d(nbtbase);
                }
            }
            return skull;
        }

        @SubscribeEvent
        public void livingDeathEvent(LivingDeathEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            if (entity.func_130014_f_().field_72995_K) {
                return;
            }
            Random rand = entity.func_130014_f_().field_73012_v;
            if (event.getSource() == Values.damageScythe) {
                ItemStack stack;
                ItemStack stack2;
                EntityLivingBase attacker = entity.func_94060_bK();
                if (attacker.field_70163_u <= entity.field_70163_u || attacker.field_70163_u - entity.field_70163_u > 2.0) {
                    return;
                }
                int fortune = 0;
                if (attacker instanceof EntityPlayer && !(stack2 = attacker.func_184614_ca()).func_190926_b() && stack2.func_77973_b() instanceof ItemScythe && !ItemScythe.isSickle(stack2)) {
                    fortune = MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack2), (int)0, (int)5);
                }
                int chance = rand.nextInt(101 - fortune * 20);
                if (fortune < 1 || chance > 0) {
                    return;
                }
                if (this.mapHeadLookup == null) {
                    this.mapHeadLookup = this.buildHeadLookup();
                }
                if ((stack = entity instanceof EntityPlayer ? this.getMobHead(this.mapHeadLookup.get(Function.getEntityName((EntityLivingBase)entity)), null) : this.getMobHead(this.mapHeadLookup.get(EntityList.func_75621_b((Entity)entity)), Function.getEntityName((EntityLivingBase)entity) + " Head")) != null) {
                    Function.dropItem((World)entity.func_130014_f_(), (BlockPos)new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), (ItemStack)stack);
                }
            }
            if (Configuration.TWEAKS.MOBS.enableMobDropTweaks) {
                ItemStack stack = ItemStack.field_190927_a;
                if (entity instanceof EntityEnderman) {
                    if (Configuration.TWEAKS.MOBS.enableEndermanDropTweaks) {
                        String[] itemsEnder = new String[]{"endimium_tinydust", "endimium_dust", "ender_tinydust", "ender_dust"};
                        if (entity.func_130014_f_().field_73012_v.nextInt(25) == 0) {
                            stack = Values.stacks.get(itemsEnder[rand.nextInt(itemsEnder.length)], new int[0]);
                        }
                    }
                } else if (entity instanceof EntitySkeleton) {
                    if (Configuration.TWEAKS.MOBS.enableSkeletonDropTweaks && entity.func_130014_f_().field_73012_v.nextInt(200) == 0) {
                        stack = new ItemStack(Items.field_151153_ao);
                    }
                } else if (entity instanceof EntityZombie) {
                    if (Configuration.TWEAKS.MOBS.enableZombieDropTweaks) {
                        String[] itemsZombie = new String[]{"leather_boot1", "leather_boot2", "leather_belt"};
                        for (int item = 0; item < 3; item = (int)((byte)(item + 1))) {
                            if (rand.nextInt(itemsZombie.length) != 0) continue;
                            stack = Values.stacks.get(itemsZombie[item], new int[0]);
                        }
                    }
                } else {
                    String[] itemsNether = new String[]{"burnium_tinydust", "burnium_dust", "coal_tinydust", "coal_dust"};
                    if (entity instanceof EntityBlaze) {
                        if (Configuration.TWEAKS.MOBS.enableBlazeDropTweaks && entity.func_130014_f_().field_73012_v.nextInt(25) == 0) {
                            stack = Values.stacks.get(itemsNether[rand.nextInt(itemsNether.length)], new int[0]);
                        }
                    } else if (entity instanceof EntityMagmaCube) {
                        if (Configuration.TWEAKS.MOBS.enableMagmaCubeDropTweaks && entity.func_130014_f_().field_73012_v.nextInt(25) == 0) {
                            stack = Values.stacks.get(itemsNether[rand.nextInt(itemsNether.length)], new int[0]);
                        }
                    } else if (entity instanceof EntityPigZombie && Configuration.TWEAKS.MOBS.enablePigZombieDropTweaks && entity.func_130014_f_().field_73012_v.nextInt(25) == 0) {
                        stack = Values.stacks.get(itemsNether[rand.nextInt(itemsNether.length)], new int[0]);
                    }
                }
                if (!stack.func_190926_b()) {
                    entity.func_70099_a(stack, 0.5f);
                }
            }
        }

        @SubscribeEvent
        public void useHoeEvent(UseHoeEvent event) {
            BlockFlowerPot.EnumType type;
            World world = event.getWorld();
            IBlockState state = world.func_180495_p(event.getPos());
            if (state != null && state.func_177230_c() == Values.blockFlowerPot && (type = BlockFlowerPot.getEnumType(state)) == BlockFlowerPot.EnumType.PLANTER_DIRT) {
                Function.setBlock((World)world, (BlockPos)event.getPos(), (IBlockState)BlockFlowerPot.EnumType.PLANTER_FARM.state(), (boolean)true);
                world.func_184133_a(event.getEntityPlayer(), event.getPos(), SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                event.setResult(Event.Result.ALLOW);
            }
        }

        @SubscribeEvent
        public void playerItemPickup(PlayerEvent.ItemPickupEvent event) {
            ItemStack stack;
            if (event.player != null && event.pickedUp != null && !(stack = event.pickedUp.func_92059_d()).func_190926_b() && stack.func_77973_b() instanceof ItemBlockTreeTrunk) {
                try {
                    event.player.func_71029_a(StatList.func_188056_d((Item)Item.func_150898_a((Block)Blocks.field_150364_r)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @SubscribeEvent
        public void playerRightClickAir(PlayerInteractEvent.RightClickItem event) {
            int tickrate;
            World world;
            Function.BlockInfo info;
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = event.getItemStack();
            if (player == null || stack.func_190926_b()) {
                return;
            }
            if (Values.blockHay != null && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150329_H) && (info = Function.getBlockInfront((World)(world = event.getWorld()), (EntityPlayer)player, (double)5.0, (boolean)true)) != null && info.face == EnumFacing.UP && world.func_175623_d(info.pos.func_177984_a()) && world.func_180495_p(info.pos).isSideSolid((IBlockAccess)world, info.pos, EnumFacing.UP) && (tickrate = HayHelper.getTickRate(world, info.pos)) > 0) {
                Function.setBlock((World)world, (BlockPos)info.pos.func_177984_a(), (IBlockState)BlockHay.EnumType.LOOSE_GRASS.state(), (boolean)true);
                world.func_175684_a(info.pos.func_177984_a(), Values.blockHay, tickrate);
                player.func_184609_a(event.getHand());
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
            if (Values.itemMain != null && stack.func_77973_b() == Values.itemMain && stack.func_77952_i() == 501) {
                ItemMain.openScroll(stack, event.getWorld(), player, event.getHand());
            }
            if (Values.itemCloudStaff != null && stack.func_77973_b() == Values.itemCloudStaff) {
                Values.itemCloudStaff.func_180614_a(player, event.getWorld(), null, event.getHand(), event.getFace(), 0.5f, 0.5f, 0.5f);
            }
        }

        @SubscribeEvent
        public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            EntityPlayer player = event.getEntityPlayer();
            if (player == null) {
                return;
            }
            IBlockState state = player.func_130014_f_().func_180495_p(event.getPos());
            Block block = state.func_177230_c();
            ItemStack stack = event.getItemStack();
            if (stack.func_190926_b()) {
                return;
            }
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150329_H) && stack.func_77952_i() == 1) {
                if (player.func_70093_af() && Values.blockHay != null) {
                    event.setCanceled(true);
                    return;
                }
                if (Values.blockTallGrass != null && Values.blockTallGrass.func_176196_c(player.func_130014_f_(), event.getPos().func_177984_a()) && player.func_130014_f_().field_73012_v.nextBoolean()) {
                    Function.setBlock((World)player.func_130014_f_(), (BlockPos)event.getPos().func_177984_a(), (IBlockState)Values.blockTallGrass.func_176203_a(1), (boolean)true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    if (!player.func_130014_f_().field_72995_K) {
                        event.setCanceled(true);
                    }
                    return;
                }
            }
            if (!player.func_70093_af()) {
                return;
            }
            Boolean activate = false;
            if (block == Values.blockEnderTable && stack.func_77973_b() == Items.field_151122_aG) {
                activate = true;
            }
            if (activate.booleanValue()) {
                block.func_180639_a(player.func_130014_f_(), event.getPos(), state, player, event.getHand(), event.getFace(), 0.5f, 0.5f, 0.5f);
            }
        }

        @SubscribeEvent
        public void playerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
            EntityAnimal animal;
            EntityPlayer player = event.getEntityPlayer();
            if (player == null || event.getTarget() == null) {
                return;
            }
            ItemStack stack = event.getItemStack();
            if (stack.func_190926_b()) {
                return;
            }
            Entity target = event.getTarget();
            if (!event.getWorld().field_72995_K && target instanceof EntityAnimal && Values.blockHay != null && stack.func_77973_b() == Item.func_150898_a((Block)Values.blockHay) && (animal = (EntityAnimal)target).func_70877_b(new ItemStack(Items.field_151015_O))) {
                boolean used = false;
                if (animal.func_110143_aJ() < animal.func_110138_aP()) {
                    animal.func_70691_i(1.0f);
                    used = true;
                } else if (animal.func_70631_g_()) {
                    animal.func_175501_a((int)((float)(-animal.func_70874_b() / 20) * 0.1f), true);
                    used = true;
                } else if (animal instanceof EntitySheep && ((EntitySheep)animal).func_70892_o()) {
                    if (Function.random.nextInt(5) == 0) {
                        ((EntitySheep)animal).func_70893_e(false);
                    }
                    used = true;
                }
                if (used && !player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
        }

        @SubscribeEvent
        public void prePopulateChunkEvent(PopulateChunkEvent.Pre event) {
            if (Values.blockTallGrass == null) {
                return;
            }
            Chunk chunk = event.getWorld().func_72964_e(event.getChunkX(), event.getChunkZ());
            for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
                if (storage == null) continue;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            IBlockState state = storage.func_177485_a(x, y, z);
                            if (state.func_177230_c() != Blocks.field_150329_H || state.func_177230_c().func_176201_c(state) != 1 || !Function.random.nextBoolean()) continue;
                            storage.func_177484_a(x, y, z, Values.blockTallGrass.func_176223_P());
                        }
                    }
                }
            }
            chunk.func_177427_f(true);
        }

        @SubscribeEvent
        public void lootTableLoadEvent(LootTableLoadEvent event) {
            LootPool pool = event.getTable().getPool("main");
            if (pool == null) {
                return;
            }
            if (Configuration.TWEAKS.CHESTS.chestSpawnBonus_LifeFruit && event.getName().equals((Object)LootTableList.field_186420_b)) {
                pool.addEntry((LootEntry)EventHandler.getEntry(Values.stacks.get("lifefruit", new int[0]), 2, 3, 15, "terraqueous:lifefruit"));
            }
            if (Configuration.TWEAKS.CHESTS.chestMineshaft_DeathFruit && event.getName().equals((Object)LootTableList.field_186424_f)) {
                pool.addEntry((LootEntry)EventHandler.getEntry(Values.stacks.get("deathfruit", new int[0]), 2, 3, 15, "terraqueous:deathfruit"));
            }
            if (Configuration.TWEAKS.CHESTS.chestBlacksmith_Colorizer && event.getName().equals((Object)LootTableList.field_186423_e)) {
                pool.addEntry((LootEntry)EventHandler.getToolEntry(Values.stacks.get("colorizer", new int[0]), 0.0f, 1.0f, 5, "terraqueous:colorizer"));
            }
            if (Configuration.TWEAKS.CHESTS.chestDungeon_Colorizer && event.getName().equals((Object)LootTableList.field_186422_d)) {
                pool.addEntry((LootEntry)EventHandler.getToolEntry(Values.stacks.get("colorizer", new int[0]), 0.0f, 1.0f, 5, "terraqueous:colorizer"));
            }
            if (Configuration.TWEAKS.CHESTS.chestStronghold_Scroll && event.getName().equals((Object)LootTableList.field_186426_h)) {
                pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "terraqueous");
                pool.addEntry((LootEntry)EventHandler.getEntry(Values.stacks.get("scroll_strange", new int[0]), 1, 1, 85, "terraqueous:scroll_strange"));
                event.getTable().addPool(pool);
            }
            if (Configuration.TWEAKS.CHESTS.chestNetherBridge_Scroll && event.getName().equals((Object)LootTableList.field_186425_g)) {
                pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(0.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "terraqueous");
                pool.addEntry((LootEntry)EventHandler.getEntry(Values.stacks.get("scroll_strange", new int[0]), 1, 1, 5, "terraqueous:scroll_strange"));
                event.getTable().addPool(pool);
            }
            if (Configuration.TWEAKS.CHESTS.chestDungeon_ToonTrotters && event.getName().equals((Object)LootTableList.field_186422_d)) {
                pool.addEntry((LootEntry)EventHandler.getEntry(Values.stacks.get("toon_trotters", new int[0]), 1, 1, 5, "terraqueous:toon_trotters"));
            }
        }

        @SubscribeEvent
        public void playerBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
            ItemStack stack;
            EntityPlayer player = event.getEntityPlayer();
            if (player != null && !this.breakCache.contains(player.func_110124_au()) && !(stack = player.func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof ItemMultiTool) {
                if (event.getPos() == null) {
                    ResourceLocation blockId = null;
                    try {
                        blockId = event.getState().func_177230_c().getRegistryName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (blockId != null) {
                        if (this.errorCache.getIfPresent((Object)blockId) == null) {
                            Values.logTerraqueous.error("A block is using the deprecated version of 'EntityPlayer.getDigSpeed', the MultiTool harvest speed will be wrong. Contact the mod author of " + blockId + " and ask them to use the correct method");
                        }
                        this.errorCache.put((Object)blockId, (Object)0);
                    }
                    event.setNewSpeed(event.getNewSpeed() + 250.0f);
                } else if (event.getPos().func_177956_o() > 0) {
                    this.breakCache.add(player.func_110124_au());
                    event.setNewSpeed(((ItemMultiTool)stack.func_77973_b()).getBreakSpeed(stack, player, event.getState(), event.getNewSpeed(), event.getPos()));
                    this.breakCache.remove(player.func_110124_au());
                }
            }
        }

        @SubscribeEvent
        public void throwableImpactEvent(ThrowableImpactEvent event) {
            EntityThrowable throwable = event.getEntityThrowable();
            if (throwable instanceof EntityPotion) {
                World world = throwable.func_130014_f_();
                BlockPos ePos = throwable.func_180425_c();
                if (!world.field_72995_K) {
                    ItemStack potionStack = ((EntityPotion)throwable).func_184543_l();
                    if (!potionStack.func_190926_b()) {
                        List list = PotionUtils.func_185189_a((ItemStack)potionStack);
                        for (PotionEffect effect : list) {
                            String name = effect.func_76453_d();
                            if (name.equals("potion.terraqueous.firewater")) {
                                Iterable blocks = BlockPos.func_177980_a((BlockPos)throwable.func_180425_c().func_177982_a(-2, -2, -2), (BlockPos)throwable.func_180425_c().func_177982_a(2, 1, 2));
                                for (BlockPos pos : blocks) {
                                    double distance = ePos.func_177954_c((double)pos.func_177958_n(), (double)ePos.func_177956_o(), (double)pos.func_177952_p());
                                    if (!(distance < 6.0) || !world.func_175623_d(pos) || !Blocks.field_150480_ab.func_176196_c(world, pos)) continue;
                                    Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Blocks.field_150480_ab.func_176223_P(), (boolean)true);
                                }
                                continue;
                            }
                            if (!name.equals("potion.terraqueous.displacement")) continue;
                            EntityLivingBase thrower = throwable.func_85052_h();
                            List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(throwable.func_180425_c().func_177982_a(-5, -3, -5), throwable.func_180425_c().func_177982_a(5, 3, 5)));
                            for (EntityLivingBase entity : entities) {
                                if (thrower != null) {
                                    entity.func_70634_a(thrower.field_70165_t, thrower.field_70163_u, thrower.field_70161_v);
                                    continue;
                                }
                                BlockEarthOre.teleportEntity(world, ePos, entity, 16);
                            }
                            if (thrower == null) continue;
                            thrower.func_70634_a((double)ePos.func_177958_n(), (double)ePos.func_177956_o(), (double)ePos.func_177952_p());
                            PotionDisplacement.apply(thrower, 0);
                        }
                    }
                    if (Configuration.TWEAKS.GLASSSHARDS.enableGlassShardDropsForPotions && Values.itemMain != null) {
                        Function.dropItem((World)world, (BlockPos)ePos, (ItemStack)Terraqueous.getCustomItemStack("glass_shard", 1));
                    }
                }
            }
        }

        private static enum ShardDrop {
            ZERO,
            ONE,
            MANY;

        }
    }

    public static class ForgeTerrainBus {
        @SubscribeEvent
        public void saplingGrowTreeEvent(SaplingGrowTreeEvent event) {
            if (event.getWorld().func_180495_p(event.getPos().func_177977_b()).func_177230_c() == Blocks.field_150457_bL) {
                event.setResult(Event.Result.DENY);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
        public void decorateEvent(DecorateBiomeEvent.Decorate event) {
            GenBase.GEN_CHECK.put((Object)new ChunkPos(event.getPos()), (Object)event.getType(), (Object)(event.getResult() != Event.Result.DENY ? 1 : 0));
        }
    }
}

