/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.item.ItemToolWithDamageSource;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockHay;
import shetiphian.terraqueous.common.misc.PitchforkHelper;

public class ItemPitchfork
extends ItemToolWithDamageSource {
    private static ItemStack stackOnFire = ItemStack.field_190927_a;

    public ItemPitchfork() {
        super(5.0f, -3.0f, Item.ToolMaterial.IRON, null, (Set)Sets.newHashSet((Object[])new Block[]{Values.blockHay}));
        this.func_77637_a((CreativeTabs)Values.tabTerraqueous);
        this.field_77777_bU = 1;
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{CreativeTabs.field_78040_i, Values.tabTerraqueous};
    }

    public void getSubItems(NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Item)this));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult toolResult = EnumActionResult.PASS;
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            boolean isCreative = player.field_71075_bZ.field_75098_d;
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == Values.blockHay) {
                if (player.func_70093_af()) {
                    return this.stackHay(player, world, pos, state, isCreative);
                }
                return this.collectHay(player, world, pos, BlockHay.getEnumType(state), isCreative);
            }
            if (state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
                if (player.func_70093_af()) {
                    return this.stackHay(player, world, pos, state, isCreative);
                }
                return this.dryHay(player, world, pos, isCreative);
            }
        }
        return toolResult;
    }

    private EnumActionResult stackHay(EntityPlayer player, World world, BlockPos pos, IBlockState state, boolean isCreative) {
        byte value;
        int[] slots = new int[]{-1, -1};
        byte by = value = state.func_177230_c() == Values.blockHay ? BlockHay.getEnumType(state).getValue() : (byte)0;
        if (value > 0 || world.func_175623_d(pos.func_177984_a())) {
            if (!isCreative) {
                Item itemHay = Item.func_150898_a((Block)Values.blockHay);
                for (int index = 0; index < player.field_71071_by.func_70302_i_(); ++index) {
                    ItemStack stack = player.field_71071_by.func_70301_a(index);
                    if (!stack.func_190926_b() && stack.func_77973_b() == itemHay && stack.func_77960_j() == 5) {
                        if (slots[0] == -1) {
                            slots[0] = index;
                            if (stack.func_190916_E() > 1) {
                                slots[1] = index;
                            }
                        } else if (slots[1] == -1) {
                            slots[1] = index;
                        }
                    }
                    if (slots[0] <= -1 || slots[1] <= -1) continue;
                    index = player.field_71071_by.func_70302_i_();
                }
            }
            if (isCreative || value < 5 && slots[0] > -1 && slots[1] > -1 || (value == 0 || value == 5) && (slots[0] > -1 || slots[1] > -1)) {
                if (value == 0) {
                    Function.setBlock((World)world, (BlockPos)pos.func_177984_a(), (IBlockState)BlockHay.EnumType.LOOSE_HAY.state(), (boolean)true);
                } else if (value < 6) {
                    Function.setBlock((World)world, (BlockPos)pos, (IBlockState)BlockHay.EnumType.byValue(value - 1).state(), (boolean)true);
                }
                world.func_184133_a(player, pos, Values.blockHay.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                if (!isCreative) {
                    if (value == 5 || value == 0) {
                        if (slots[0] > -1) {
                            player.field_71071_by.func_70298_a(slots[0], 1);
                        } else {
                            player.field_71071_by.func_70298_a(slots[1], 1);
                        }
                    } else {
                        player.field_71071_by.func_70298_a(slots[0], 1);
                        player.field_71071_by.func_70298_a(slots[1], 1);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult collectHay(EntityPlayer player, World world, BlockPos pos, BlockHay.EnumType type, boolean isCreative) {
        if (type.getValue() < 6) {
            if (type.getValue() == 5) {
                Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
            } else {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)BlockHay.EnumType.byValue(type.getValue() + 1).state(), (boolean)true);
            }
            if (!isCreative) {
                if (type.getValue() > 3) {
                    Function.giveItem((EntityPlayer)player, (ItemStack)new ItemStack(Values.blockHay, 1, 5), null);
                } else {
                    Function.giveItem((EntityPlayer)player, (ItemStack)new ItemStack(Values.blockHay, 2, 5), null);
                }
            }
        } else {
            NonNullList drops = NonNullList.func_191196_a();
            for (int scan = 0; scan < 3; ++scan) {
                BlockPos sPos = pos.func_177967_a(player.func_174811_aO(), scan);
                IBlockState sState = world.func_180495_p(sPos);
                if (sState.func_177230_c() != Values.blockHay || BlockHay.getEnumType(sState).getValue() <= 4) continue;
                sState.func_177230_c().getDrops(drops, (IBlockAccess)world, sPos, sState, 0);
                Function.removeBlock((World)world, (BlockPos)sPos, (boolean)true);
            }
            if (!isCreative) {
                for (ItemStack stack : drops) {
                    Function.giveItem((EntityPlayer)player, (ItemStack)stack, null);
                }
            }
        }
        world.func_184133_a(player, pos, Values.blockHay.func_185467_w().func_185845_c(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult dryHay(EntityPlayer player, World world, BlockPos pos, boolean isCreative) {
        EnumActionResult toolResult = EnumActionResult.PASS;
        int[] slots = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
        int[] metas = new int[slots.length];
        if (!isCreative) {
            Item itemHay = Item.func_150898_a((Block)Values.blockHay);
            Item itemGrass = Item.func_150898_a((Block)Blocks.field_150329_H);
            for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
                int start;
                int meta;
                ItemStack stack = player.field_71071_by.func_70301_a(slot);
                if (stack.func_190926_b() || stack.func_77973_b() != itemHay && stack.func_77973_b() != itemGrass) continue;
                int n = meta = stack.func_77973_b() == itemGrass ? 16 : stack.func_77960_j();
                if (meta <= 5) continue;
                for (int count = start = Math.min(stack.func_190916_E(), metas.length); count > 0; --count) {
                    int index = start - count;
                    if (meta > metas[index]) continue;
                    slots = this.inject(slot, index, slots);
                    metas = this.inject(meta, index, metas);
                }
            }
        }
        BlockPos row2 = pos.func_177972_a(player.func_174811_aO().func_176746_e());
        BlockPos row3 = pos.func_177972_a(player.func_174811_aO().func_176735_f());
        int placed = 0;
        for (int index = 0; index < slots.length; ++index) {
            BlockPos sPos;
            if (!isCreative && slots[index] <= -1) continue;
            IBlockState pState = BlockHay.EnumType.byValue(isCreative ? 15 : metas[index]).state();
            if (index < 5) {
                sPos = pos.func_177967_a(player.func_174811_aO(), index == 0 ? 0 : (index == 1 ? -1 : index - 1));
            } else if (index % 2 == 0) {
                sPos = index < 7 ? row2 : row2.func_177967_a(player.func_174811_aO(), 1);
            } else {
                BlockPos blockPos = sPos = index < 7 ? row3 : row3.func_177967_a(player.func_174811_aO(), 1);
            }
            if (!world.isSideSolid(sPos, EnumFacing.UP) || !world.func_175623_d(sPos.func_177984_a())) continue;
            Function.setBlock((World)world, (BlockPos)sPos.func_177984_a(), (IBlockState)pState, (boolean)true);
            toolResult = EnumActionResult.SUCCESS;
            if (isCreative) continue;
            player.field_71071_by.func_70298_a(slots[placed++], 1);
        }
        if (toolResult == EnumActionResult.SUCCESS) {
            world.func_184133_a(player, pos, Values.blockHay.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        return toolResult;
    }

    private int[] inject(int value, int index, int[] array) {
        array = this.shift(array, index);
        array[index] = value;
        return array;
    }

    private int[] shift(int[] array, int start) {
        if (start != array.length - 1) {
            this.shift(array, start + 1);
        }
        array[start] = start == 0 ? 0 : array[start - 1];
        return array;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity victim) {
        if (stackOnFire == ItemStack.field_190927_a) {
            stackOnFire = new ItemStack(Items.field_151036_c);
            stackOnFire.func_77966_a(Enchantments.field_77334_n, 1);
        }
        if (this.shouldSetMobOnFire(player)) {
            player.func_184609_a(EnumHand.OFF_HAND);
            ItemToolWithDamageSource.onLeftClickEntity((EntityPlayer)player, (Entity)victim, null, (ItemStack)stackOnFire);
        }
        return super.onLeftClickEntity(stack, player, victim);
    }

    private boolean shouldSetMobOnFire(EntityPlayer player) {
        return player.func_70027_ad() || Function.random.nextInt(3) == 0 && player.func_70660_b(PitchforkHelper.ready) != null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advancedTooltips) {
        tooltip.add(Localization.get((String)"info.terraqueous.pitchfork.txt"));
    }
}

