/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.common.item.ItemBlockMultiCloudBase;
import shetiphian.terraqueous.common.misc.StormForgeHelper;

public class ItemBlockCrafting
extends ItemBlockMultiCloudBase {
    public ItemBlockCrafting(Block block) {
        super(block, "BlockCrafting", Values.nameMapper);
    }

    public void getSubItems(NonNullList<ItemStack> list) {
        int meta;
        if (Values.blockClouds != null) {
            for (meta = 0; meta < 4; meta = (int)((byte)(meta + 1))) {
                list.add((Object)new ItemStack((Item)this, 1, meta));
            }
        }
        for (meta = 5; meta < 7; meta = (int)((byte)(meta + 1))) {
            list.add((Object)new ItemStack((Item)this, 1, meta));
        }
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        if (!player.func_130014_f_().field_72995_K && stack.func_77952_i() == 3 && Values.blockEarthOre != null && world.func_180495_p(pos.func_177977_b()) == Values.blockEarthOre.func_176203_a(3) && this.canPlaceForge(player) && StormForgeHelper.createStormForge(world, pos)) {
            return true;
        }
        if (stack.func_77952_i() < 5 && !CloudAPI.canPlaceCloudAt((IBlockAccess)world, pos)) {
            return false;
        }
        return super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, Values.blockCrafting.func_176203_a(stack.func_77952_i()));
    }

    private boolean canPlaceForge(EntityPlayer player) {
        int permission = Configuration.PERMISSIONS.permissionStormForge;
        if (player.func_130014_f_().field_72995_K) {
            return false;
        }
        if (permission > 0 && Function.isOP((EntityPlayer)player)) {
            return true;
        }
        if (permission > 1 && player.field_71075_bZ.field_75098_d) {
            return true;
        }
        return permission > 2;
    }

    protected void addToNameMap() {
        this.add(0, "crafting/", "cloud_workbench", "cloud.workbench");
        this.add(1, "crafting/", "cloud_furnace", "cloud.furnace");
        this.add(2, "crafting/", "cloud_craftbench", "cloud.craftbench");
        this.add(3, "crafting/", "cloud_craftfurnace", "cloud.craftfurnace");
        this.add(5, "crafting/", "earth_craftbench", "craftbench");
        this.add(6, "crafting/", "earth_craftfurnace", "craftfurnace");
        this.add(13, "crafting/", "sforge_alter", "stormforge.block");
        this.add(14, "crafting/", "sforge_alter", "stormforge.block");
        this.add(15, "crafting/", "sforge_alter", "stormforge.controller");
    }
}

