/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockPlants
extends Block
implements IPlantable,
IBonemealable {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final AxisAlignedBB AABB_SMALL = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.3, 0.8);
    private static final AxisAlignedBB AABB_PINEAPPLE = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 1.0, 0.8);
    private static final AxisAlignedBB AABB_LARGE = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.8, 0.8);
    private static final AxisAlignedBB AABB_DEFAULT = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.5, 0.8);

    public BlockPlants() {
        super(Material.field_151585_k);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.1f);
        this.func_149675_a(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockPlants.getEnumType(state);
        if (type == EnumType.PINEAPPLE_LARGE || type == EnumType.PINEAPPLE_LARGE_STEM) {
            boolean pineapple;
            IBlockState oState = world.func_180495_p(pos.func_177984_a());
            boolean bl = pineapple = oState.func_177230_c() == this && BlockPlants.getEnumType(oState) == EnumType.PINEAPPLE_FRUIT;
            if (type == EnumType.PINEAPPLE_LARGE && pineapple) {
                return EnumType.PINEAPPLE_LARGE_STEM.state();
            }
            if (type == EnumType.PINEAPPLE_LARGE_STEM && !pineapple) {
                return EnumType.PINEAPPLE_LARGE.state();
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return BlockPlants.getEnumType(state).getValue();
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return Block.field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockPlants.getEnumType(this.func_176221_a(state, world, pos));
        switch (type) {
            case PINEAPPLE_SMALL: 
            case CACTUS_SMALL: {
                return AABB_SMALL;
            }
            case PINEAPPLE_FRUIT: 
            case PINEAPPLE_LARGE_STEM: {
                return AABB_PINEAPPLE;
            }
            case PINEAPPLE_LARGE: 
            case CACTUS_LARGE: {
                return AABB_LARGE;
            }
        }
        return AABB_DEFAULT;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(this.func_180660_a(state, world.field_73012_v, 0), 1, this.func_180651_a(state));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        EnumType type = BlockPlants.getEnumType(state);
        return type == EnumType.PINEAPPLE_FRUIT ? Values.itemMultiFood : Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = BlockPlants.getEnumType(state);
        return type == EnumType.PINEAPPLE_FRUIT ? Values.stacks.get("pineapple", new int[0]).func_77952_i() : this.func_176201_c(state);
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (world.field_72995_K) {
            return;
        }
        switch (BlockPlants.getEnumType(state)) {
            case PINEAPPLE_SMALL: 
            case PINEAPPLE_FRUIT: {
                Function.dropItem((World)world, (BlockPos)pos, (ItemStack)Values.stacks.get("pineapple", new int[0]));
                break;
            }
            case PINEAPPLE_LARGE_STEM: 
            case PINEAPPLE_LARGE: {
                Function.dropItem((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151055_y));
                break;
            }
            case CACTUS_SMALL: {
                Function.dropItem((World)world, (BlockPos)pos, (ItemStack)Values.stacks.get("cactus", new int[0]));
                break;
            }
            case CACTUS_FRUIT: {
                Function.dropItem((World)world, (BlockPos)pos, (ItemStack)Values.stacks.get("pricklypear", new int[]{world.field_73012_v.nextInt(2) + 1}));
            }
            case CACTUS_LARGE: {
                Function.dropItem((World)world, (BlockPos)pos, (ItemStack)Values.stacks.get("cactus", new int[]{2}));
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (Values.itemMultiFood != null && BlockPlants.getEnumType(state) == EnumType.CACTUS_FRUIT) {
            ItemStack fruit = Values.stacks.get("pricklypear", new int[]{world.field_73012_v.nextInt(2) + 1});
            if (player != null) {
                Function.giveItem((EntityPlayer)player, (ItemStack)fruit);
            } else {
                Function.dropItem((World)world, (BlockPos)pos, (ItemStack)fruit);
            }
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)EnumType.CACTUS_LARGE.state(), (boolean)true);
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos pos2) {
        BlockPos gPos = pos.func_177977_b();
        IBlockState gState = world.func_180495_p(gPos);
        Block gBlock = gState.func_177230_c();
        boolean removeBlock = false;
        switch (BlockPlants.getEnumType(state)) {
            case PINEAPPLE_SMALL: 
            case PINEAPPLE_LARGE_STEM: 
            case PINEAPPLE_LARGE: {
                removeBlock = !gBlock.canSustainPlant(gState, (IBlockAccess)world, gPos, EnumFacing.UP, (IPlantable)Blocks.field_150328_O);
                break;
            }
            case PINEAPPLE_FRUIT: {
                EnumType gType = BlockPlants.getEnumType(gState);
                removeBlock = gBlock != this || gType != EnumType.PINEAPPLE_LARGE_STEM && gType != EnumType.PINEAPPLE_LARGE;
                break;
            }
            case CACTUS_SMALL: 
            case CACTUS_LARGE: 
            case CACTUS_FRUIT: {
                boolean bl = removeBlock = !gBlock.canSustainPlant(gState, (IBlockAccess)world, gPos, EnumFacing.UP, (IPlantable)Blocks.field_150434_aF);
            }
        }
        if (removeBlock) {
            this.func_180653_a(world, pos, state, 100.0f, 0);
            Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
            return;
        }
        super.func_189540_a(state, world, pos, neighbor, pos2);
    }

    public boolean canGrow(World world, BlockPos pos, IBlockState state, boolean isClient) {
        switch (BlockPlants.getEnumType(state)) {
            case PINEAPPLE_FRUIT: 
            case CACTUS_FRUIT: {
                return false;
            }
            case PINEAPPLE_LARGE_STEM: 
            case PINEAPPLE_LARGE: {
                return world.func_175623_d(pos.func_177984_a());
            }
            case PINEAPPLE_SMALL: 
            case CACTUS_SMALL: 
            case CACTUS_LARGE: {
                return true;
            }
        }
        return false;
    }

    public boolean canUseBonemeal(World world, Random random, BlockPos pos, IBlockState state) {
        return random.nextFloat() < 0.45f;
    }

    public void grow(World world, Random rand, BlockPos pos, IBlockState state) {
        switch (BlockPlants.getEnumType(state)) {
            case PINEAPPLE_SMALL: {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)EnumType.PINEAPPLE_LARGE.state(), (boolean)true);
                break;
            }
            case PINEAPPLE_LARGE_STEM: 
            case PINEAPPLE_LARGE: {
                Function.setBlock((World)world, (BlockPos)pos.func_177984_a(), (IBlockState)EnumType.PINEAPPLE_FRUIT.state(), (boolean)true);
                break;
            }
            case CACTUS_SMALL: {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)EnumType.CACTUS_LARGE.state(), (boolean)true);
                break;
            }
            case CACTUS_LARGE: {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)EnumType.CACTUS_FRUIT.state(), (boolean)true);
                break;
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        switch (BlockPlants.getEnumType(state)) {
            case PINEAPPLE_SMALL: {
                if (!PlantFunctions.canGrow(world, pos, PlantAPI.PlantType.PINEAPPLE)) break;
                this.grow(world, rand, pos, state);
                break;
            }
            case PINEAPPLE_LARGE_STEM: 
            case PINEAPPLE_LARGE: {
                if (!world.func_175623_d(pos.func_177984_a()) || !PlantFunctions.canGrowFruit(world, pos, PlantAPI.PlantType.PINEAPPLE)) break;
                this.grow(world, rand, pos, state);
                break;
            }
            case CACTUS_SMALL: {
                if (!PlantFunctions.canGrow(world, pos, PlantAPI.PlantType.CACTUS)) break;
                this.grow(world, rand, pos, state);
                break;
            }
            case CACTUS_LARGE: {
                if (!PlantFunctions.canGrowFruit(world, pos, PlantAPI.PlantType.CACTUS)) break;
                this.grow(world, rand, pos, state);
                break;
            }
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        EnumType type = BlockPlants.getEnumType(world.func_180495_p(pos));
        return type.getPlantType() == PlantAPI.PlantType.CACTUS ? EnumPlantType.Desert : EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLiving || entity instanceof EntityPlayer) {
            EnumType type = BlockPlants.getEnumType(state);
            if (type.getPlantType() != PlantAPI.PlantType.CACTUS || entity instanceof EntityRabbit) {
                return;
            }
            boolean hasBoots = !((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
            boolean hasPants = !((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
            float damage = 1.5f;
            damage = type == EnumType.CACTUS_SMALL ? (damage -= hasBoots ? 1.5f : 0.0f) : (damage -= hasBoots && hasPants ? 1.5f : 0.0f);
            if (damage > 0.0f) {
                entity.func_70097_a(DamageSource.field_76367_g, damage);
            }
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plant) {
        return false;
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockPlants.getEnumType(state).getPlantType() == PlantAPI.PlantType.CACTUS ? PathNodeType.DANGER_CACTUS : super.getAiPathNodeType(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.PINEAPPLE_SMALL;
            Terraqueous.errorPropertyNotFound("BlockPlants.VARIANT", "PINEAPPLE_SMALL", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        PINEAPPLE_SMALL(0, PlantAPI.PlantType.PINEAPPLE),
        PINEAPPLE_LARGE(1, PlantAPI.PlantType.PINEAPPLE),
        PINEAPPLE_LARGE_STEM(1, PlantAPI.PlantType.PINEAPPLE),
        PINEAPPLE_FRUIT(2, PlantAPI.PlantType.PINEAPPLE),
        CACTUS_SMALL(3, PlantAPI.PlantType.CACTUS),
        CACTUS_LARGE(4, PlantAPI.PlantType.CACTUS),
        CACTUS_FRUIT(5, PlantAPI.PlantType.CACTUS);

        private static final EnumType[] array;
        private final byte value;
        private final PlantAPI.PlantType plant;

        private EnumType(int value, PlantAPI.PlantType plant) {
            this.value = (byte)value;
            this.plant = plant;
        }

        public byte getValue() {
            return this.value;
        }

        public PlantAPI.PlantType getPlantType() {
            return this.plant;
        }

        public IBlockState state() {
            if (Values.blockPlants != null) {
                return Values.blockPlants.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)this));
            }
            return null;
        }

        public static EnumType byValue(int value) {
            return array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[6];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

