/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.misc.HayHelper;

public class BlockHay
extends Block
implements IColored {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final AxisAlignedBB AABB_FLAT = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    private static final AxisAlignedBB AABB_QUARTER = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private static final AxisAlignedBB AABB_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB AABB_3QUARTER = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    public BlockHay() {
        super(Material.field_151577_b);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185849_b);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return BlockHay.getEnumType(state).getValue();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        EnumType eType = BlockHay.getEnumType(state);
        return eType != null && eType.getValue() > 4 ? 0.2f : 0.6f;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        EnumType eType = BlockHay.getEnumType(world.func_180495_p(pos));
        return eType == null || eType.getValue() < 9 ? 60 : 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        EnumType eType = BlockHay.getEnumType(world.func_180495_p(pos));
        return eType == null || eType.getValue() == 0 ? 50 : (eType.getValue() < 9 ? 100 : 0);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumType eType = BlockHay.getEnumType(state);
        return eType != null && eType.getValue() == 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return this.isSideSolid(state, world, pos, side) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        Item item = this.func_180660_a(state, world.field_73012_v, 0);
        return item == null ? null : new ItemStack(item, 1, this.func_180651_a(state));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        EnumType eType = BlockHay.getEnumType(state);
        return eType == null ? null : (eType.getValue() == 15 ? Item.func_150898_a((Block)Blocks.field_150329_H) : Item.func_150898_a((Block)this));
    }

    public int func_180651_a(IBlockState state) {
        EnumType eType = BlockHay.getEnumType(state);
        return eType == null ? 0 : (eType.getValue() == 15 ? 1 : (int)eType.getValue());
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        EnumType eType = BlockHay.getEnumType(state);
        if (eType != null && eType.getNext() != null) {
            boolean isRaining = world.func_175727_C(pos);
            if (!isRaining) {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)eType.getNext().state(), (boolean)true);
            }
            if (isRaining || eType.getNext().getNext() != null) {
                world.func_175684_a(pos, (Block)this, HayHelper.getTickRate(world, pos.func_177977_b()));
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos pos2) {
        EnumType eType = BlockHay.getEnumType(state);
        if (eType != null && eType.getValue() > 4 && world.func_175623_d(pos.func_177977_b())) {
            Function.dropItem((World)world, (BlockPos)pos, (ItemStack)new ItemStack(this.func_180660_a(state, world.field_73012_v, 100), 1, this.func_180651_a(state)));
            Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType eType = BlockHay.getEnumType(state);
        if (eType != null) {
            switch (eType.getSize()) {
                case 1: {
                    return AABB_FLAT;
                }
                case 2: {
                    return AABB_QUARTER;
                }
                case 3: {
                    return AABB_HALF;
                }
                case 4: {
                    return AABB_3QUARTER;
                }
            }
        }
        return Block.field_185505_j;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K) {
            this.lowerDamage(entity, BlockHay.getEnumType(world.func_180495_p(pos)));
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!world.field_72995_K) {
            this.lowerDamage(entity, BlockHay.getEnumType(world.func_180495_p(pos)));
        }
    }

    private void lowerDamage(Entity entity, EnumType eType) {
        if (eType != null) {
            entity.field_70143_R -= entity.field_70143_R * (float)eType.getSize();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        return this.getRenderColor(data.state);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(IBlockState state) {
        EnumType eType;
        if (state != null && (eType = BlockHay.getEnumType(state)) != null) {
            return eType.getColor();
        }
        return 0xFFFFFF;
    }

    public static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.HAYBLOCK;
            Terraqueous.errorPropertyNotFound("BlockHay.VARIANT", "HAYBLOCK", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        HAYBLOCK(0, 0xFFFFFF, 0, null),
        LG_HAYPILE(1, 0xFFFFFF, 4, null),
        HAYPILE(2, 0xFFFFFF, 3, null),
        SM_HAYPILE(3, 0xFFFFFF, 2, null),
        THRESH(4, 0xFFFFFF, 1, null),
        LOOSE_HAY(5, 0xFFFFFF, 1, null),
        DRYING_90(6, 12172908, 1, LOOSE_HAY),
        DRYING_80(7, 11384164, 1, DRYING_90),
        DRYING_70(8, 10530141, 1, DRYING_80),
        DRYING_60(9, 9610324, 1, DRYING_70),
        DRYING_50(10, 8756044, 1, DRYING_60),
        DRYING_40(11, 7902021, 1, DRYING_50),
        DRYING_30(12, 6982205, 1, DRYING_40),
        DRYING_20(13, 6127925, 1, DRYING_30),
        DRYING_10(14, 5273901, 1, DRYING_20),
        LOOSE_GRASS(15, 4419621, 1, DRYING_10);

        private static final EnumType[] array;
        private final byte value;
        private final int color;
        private final byte size;
        private final EnumType next;

        private EnumType(int value, int color, int size, EnumType next) {
            this.value = (byte)value;
            this.color = color;
            this.size = (byte)size;
            this.next = next;
        }

        public byte getValue() {
            return this.value;
        }

        public int getColor() {
            return this.color;
        }

        public byte getSize() {
            return this.size;
        }

        public EnumType getNext() {
            return this.next;
        }

        public IBlockState state() {
            if (Values.blockHay != null) {
                return Values.blockHay.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)this));
            }
            return null;
        }

        public static EnumType byValue(int value) {
            return array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[16];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

