/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.gui;

import com.google.common.base.Strings;
import java.awt.Point;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Mouse;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.core.common.ColorHelper;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.terraqueous.client.gui.Textures;
import shetiphian.terraqueous.common.item.ItemColorizer;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.common.network.PacketColorizer;

public class GuiColorizer
extends GuiScreen {
    private EntityPlayer user;
    private GuiTextField textField;
    private GuiButton selectedButton;
    private int xSize = 138;
    private int ySize = 110;
    private Mode mode = Mode.HSL;
    private float[] slider = new float[]{0.5f, 1.0f, 0.5f};
    private float[] lastSlider = new float[]{-1.0f, -1.0f, -1.0f};
    private int sColor = -1;
    private int lvColor = -1;
    private int resultColor = -1;
    private short resultIndex = (short)4096;
    private ItemStack resultStack = new ItemStack(Blocks.field_150325_L, 1, EnumDyeColor.WHITE.func_176765_a());
    private short[] presetIndex = new short[18];
    private String[] presetName = new String[18];
    private byte savePreset = (byte)-1;
    private boolean needsUpdate = false;

    public GuiColorizer(EntityPlayer player) {
        this.user = player;
        ItemStack stack = this.user.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemColorizer) {
            this.resultIndex = ((ItemColorizer)stack.func_77973_b()).getRGB16(stack);
            this.resultColor = RGB16Helper.getColor((short)this.resultIndex);
            this.setSliders(ColorHelper.colorToHSL((int)this.resultColor));
        }
    }

    public void func_73866_w_() {
        int winX = (this.field_146294_l - this.xSize) / 2;
        int winY = (this.field_146295_m - this.ySize) / 2;
        this.needsUpdate = false;
        ItemStack stack = this.user.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemColorizer) {
            NBTTagList tagList = ((ItemColorizer)stack.func_77973_b()).getNBTTagList(stack);
            for (int preset = 0; preset < 18; preset = (int)((byte)(preset + 1))) {
                NBTTagCompound tagPresets = tagList.func_150305_b(preset);
                this.presetIndex[preset] = tagPresets.func_74765_d("rgb16");
                this.presetName[preset] = tagPresets.func_74779_i("name");
            }
        }
        this.field_146292_n.clear();
        this.field_146292_n.add(new Button(this, 0, winX + 17, winY + 12, 32, 10, ButtonType.MODE, "RGB"));
        this.field_146292_n.add(new Button(this, 1, winX + 53, winY + 12, 32, 10, ButtonType.MODE, "HSL"));
        this.field_146292_n.add(new Button(this, 2, winX + 89, winY + 12, 32, 10, ButtonType.MODE, "HSV"));
        this.field_146292_n.add(new Button(this, 3, winX + 12, winY + 31, 10, 10, ButtonType.SUBTRACT));
        this.field_146292_n.add(new Button(this, 4, winX + 26, winY + 33, 50, 6, ButtonType.SLIDER));
        this.field_146292_n.add(new Button(this, 5, winX + 80, winY + 31, 10, 10, ButtonType.ADD));
        this.field_146292_n.add(new Button(this, 6, winX + 12, winY + 45, 10, 10, ButtonType.SUBTRACT));
        this.field_146292_n.add(new Button(this, 7, winX + 26, winY + 47, 50, 6, ButtonType.SLIDER));
        this.field_146292_n.add(new Button(this, 8, winX + 80, winY + 45, 10, 10, ButtonType.ADD));
        this.field_146292_n.add(new Button(this, 9, winX + 12, winY + 59, 10, 10, ButtonType.SUBTRACT));
        this.field_146292_n.add(new Button(this, 10, winX + 26, winY + 61, 50, 6, ButtonType.SLIDER));
        this.field_146292_n.add(new Button(this, 11, winX + 80, winY + 59, 10, 10, ButtonType.ADD));
        for (int row = 0; row < 2; row = (int)((byte)(row + 1))) {
            for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
                int index = row * 9 + col;
                this.field_146292_n.add(new Button(this, 12 + index, winX + 17 + col * 12, winY + 78 + row * 12, 8, 8, ButtonType.PRESETS, RGB16Helper.getColor((short)this.presetIndex[index])));
            }
        }
        if (this.savePreset > -1) {
            for (GuiButton button : this.field_146292_n) {
                button.field_146124_l = false;
            }
            this.field_146292_n.add(new Button(this, 30, winX + 78, winY + 59, 10, 10, ButtonType.ICON, 1));
            this.field_146292_n.add(new Button(this, 31, winX + 93, winY + 59, 10, 10, ButtonType.ICON, 2));
            this.field_146292_n.add(new Button(this, 32, winX + 35, winY + 59, 10, 10, ButtonType.ICON, 3));
            if (this.savePreset < 32) {
                this.textField = new GuiTextField(33, this.field_146289_q, winX + 35, winY + 40, 68, 10);
                this.textField.func_146189_e(true);
                this.textField.func_146203_f(32);
                this.textField.func_146195_b(true);
                this.textField.func_146180_a("");
            }
        }
    }

    public void func_73876_c() {
        if (this.textField != null) {
            this.textField.func_146178_a();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer();
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        for (GuiButton button : this.field_146292_n) {
            button.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
        this.drawGuiContainerForegroundLayer(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    private void drawGuiContainerBackgroundLayer() {
        int winX = (this.field_146294_l - this.xSize) / 2;
        int winY = (this.field_146295_m - this.ySize) / 2;
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.field_146297_k.func_110434_K().func_110577_a(Textures.COLORIZER.get());
        this.func_73729_b(winX, winY, 0, 0, this.xSize, this.ySize);
        GuiFunctions.exitDrawTextureStateWithBlend();
        if (this.slider[0] != this.lastSlider[0] || this.slider[1] != this.lastSlider[1] || this.slider[2] != this.lastSlider[2]) {
            this.setupColors();
        }
        switch (this.mode) {
            case RGB: {
                GuiFunctions.drawGradientRect((int)(winX + 26), (int)(winY + 33), (int)(winX + 76), (int)(winY + 39), (float)this.field_73735_i, (int)-65536, (int)-16777216, (int)-16777216, (int)-65536);
                GuiFunctions.drawGradientRect((int)(winX + 26), (int)(winY + 47), (int)(winX + 76), (int)(winY + 53), (float)this.field_73735_i, (int)-16711936, (int)-16777216, (int)-16777216, (int)-16711936);
                GuiFunctions.drawGradientRect((int)(winX + 26), (int)(winY + 61), (int)(winX + 76), (int)(winY + 67), (float)this.field_73735_i, (int)-16776961, (int)-16777216, (int)-16777216, (int)-16776961);
                break;
            }
            case HSL: {
                GuiFunctions.drawTextureScaled((double)(winX + 26), (double)(winY + 33), (int)0, (int)250, (int)50, (int)6, (double)1.0, (float)this.field_73735_i, (int[])new int[]{77, 256});
                GuiFunctions.drawGradientRect((int)(winX + 26), (int)(winY + 47), (int)(winX + 76), (int)(winY + 53), (float)this.field_73735_i, (int)this.sColor, (int)-8421505, (int)-8421505, (int)this.sColor);
                GuiFunctions.drawGradientRect((int)(winX + 26), (int)(winY + 61), (int)(winX + 51), (int)(winY + 67), (float)this.field_73735_i, (int)this.lvColor, (int)-16777216, (int)-16777216, (int)this.lvColor);
                GuiFunctions.drawGradientRect((int)(winX + 51), (int)(winY + 61), (int)(winX + 76), (int)(winY + 67), (float)this.field_73735_i, (int)-1, (int)this.lvColor, (int)this.lvColor, (int)-1);
                break;
            }
            case HSV: {
                GuiFunctions.drawTextureScaled((double)(winX + 26), (double)(winY + 33), (int)0, (int)250, (int)50, (int)6, (double)1.0, (float)this.field_73735_i, (int[])new int[]{77, 256});
                GuiFunctions.drawGradientRect((int)(winX + 26), (int)(winY + 47), (int)(winX + 76), (int)(winY + 53), (float)this.field_73735_i, (int)this.sColor, (int)-1, (int)-1, (int)this.sColor);
                GuiFunctions.drawGradientRect((int)(winX + 26), (int)(winY + 61), (int)(winX + 76), (int)(winY + 67), (float)this.field_73735_i, (int)this.lvColor, (int)-16777216, (int)-16777216, (int)this.lvColor);
            }
        }
        GuiFunctions.drawTextureScaled((double)((double)winX + 24.75 + (double)(50.0f * this.slider[0])), (double)(winY + 33), (int)0, (int)206, (int)10, (int)24, (double)0.25, (float)this.field_73735_i, (int[])new int[0]);
        GuiFunctions.drawTextureScaled((double)((double)winX + 24.75 + (double)(50.0f * this.slider[1])), (double)(winY + 47), (int)0, (int)206, (int)10, (int)24, (double)0.25, (float)this.field_73735_i, (int[])new int[0]);
        GuiFunctions.drawTextureScaled((double)((double)winX + 24.75 + (double)(50.0f * this.slider[2])), (double)(winY + 61), (int)0, (int)206, (int)10, (int)24, (double)0.25, (float)this.field_73735_i, (int[])new int[0]);
        GuiColorizer.func_73734_a((int)(winX + 94), (int)(winY + 34), (int)(winX + 126), (int)(winY + 66), (int)RGB16Helper.getColor((short)this.resultIndex));
        if (this.savePreset < 0) {
            GuiFunctions.enterRenderItemState();
            this.field_146296_j.func_180450_b(this.resultStack, winX + 110, winY + 50);
            GuiFunctions.exitRenderItemState();
        }
    }

    private void drawGuiContainerForegroundLayer(int mouseX, int mouseY, float partialTicks) {
        int winX = (this.field_146294_l - this.xSize) / 2;
        int winY = (this.field_146295_m - this.ySize) / 2;
        if (this.savePreset < 0) {
            if (mouseX >= winX + 94 && mouseY >= winY + 34 && mouseX <= winX + 126 && mouseY <= winY + 66) {
                int dye = 15 - this.resultStack.func_77952_i();
                String dyename = EnumDyeColor.func_176766_a((int)dye).func_176762_d();
                String colorInfo = RGB16Helper.getTooltip((short)this.resultIndex) + "\u00a77 - \u00a7" + ItemColorizer.colorcode[dye] + dyename.substring(0, 1).toUpperCase() + dyename.substring(1);
                ArrayList<String> list = new ArrayList<String>();
                list.add(colorInfo);
                this.func_146283_a(list, mouseX, mouseY);
                return;
            }
            for (int id = 12; id <= 29; ++id) {
                GuiButton button = (GuiButton)this.field_146292_n.get(id);
                if (!button.func_146115_a()) continue;
                ArrayList<String> list = new ArrayList<String>();
                if (!Strings.isNullOrEmpty((String)this.presetName[id - 12])) {
                    list.add(this.presetName[id - 12]);
                }
                list.add(RGB16Helper.getTooltip((short)this.presetIndex[id - 12]));
                list.add("");
                list.add("\u00a77\u00a7o" + Localization.get((String)"info.colorizer.preset.save.txt"));
                list.add("\u00a77\u00a7o" + Localization.get((String)"info.colorizer.preset.load.txt"));
                this.func_146283_a(list, mouseX, mouseY);
                return;
            }
        } else {
            GuiFunctions.enterDrawTextureStateWithBlend();
            this.field_146297_k.func_110434_K().func_110577_a(Textures.COLORIZER.get());
            this.func_73729_b(winX + 18, winY + 28, 154, 0, 102, 53);
            GuiFunctions.exitDrawTextureStateWithBlend();
            ((GuiButton)this.field_146292_n.get(30)).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            ((GuiButton)this.field_146292_n.get(31)).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            ((GuiButton)this.field_146292_n.get(32)).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.textField.func_146194_f();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        for (GuiButton guibutton : this.field_146292_n) {
            if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
            GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.field_146292_n);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
            this.selectedButton = guibutton = event.getButton();
            guibutton.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(guibutton);
            if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.field_146292_n));
        }
        if (this.needsUpdate) {
            this.func_73866_w_();
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.selectedButton != null && state == 0) {
            this.selectedButton.func_146118_a(mouseX, mouseY);
            this.selectedButton = null;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k >= 0 && button.field_146127_k <= 2) {
            if (button.field_146127_k == 0) {
                if (this.mode != Mode.RGB) {
                    this.mode = Mode.RGB;
                    this.setSliders(ColorHelper.colorToRGB((int)this.resultColor));
                }
            } else if (button.field_146127_k == 1) {
                if (this.mode != Mode.HSL) {
                    this.mode = Mode.HSL;
                    this.setSliders(ColorHelper.colorToHSL((int)this.resultColor));
                }
            } else if (button.field_146127_k == 2 && this.mode != Mode.HSV) {
                this.mode = Mode.HSV;
                this.setSliders(ColorHelper.colorToHSV((int)this.resultColor));
            }
            return;
        }
        if (button.field_146127_k >= 3 && button.field_146127_k <= 11) {
            int index = button.field_146127_k - 3;
            float step = 0.01f;
            if (index % 3 == 0) {
                this.slider[index / 3] = MathHelper.func_76131_a((float)(this.slider[index / 3] - step), (float)0.0f, (float)1.0f);
            } else if (index % 3 == 2) {
                this.slider[index / 3] = MathHelper.func_76131_a((float)(this.slider[index / 3] + step), (float)0.0f, (float)1.0f);
            } else {
                double mx = (double)Mouse.getEventX() * (double)this.field_146294_l / (double)this.field_146297_k.field_71443_c - (double)((this.field_146294_l - this.xSize) / 2) - 26.0;
                double diff = mx - (double)((int)mx);
                diff = diff < (double)0.4f ? 0.0 : (diff > (double)0.6f ? 1.0 : 0.5);
                this.slider[index / 3] = MathHelper.func_76131_a((float)((float)(((double)((int)mx) + diff) * 2.0) / 100.0f), (float)0.0f, (float)1.0f);
            }
            return;
        }
        if (button.field_146127_k >= 12 && button.field_146127_k <= 29) {
            int index = button.field_146127_k - 12;
            if (Mouse.getEventButton() == 0) {
                this.resultIndex = this.presetIndex[index];
                this.resultColor = RGB16Helper.getColor((short)this.resultIndex);
                switch (this.mode) {
                    case RGB: {
                        this.setSliders(ColorHelper.colorToRGB((int)this.resultColor));
                        return;
                    }
                    case HSL: {
                        this.setSliders(ColorHelper.colorToHSL((int)this.resultColor));
                        return;
                    }
                    case HSV: {
                        this.setSliders(ColorHelper.colorToHSV((int)this.resultColor));
                        return;
                    }
                }
            } else if (Mouse.getEventButton() == 1) {
                this.savePreset = (byte)index;
                this.needsUpdate = true;
                return;
            }
        }
        if (button.field_146127_k == 30 || button.field_146127_k == 31) {
            if (button.field_146127_k == 30) {
                ItemStack stack = this.user.func_184614_ca();
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemColorizer) {
                    ((ItemColorizer)stack.func_77973_b()).setRGB16Preset(stack, this.savePreset, this.resultIndex, this.textField.func_146179_b());
                }
                NetworkHandler.sendToServer(new PacketColorizer(this.savePreset, this.resultIndex, this.textField.func_146179_b()));
            }
            this.savePreset = (byte)-1;
            this.needsUpdate = true;
            return;
        }
        if (button.field_146127_k == 32) {
            this.textField.func_146180_a(this.textField.func_146179_b() + "\u00a7");
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.savePreset == -1) {
            if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
                this.field_146297_k.func_147108_a(null);
                if (this.field_146297_k.field_71462_r == null) {
                    this.field_146297_k.func_71381_h();
                }
            }
            NetworkHandler.sendToServer(new PacketColorizer(-1, this.resultIndex, ""));
            return;
        }
        if (keyCode == 1 || keyCode == 28) {
            if (keyCode == 1) {
                this.savePreset = (byte)-1;
            } else {
                this.func_146284_a((GuiButton)this.field_146292_n.get(30));
            }
            this.func_73866_w_();
            return;
        }
        this.textField.func_146201_a(typedChar, keyCode);
    }

    private void setSliders(float[] values) {
        if (values != null && values.length == 3) {
            for (int index = 0; index < 3; index = (int)((byte)(index + 1))) {
                this.slider[index] = MathHelper.func_76131_a((float)values[index], (float)0.0f, (float)1.0f);
            }
        }
    }

    private void setupColors() {
        this.lastSlider[0] = this.slider[0];
        this.lastSlider[1] = this.slider[1];
        this.lastSlider[2] = this.slider[2];
        switch (this.mode) {
            case RGB: {
                this.resultColor = ColorHelper.rgbToColor((float)this.slider[0], (float)this.slider[1], (float)this.slider[2]);
                break;
            }
            case HSL: {
                this.sColor = ColorHelper.hslToColor((float)this.slider[0], (float)1.0f, (float)0.5f);
                this.lvColor = ColorHelper.hslToColor((float)this.slider[0], (float)this.slider[1], (float)0.5f);
                this.resultColor = ColorHelper.hslToColor((float)this.slider[0], (float)this.slider[1], (float)this.slider[2]);
                break;
            }
            case HSV: {
                this.sColor = ColorHelper.hsvToColor((float)this.slider[0], (float)1.0f, (float)1.0f);
                this.lvColor = ColorHelper.hsvToColor((float)this.slider[0], (float)this.slider[1], (float)1.0f);
                this.resultColor = ColorHelper.hsvToColor((float)this.slider[0], (float)this.slider[1], (float)this.slider[2]);
            }
        }
        this.resultIndex = RGB16Helper.getIndexFor((int)this.resultColor);
        byte meta = RGB16Helper.getSimpleColor((short)this.resultIndex);
        this.resultStack = new ItemStack(Blocks.field_150325_L, 1, (int)meta);
    }

    private static class Button
    extends GuiButton {
        private final GuiColorizer gui;
        private final ButtonType type;
        private int color;

        Button(GuiColorizer gui, int id, int x, int y, int width, int height, ButtonType type) {
            this(gui, id, x, y, width, height, type, "", -1);
        }

        Button(GuiColorizer gui, int id, int x, int y, int width, int height, ButtonType type, String buttonText) {
            this(gui, id, x, y, width, height, type, buttonText, -1);
        }

        Button(GuiColorizer gui, int id, int x, int y, int width, int height, ButtonType type, int color) {
            this(gui, id, x, y, width, height, type, "", color);
        }

        Button(GuiColorizer gui, int id, int x, int y, int width, int height, ButtonType type, String buttonText, int color) {
            super(id, x, y, width, height, buttonText);
            this.gui = gui;
            this.type = type;
            this.color = color;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            Point txPoint;
            if (!this.field_146125_m || this.type == ButtonType.SLIDER) {
                return;
            }
            boolean bl = this.field_146123_n = this.field_146124_l && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            if (this.type == ButtonType.MODE) {
                txPoint = this.gui.mode.toString().equals(this.field_146126_j) ? this.type.pressed : (this.field_146123_n ? this.type.hover : this.type.normal);
            } else {
                Point point = this.field_146123_n ? (Mouse.isButtonDown((int)0) ? this.type.pressed : this.type.hover) : (txPoint = this.type.normal);
            }
            if (this.type == ButtonType.PRESETS) {
                Gui.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)this.color);
                return;
            }
            GuiFunctions.enterDrawTextureStateWithBlend();
            mc.func_110434_K().func_110577_a(Textures.COLORIZER.get());
            this.func_73729_b(this.field_146128_h, this.field_146129_i, txPoint.x, txPoint.y, this.field_146120_f, this.field_146121_g);
            if (this.type == ButtonType.ICON) {
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 10 * this.color, 220, this.field_146120_f, this.field_146121_g);
            }
            GuiFunctions.exitDrawTextureStateWithBlend();
            if (!Strings.isNullOrEmpty((String)this.field_146126_j)) {
                float left = this.field_146128_h + this.field_146120_f / 2 - mc.field_71466_p.func_78256_a(this.field_146126_j) / 2;
                float top = this.field_146129_i + (this.field_146121_g - 8) / 2;
                mc.field_71466_p.func_175065_a(this.field_146126_j, left + 0.5f, top + 0.6f, 0x1A1A1A, false);
            }
        }
    }

    private static enum ButtonType {
        MODE(new Point(0, 240), new Point(32, 240), new Point(64, 240)),
        ADD(new Point(30, 230), new Point(40, 230), new Point(50, 230)),
        SUBTRACT(new Point(0, 230), new Point(10, 230), new Point(20, 230)),
        ICON(new Point(60, 230), new Point(70, 230), new Point(80, 230)),
        SLIDER(null, null, null),
        PRESETS(null, null, null);

        private final Point normal;
        private final Point hover;
        private final Point pressed;

        private ButtonType(Point normal, Point hover, Point pressed) {
            this.normal = normal;
            this.hover = hover;
            this.pressed = pressed;
        }
    }

    private static enum Mode {
        RGB,
        HSL,
        HSV;

    }
}

