/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.management;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.configuration.Configurations;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.api.util.MathUtils;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import com.ldtteam.structurize.util.StructureUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public final class Structures {
    public static final String SCHEMATIC_EXTENSION_NEW = ".blueprint";
    public static final String SCHEMATICS_PREFIX = "schematics";
    public static final String SCHEMATICS_CACHE = "cache";
    public static final String SCHEMATICS_SCAN = "scans";
    public static final String SCHEMATICS_ASSET_PATH = "/assets/";
    public static final String SCHEMATICS_SEPARATOR = "/";
    private static final Map<UUID, Tuple<Long, Map<Integer, byte[]>>> schematicPieces = new HashMap<UUID, Tuple<Long, Map<Integer, byte[]>>>();
    @NotNull
    private static final Map<String, Map<String, Map<String, String>>> schematicsMap = new HashMap<String, Map<String, Map<String, String>>>();
    @NotNull
    private static final Map<String, String> md5Map = new HashMap<String, String>();
    @NotNull
    private static final Map<String, String> fileMap = new HashMap<String, String>();
    private static boolean dirty = false;
    private static boolean allowPlayerSchematics = false;

    private Structures() {
    }

    public static void init() {
        Structures.loadStyleMaps();
    }

    private static void loadStyleMaps() {
        File schematicsFolder;
        if (!Configurations.gameplay.ignoreSchematicsFromJar) {
            Structures.loadStyleMapsJar();
        }
        if ((schematicsFolder = Structurize.proxy.getSchematicsFolder()) != null) {
            Log.getLogger().info("Load additionnal huts or decorations from " + schematicsFolder + SCHEMATICS_SEPARATOR + SCHEMATICS_PREFIX);
            Structures.checkDirectory(schematicsFolder.toPath().resolve(SCHEMATICS_PREFIX).toFile());
            Structures.loadSchematicsForPrefix(schematicsFolder.toPath(), SCHEMATICS_PREFIX);
        }
        for (File cachedSchems : StructureLoadingUtils.getCachedSchematicsFolders()) {
            if (cachedSchems == null) continue;
            Structures.checkDirectory(cachedSchems);
            Log.getLogger().info("Load cached schematic from " + cachedSchems + SCHEMATICS_SEPARATOR + SCHEMATICS_CACHE);
            Structures.checkDirectory(cachedSchems.toPath().resolve(SCHEMATICS_CACHE).toFile());
            Structures.loadSchematicsForPrefix(cachedSchems.toPath(), SCHEMATICS_CACHE);
        }
        if (md5Map.size() == 0) {
            Log.getLogger().error("Error loading StructureProxy directory. Things will break!");
        }
    }

    private static void loadStyleMapsJar() {
        for (String origin : StructureLoadingUtils.originFolders) {
            URI uri;
            try {
                uri = Manager.class.getResource(SCHEMATICS_ASSET_PATH + origin).toURI();
            }
            catch (URISyntaxException e) {
                Log.getLogger().error("loadStyleMaps : ", (Throwable)e);
                return;
            }
            if ("jar".equals(uri.getScheme())) {
                try {
                    FileSystem fileSystem = FileSystems.getFileSystem(uri);
                    Throwable throwable = null;
                    try {
                        Path basePath = fileSystem.getPath(SCHEMATICS_ASSET_PATH + origin, new String[0]);
                        Log.getLogger().info("Load huts or decorations from jar");
                        Structures.loadSchematicsForPrefix(basePath, SCHEMATICS_PREFIX);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileSystem == null) continue;
                        if (throwable != null) {
                            try {
                                fileSystem.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileSystem.close();
                    }
                }
                catch (IOException | FileSystemNotFoundException e1) {
                    try {
                        FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                        Throwable throwable = null;
                        try {
                            Path basePath = fileSystem.getPath(SCHEMATICS_ASSET_PATH + origin, new String[0]);
                            Log.getLogger().info("Load huts or decorations from jar");
                            Structures.loadSchematicsForPrefix(basePath, SCHEMATICS_PREFIX);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (fileSystem == null) continue;
                            if (throwable != null) {
                                try {
                                    fileSystem.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            fileSystem.close();
                        }
                    }
                    catch (IOException e2) {
                        Log.getLogger().warn("loadStyleMaps: Could not load the schematics from the jar.", (Throwable)e2);
                    }
                }
                continue;
            }
            Path basePath = Paths.get(uri);
            Log.getLogger().info("Load huts or decorations from uri");
            Structures.loadSchematicsForPrefix(basePath, SCHEMATICS_PREFIX);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void loadScannedStyleMaps() {
        if (!allowPlayerSchematics && FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        schematicsMap.remove(SCHEMATICS_SCAN);
        for (File clientSchems : StructureLoadingUtils.getClientSchematicsFolders()) {
            Structures.checkDirectory(clientSchems.toPath().resolve(SCHEMATICS_SCAN).toFile());
            Structures.loadSchematicsForPrefix(clientSchems.toPath(), SCHEMATICS_SCAN);
        }
    }

    private static void checkDirectory(@NotNull File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }

    private static void loadSchematicsForPrefix(@NotNull Path basePath, @NotNull String prefix) {
        try (Stream<Path> walk = Files.walk(basePath.resolve(prefix), new FileVisitOption[0]);){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                String fileExtension = SCHEMATIC_EXTENSION_NEW;
                if (!path.toString().endsWith(SCHEMATIC_EXTENSION_NEW)) continue;
                String relativePath = path.toString().substring(basePath.toString().length()).split("\\.blueprint")[0];
                if (!SCHEMATICS_SEPARATOR.equals(path.getFileSystem().getSeparator())) {
                    relativePath = relativePath.replace(path.getFileSystem().getSeparator(), SCHEMATICS_SEPARATOR);
                }
                if (relativePath.startsWith(SCHEMATICS_SEPARATOR)) {
                    relativePath = relativePath.substring(1);
                }
                StructureName structureName = new StructureName(relativePath);
                fileMap.put(structureName.toString(), SCHEMATIC_EXTENSION_NEW);
                String md5 = StructureUtils.calculateMD5(StructureLoadingUtils.getStream(relativePath));
                if (md5 == null) {
                    fileMap.remove(structureName.toString());
                    Log.getLogger().error("Structures: " + structureName + " with md5 null.");
                    continue;
                }
                if (!Structures.isSchematicSizeValid(structureName.toString())) continue;
                md5Map.put(structureName.toString(), md5);
                if (!Structurize.isClient()) continue;
                Structures.addSchematic(structureName);
            }
        }
        catch (IOException e) {
            Log.getLogger().warn("loadSchematicsForPrefix: Could not load schematics from " + basePath.resolve(prefix), (Throwable)e);
        }
    }

    private static boolean isSchematicSizeValid(@NotNull String structureName) {
        byte[] data = StructureLoadingUtils.getStreamAsByteArray(StructureLoadingUtils.getStream(structureName));
        byte[] compressed = StructureUtils.compress(data);
        if (compressed == null) {
            Log.getLogger().warn("Compressed structure returned null, please retry, this shouldn't happen, ever.");
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private static void addSchematic(@NotNull StructureName structureName) {
        Map<String, Map<String, String>> sectionMap;
        if (structureName.getPrefix().equals(SCHEMATICS_CACHE)) {
            return;
        }
        if (!schematicsMap.containsKey(structureName.getSection())) {
            schematicsMap.put(structureName.getSection(), new HashMap());
        }
        if (!(sectionMap = schematicsMap.get(structureName.getSection())).containsKey(structureName.getStyle())) {
            sectionMap.put(structureName.getStyle(), new TreeMap());
        }
        Map<String, String> styleMap = sectionMap.get(structureName.getStyle());
        styleMap.put(structureName.getSchematic(), structureName.toString());
    }

    public static boolean isDirty() {
        return dirty;
    }

    public static void clearDirty() {
        dirty = false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isPlayerSchematicsAllowed() {
        return allowPlayerSchematics;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setAllowPlayerSchematics(boolean allowed) {
        allowPlayerSchematics = allowed;
    }

    @SideOnly(value=Side.CLIENT)
    public static StructureName renameScannedStructure(@NotNull StructureName structureName, @NotNull String name) {
        if (!SCHEMATICS_SCAN.equals(structureName.getPrefix())) {
            Log.getLogger().warn("Renamed failed: Invalid name " + structureName);
            return null;
        }
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Renamed failed: No MD5 hash found for " + structureName);
            return null;
        }
        StructureName newStructureName = new StructureName("scans/" + name);
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Renamed failed: File already exist " + newStructureName);
            return null;
        }
        for (File clientSchems : StructureLoadingUtils.getClientSchematicsFolders()) {
            File structureFile = clientSchems.toPath().resolve(structureName.toString() + Structures.getFileExtension(structureName.toString())).toFile();
            File newStructureFile = clientSchems.toPath().resolve(newStructureName.toString() + Structures.getFileExtension(structureName.toString())).toFile();
            Structures.checkDirectory(newStructureFile.getParentFile());
            if (structureFile.renameTo(newStructureFile)) {
                String md5 = Structures.getMD5(structureName.toString());
                md5Map.put(newStructureName.toString(), md5);
                md5Map.remove(structureName.toString());
                fileMap.put(newStructureName.toString(), fileMap.get(structureName.toString()));
                fileMap.remove(structureName.toString());
                Log.getLogger().info("Structure " + structureName + " have been renamed " + newStructureName);
                return newStructureName;
            }
            Log.getLogger().warn("Failed to rename structure from " + structureName + " to " + newStructureName);
            Log.getLogger().warn("Failed to rename structure from " + structureFile + " to " + newStructureFile);
        }
        return null;
    }

    public static boolean hasMD5(@NotNull StructureName structureName) {
        return Structures.hasMD5(structureName.toString());
    }

    public static String getMD5(@NotNull String structureName) {
        if (!md5Map.containsKey(structureName)) {
            return null;
        }
        return md5Map.get(structureName);
    }

    public static boolean hasMD5(@NotNull String structureName) {
        return md5Map.containsKey(structureName);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean deleteScannedStructure(@NotNull StructureName structureName) {
        if (!SCHEMATICS_SCAN.equals(structureName.getPrefix())) {
            Log.getLogger().warn("Delete failed: Invalid name " + structureName);
            return false;
        }
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Delete failed: No MD5 hash found for " + structureName);
            return false;
        }
        for (File clientSchems : StructureLoadingUtils.getClientSchematicsFolders()) {
            File structureFile = clientSchems.toPath().resolve(structureName.toString() + SCHEMATIC_EXTENSION_NEW).toFile();
            if (structureFile.delete()) {
                md5Map.remove(structureName.toString());
                Log.getLogger().info("Structures: " + structureName + " deleted successfully");
                return true;
            }
            Log.getLogger().warn("Failed to delete structure " + structureName);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public static List<String> getSections() {
        ArrayList<String> list = new ArrayList<String>(schematicsMap.keySet());
        Collections.sort(list);
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public static List<String> getStylesFor(String section) {
        if (schematicsMap.containsKey(section)) {
            Map<String, Map<String, String>> sectionMap = schematicsMap.get(section);
            ArrayList<String> list = new ArrayList<String>(sectionMap.keySet());
            Collections.sort(list);
            return list;
        }
        return new ArrayList<String>();
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public static List<String> getSchematicsFor(String section, String style) {
        Map<String, Map<String, String>> sectionMap;
        if (schematicsMap.containsKey(section) && (sectionMap = schematicsMap.get(section)).containsKey(style)) {
            ArrayList<String> list = new ArrayList<String>(sectionMap.get(style).values());
            Collections.sort(list);
            return list;
        }
        return new ArrayList<String>();
    }

    public static StructureName getStructureNameByMD5(String md5) {
        if (md5 != null) {
            for (Map.Entry<String, String> md5Entry : md5Map.entrySet()) {
                if (!md5Entry.getValue().equals(md5)) continue;
                return new StructureName(md5Entry.getKey());
            }
        }
        return null;
    }

    public static String getFileExtension(String structureName) {
        if (!fileMap.containsKey(structureName)) {
            return null;
        }
        return fileMap.get(structureName);
    }

    public static Map<String, String> getMD5s() {
        return md5Map;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setMD5s(Map<String, String> md5s) {
        schematicsMap.entrySet().removeIf(entry -> !((String)entry.getKey()).equals(SCHEMATICS_SCAN));
        for (Map.Entry<String, String> md5 : md5s.entrySet()) {
            StructureName sn = new StructureName(md5.getKey());
            if (sn.getSection().equals(SCHEMATICS_SCAN)) continue;
            md5Map.put(md5.getKey(), md5.getValue());
            Structures.addSchematic(sn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean handleSaveSchematicMessage(byte[] bytes, UUID id, int pieces, int piece) {
        Map<Integer, byte[]> schemPieces;
        for (Map.Entry<UUID, Tuple<Long, Map<Integer, byte[]>>> entry2 : new HashSet<Map.Entry<UUID, Tuple<Long, Map<Integer, byte[]>>>>(schematicPieces.entrySet())) {
            if (MathUtils.nanoSecondsToSeconds(System.nanoTime() - (Long)entry2.getValue().func_76341_a()) <= 60L) continue;
            schematicPieces.remove(entry2.getKey());
            Log.getLogger().warn("Waiting too long for piece of structure, discarding it");
        }
        if (pieces == 1) {
            return Structures.handleSaveSchematicMessage(bytes);
        }
        if (!Structures.canStoreNewSchematic()) {
            Log.getLogger().warn("Could not store schematic in cache");
            return false;
        }
        Log.getLogger().info("Recieved piece: " + piece + " of: " + pieces + " with the size: " + bytes.length + " and ID: " + id.toString());
        if (schematicPieces.containsKey(id)) {
            Tuple<Long, Map<Integer, byte[]>> schemTuple = schematicPieces.remove(id);
            schemPieces = (Map)schemTuple.func_76340_b();
            if (MathUtils.nanoSecondsToSeconds(System.nanoTime() - (Long)schemTuple.func_76341_a()) > 60L) {
                Log.getLogger().warn("Waiting too long for piece: " + piece);
                return false;
            }
            if (schemPieces.containsKey(piece)) {
                Log.getLogger().warn("Already had piece: " + piece);
                return false;
            }
            schemPieces.put(piece, bytes);
            if (schemPieces.size() == pieces) {
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    schemPieces.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                        try {
                            outputStream.write((byte[])entry.getValue());
                        }
                        catch (IOException e) {
                            Log.getLogger().error("Error combining byte arrays of schematic pieces.", (Throwable)e);
                        }
                    });
                    boolean bl = Structures.handleSaveSchematicMessage(outputStream.toByteArray());
                    return bl;
                }
                catch (IOException e) {
                    Log.getLogger().error("Error combining byte arrays of schematic pieces.", (Throwable)e);
                    return false;
                }
            }
        } else {
            schemPieces = new HashMap<Integer, byte[]>();
            schemPieces.put(piece, bytes);
        }
        schematicPieces.put(id, (Tuple<Long, Map<Integer, byte[]>>)new Tuple((Object)System.nanoTime(), schemPieces));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean handleSaveSchematicMessage(byte[] bytes) {
        if (!Structures.canStoreNewSchematic()) {
            Log.getLogger().warn("Could not store schematic in cache");
            return false;
        }
        String md5 = StructureUtils.calculateMD5(bytes);
        if (md5 == null) {
            Log.getLogger().info("Structures.handleSaveSchematicMessage: Could not calculate the MD5 hash");
            return false;
        }
        Log.getLogger().info("Structures.handleSaveSchematicMessage: received new schematic md5:" + md5);
        Iterator<File> iterator = StructureLoadingUtils.getCachedSchematicsFolders().iterator();
        while (iterator.hasNext()) {
            File cachedSchems = iterator.next();
            File schematicFile = cachedSchems.toPath().resolve("cache/" + md5 + SCHEMATIC_EXTENSION_NEW).toFile();
            Structures.checkDirectory(schematicFile.getParentFile());
            try (FileOutputStream outputstream = new FileOutputStream(schematicFile);){
                ((OutputStream)outputstream).write(bytes);
                Structures.addMD5ToCache(md5);
                Manager.setSchematicDownloaded(true);
                fileMap.put("cache/" + md5, SCHEMATIC_EXTENSION_NEW);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                Log.getLogger().warn("Exception while trying to save a schematic.", (Throwable)e);
            }
        }
        return false;
    }

    private static boolean canStoreNewSchematic() {
        if (Structurize.isClient()) {
            return true;
        }
        if (!Configurations.gameplay.allowPlayerSchematics) {
            return false;
        }
        Set<String> md5Set = Structures.getCachedMD5s();
        if (md5Set.size() < Configurations.gameplay.maxCachedSchematics) {
            return true;
        }
        Iterator<String> iterator = md5Set.iterator();
        while (iterator.hasNext() && md5Set.size() >= Configurations.gameplay.maxCachedSchematics) {
            StructureName sn = new StructureName(iterator.next());
            if (!Structures.deleteCachedStructure(sn)) continue;
            iterator.remove();
        }
        return md5Set.size() < Configurations.gameplay.maxCachedSchematics;
    }

    public static void addMD5ToCache(@NotNull String md5) {
        Structures.markDirty();
        md5Map.put("cache/" + md5, md5);
    }

    private static Set<String> getCachedMD5s() {
        HashSet<String> md5Set = new HashSet<String>();
        for (Map.Entry<String, String> md5 : md5Map.entrySet()) {
            StructureName sn = new StructureName(md5.getKey());
            if (!sn.getSection().equals(SCHEMATICS_CACHE)) continue;
            md5Set.add(md5.getKey());
        }
        return md5Set;
    }

    private static boolean deleteCachedStructure(@NotNull StructureName structureName) {
        if (!SCHEMATICS_CACHE.equals(structureName.getPrefix())) {
            Log.getLogger().warn("Delete failed: Invalid name " + structureName);
            return false;
        }
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Delete failed: No MD5 hash found for " + structureName);
            return false;
        }
        File structureFileBlueprint = Structurize.proxy.getSchematicsFolder().toPath().resolve(structureName.toString() + SCHEMATIC_EXTENSION_NEW).toFile();
        if (structureFileBlueprint.delete()) {
            md5Map.remove(structureName.toString());
            fileMap.remove(structureName.toString());
            return true;
        }
        Log.getLogger().warn("Failed to delete structure " + structureName);
        return false;
    }

    private static void markDirty() {
        dirty = true;
    }
}

