/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.lib;

import com.google.common.base.Functions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.BlueprintBlockAccess;
import com.ldtteam.structures.client.BlueprintBlockInfoTransformHandler;
import com.ldtteam.structures.client.BlueprintEntityInfoTransformHandler;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.util.BlockInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlueprintUtils {
    private static final Cache<Blueprint, Map<BlockPos, BlockInfo>> blueprintBlockInfoCache = CacheBuilder.newBuilder().maximumSize(50L).build();
    private static final Set<String> blackListedTileEntityIds = Sets.newHashSet();
    private static final Set<String> blackListedEntityIds = Sets.newHashSet();

    private BlueprintUtils() {
        throw new IllegalArgumentException("Utils class");
    }

    public static TileEntity getTileEntityFromPos(Blueprint blueprint, BlockPos pos, BlueprintBlockAccess access) {
        BlockInfo blockInfo = BlueprintUtils.getBlockInfoFromPos(blueprint, pos);
        if (blockInfo.getTileEntityData() != null) {
            return TileEntity.func_190200_a((World)access, (NBTTagCompound)blockInfo.getTileEntityData());
        }
        return null;
    }

    public static BlockInfo getBlockInfoFromPos(Blueprint blueprint, BlockPos pos) {
        try {
            return BlueprintBlockInfoTransformHandler.getInstance().Transform(Optional.ofNullable(((Map)blueprintBlockInfoCache.get((Object)blueprint, () -> blueprint.getBlockInfoAsList().stream().collect(Collectors.toMap(BlockInfo::getPos, Functions.identity())))).get(pos)).orElse(new BlockInfo(pos, Blocks.field_150350_a.func_176223_P(), null)));
        }
        catch (ExecutionException e) {
            Log.getLogger().warn((Object)e);
            return new BlockInfo(pos, Blocks.field_150350_a.func_176223_P(), null);
        }
    }

    public static BlockPos getPrimaryBlockOffset(@NotNull Blueprint blueprint) {
        return blueprint.getBlockInfoAsList().stream().filter(blockInfo -> blockInfo.getState().func_177230_c() instanceof IAnchorBlock).findFirst().map(blockInfo -> BlueprintBlockInfoTransformHandler.getInstance().Transform((BlockInfo)blockInfo)).map(BlockInfo::getPos).orElse(new BlockPos(blueprint.getSizeX() / 2, 0, blueprint.getSizeZ() / 2));
    }

    @NotNull
    public static List<TileEntity> instantiateTileEntities(@NotNull Blueprint blueprint, @NotNull BlueprintBlockAccess blockAccess) {
        return blueprint.getBlockInfoAsList().stream().map(blockInfo -> BlueprintBlockInfoTransformHandler.getInstance().Transform((BlockInfo)blockInfo)).filter(blockInfo -> blockInfo.getTileEntityData() != null).map(blockInfo -> BlueprintUtils.constructTileEntity(blockInfo, blockAccess)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public static List<Entity> instantiateEntities(@NotNull Blueprint blueprint, @NotNull BlueprintBlockAccess blockAccess) {
        return blueprint.getEntitiesAsList().stream().map(entityInfo -> BlueprintEntityInfoTransformHandler.getInstance().Transform((Tuple<BlockPos, NBTTagCompound>)entityInfo)).map(entityInfo -> BlueprintUtils.constructEntity((Tuple<BlockPos, NBTTagCompound>)entityInfo, blockAccess)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static TileEntity constructTileEntity(@NotNull BlockInfo info, @NotNull BlueprintBlockAccess blockAccess) {
        if (info.getTileEntityData() == null) {
            return null;
        }
        String entityId = info.getTileEntityData().func_74779_i("id");
        if (blackListedTileEntityIds.contains(entityId)) {
            return null;
        }
        try {
            NBTTagCompound compound = info.getTileEntityData().func_74737_b();
            compound.func_74768_a("x", info.getPos().func_177958_n());
            compound.func_74768_a("y", info.getPos().func_177956_o());
            compound.func_74768_a("z", info.getPos().func_177952_p());
            TileEntity entity = TileEntity.func_190200_a((World)blockAccess, (NBTTagCompound)compound);
            entity.func_145834_a((World)blockAccess);
            return entity;
        }
        catch (Exception ex) {
            Structurize.getLogger().error("Could not create tile entity: " + entityId + " with nbt: " + info.toString(), (Throwable)ex);
            blackListedTileEntityIds.add(entityId);
            return null;
        }
    }

    @Nullable
    private static Entity constructEntity(@Nullable Tuple<BlockPos, NBTTagCompound> info, @NotNull BlueprintBlockAccess blockAccess) {
        if (info.func_76340_b() == null) {
            return null;
        }
        String entityId = ((NBTTagCompound)info.func_76340_b()).func_74779_i("id");
        if (blackListedEntityIds.contains(entityId)) {
            return null;
        }
        try {
            NBTTagCompound compound = ((NBTTagCompound)info.func_76340_b()).func_74737_b();
            Vec3d vec3d1 = new Vec3d((Vec3i)info.func_76341_a());
            NBTTagList nbttaglist = new NBTTagList();
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72450_a));
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72448_b));
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72449_c));
            compound.func_74782_a("Pos", (NBTBase)nbttaglist);
            compound.func_186854_a("UUID", UUID.randomUUID());
            compound.func_74768_a("TileX", (int)vec3d1.field_72450_a);
            compound.func_74768_a("TileY", (int)vec3d1.field_72448_b);
            compound.func_74768_a("TileZ", (int)vec3d1.field_72449_c);
            return EntityList.func_75615_a((NBTTagCompound)compound, (World)blockAccess);
        }
        catch (Exception ex) {
            Structurize.getLogger().error("Could not create entity: " + entityId + " with nbt: " + info.toString(), (Throwable)ex);
            blackListedEntityIds.add(entityId);
            return null;
        }
    }
}

