/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.blueprints.v1;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.LogManager;

public class BlueprintUtil {
    public static Blueprint createBlueprint(World world, BlockPos pos, short sizeX, short sizeY, short sizeZ) {
        return BlueprintUtil.createBlueprint(world, pos, sizeX, sizeY, sizeZ, null, new String[0]);
    }

    public static Blueprint createBlueprint(World world, BlockPos pos, short sizeX, short sizeY, short sizeZ, String name, String ... architects) {
        ArrayList<IBlockState> pallete = new ArrayList<IBlockState>();
        pallete.add(Blocks.field_150350_a.func_176223_P());
        short[][][] structure = new short[sizeY][sizeZ][sizeX];
        ArrayList<NBTTagCompound> tileEntities = new ArrayList<NBTTagCompound>();
        ArrayList<String> requiredMods = new ArrayList<String>();
        for (BlockPos.MutableBlockPos mutablePos : BlockPos.func_177975_b((BlockPos)pos, (BlockPos)pos.func_177982_a(sizeX - 1, sizeY - 1, sizeZ - 1))) {
            TileEntity te;
            IBlockState state = world.func_180495_p((BlockPos)mutablePos);
            String modName = state.func_177230_c().getRegistryName().func_110624_b();
            short x = (short)(mutablePos.func_177958_n() - pos.func_177958_n());
            short y = (short)(mutablePos.func_177956_o() - pos.func_177956_o());
            short z = (short)(mutablePos.func_177952_p() - pos.func_177952_p());
            if (!requiredMods.contains(modName)) {
                if (Loader.isModLoaded((String)modName)) {
                    requiredMods.add(modName);
                }
            } else if (!Loader.isModLoaded((String)modName)) {
                structure[y][z][x] = (short)pallete.indexOf(Blocks.field_150350_a.func_176223_P());
                continue;
            }
            if ((te = world.func_175625_s((BlockPos)mutablePos)) != null) {
                NBTTagCompound teTag = te.serializeNBT();
                teTag.func_74777_a("x", x);
                teTag.func_74777_a("y", y);
                teTag.func_74777_a("z", z);
                tileEntities.add(teTag);
            }
            if (!pallete.contains(state)) {
                pallete.add(state);
            }
            structure[y][z][x] = (short)pallete.indexOf(state);
        }
        NBTTagCompound[] tes = new NBTTagCompound[tileEntities.size()];
        tes = tileEntities.toArray(tes);
        ArrayList<NBTTagCompound> entitiesTag = new ArrayList<NBTTagCompound>();
        List entities = world.func_72839_b(null, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + sizeX), (double)(pos.func_177956_o() + sizeY), (double)(pos.func_177952_p() + sizeZ)));
        for (Entity entity : entities) {
            Vec3d oldPos = entity.func_174791_d();
            entity.func_70107_b(oldPos.field_72450_a - (double)pos.func_177958_n(), oldPos.field_72448_b - (double)pos.func_177956_o(), oldPos.field_72449_c - (double)pos.func_177952_p());
            NBTTagCompound entityTag = new NBTTagCompound();
            if (entity.func_70039_c(entityTag)) {
                entitiesTag.add(entityTag);
            }
            entity.func_70107_b(oldPos.field_72450_a, oldPos.field_72448_b, oldPos.field_72449_c);
        }
        Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, (short)pallete.size(), pallete, structure, tes, requiredMods);
        schem.setEntities(entitiesTag.toArray(new NBTTagCompound[0]));
        if (name != null) {
            schem.setName(name);
        }
        if (architects != null) {
            schem.setArchitects(architects);
        }
        return schem;
    }

    public static NBTTagCompound writeBlueprintToNBT(Blueprint schem) {
        NBTTagCompound[] entities;
        NBTTagCompound[] tes;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("version", (byte)1);
        tag.func_74777_a("size_x", schem.getSizeX());
        tag.func_74777_a("size_y", schem.getSizeY());
        tag.func_74777_a("size_z", schem.getSizeZ());
        IBlockState[] palette = schem.getPalette();
        NBTTagList paletteTag = new NBTTagList();
        for (short i = 0; i < schem.getPalleteSize(); i = (short)(i + 1)) {
            NBTTagCompound state = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)state, (IBlockState)palette[i]);
            paletteTag.func_74742_a((NBTBase)state);
        }
        tag.func_74782_a("palette", (NBTBase)paletteTag);
        int[] blockInt = BlueprintUtil.convertBlocksToSaveData(schem.getStructure(), schem.getSizeX(), schem.getSizeY(), schem.getSizeZ());
        tag.func_74783_a("blocks", blockInt);
        NBTTagList finishedTes = new NBTTagList();
        for (NBTTagCompound te : tes = (NBTTagCompound[])Arrays.stream(schem.getTileEntities()).flatMap(Arrays::stream).flatMap(Arrays::stream).filter(Objects::nonNull).toArray(NBTTagCompound[]::new)) {
            finishedTes.func_74742_a((NBTBase)te);
        }
        tag.func_74782_a("tile_entities", (NBTBase)finishedTes);
        NBTTagList finishedEntities = new NBTTagList();
        for (NBTTagCompound entity : entities = (NBTTagCompound[])Arrays.stream(schem.getEntities()).flatMap(Arrays::stream).flatMap(Arrays::stream).filter(Objects::nonNull).toArray(NBTTagCompound[]::new)) {
            finishedEntities.func_74742_a((NBTBase)entity);
        }
        tag.func_74782_a("entities", (NBTBase)finishedEntities);
        List<String> requiredMods = schem.getRequiredMods();
        NBTTagList modsList = new NBTTagList();
        for (String requiredMod : requiredMods) {
            modsList.func_74742_a((NBTBase)new NBTTagString(requiredMod));
        }
        tag.func_74782_a("required_mods", (NBTBase)modsList);
        String name = schem.getName();
        String[] architects = schem.getArchitects();
        if (name != null) {
            tag.func_74778_a("name", name);
        }
        if (architects != null) {
            NBTTagList architectsTag = new NBTTagList();
            for (String architect : architects) {
                architectsTag.func_74742_a((NBTBase)new NBTTagString(architect));
            }
            tag.func_74782_a("architects", (NBTBase)architectsTag);
        }
        return tag;
    }

    public static Blueprint readBlueprintFromNBT(NBTTagCompound nbtTag, DataFixer fixer) {
        NBTTagCompound tag = fixer.func_188257_a((IFixType)FixTypes.STRUCTURE, nbtTag);
        byte version = tag.func_74771_c("version");
        if (version == 1) {
            short sizeX = tag.func_74765_d("size_x");
            short sizeY = tag.func_74765_d("size_y");
            short sizeZ = tag.func_74765_d("size_z");
            ArrayList<String> requiredMods = new ArrayList<String>();
            ArrayList missingMods = new ArrayList();
            NBTTagList modsList = (NBTTagList)tag.func_74781_a("required_mods");
            int modListSize = modsList.func_74745_c();
            for (int i = 0; i < modListSize; ++i) {
                requiredMods.add(((NBTTagString)modsList.func_179238_g(i)).func_150285_a_());
                if (Loader.isModLoaded((String)((String)requiredMods.get(i)))) continue;
                LogManager.getLogger().warn("Found missing mods for Blueprint, some blocks may be missing: " + (String)requiredMods.get(i));
                missingMods.add(requiredMods.get(i));
            }
            NBTTagList paletteTag = (NBTTagList)tag.func_74781_a("palette");
            short paletteSize = (short)paletteTag.func_74745_c();
            ArrayList<IBlockState> palette = new ArrayList<IBlockState>();
            for (short i = 0; i < paletteSize; i = (short)(i + 1)) {
                palette.add(i, NBTUtil.func_190008_d((NBTTagCompound)paletteTag.func_150305_b((int)i)));
            }
            short[][][] blocks = BlueprintUtil.convertSaveDataToBlocks(tag.func_74759_k("blocks"), sizeX, sizeY, sizeZ);
            NBTTagList teTag = (NBTTagList)tag.func_74781_a("tile_entities");
            NBTTagCompound[] tileEntities = new NBTTagCompound[teTag.func_74745_c()];
            for (int i = 0; i < tileEntities.length; i = (int)((short)(i + 1))) {
                tileEntities[i] = teTag.func_150305_b(i);
            }
            NBTTagList entitiesTag = (NBTTagList)tag.func_74781_a("entities");
            NBTTagCompound[] entities = new NBTTagCompound[entitiesTag.func_74745_c()];
            for (int i = 0; i < entities.length; i = (int)((short)(i + 1))) {
                entities[i] = entitiesTag.func_150305_b(i);
            }
            Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, paletteSize, palette, blocks, tileEntities, requiredMods).setMissingMods(missingMods.toArray(new String[0]));
            schem.setEntities(entities);
            if (tag.func_74764_b("name")) {
                schem.setName(tag.func_74779_i("name"));
            }
            if (tag.func_74764_b("architects")) {
                NBTTagList architectsTag = (NBTTagList)tag.func_74781_a("architects");
                String[] architects = new String[architectsTag.func_74745_c()];
                for (int i = 0; i < architectsTag.func_74745_c(); ++i) {
                    architects[i] = architectsTag.func_150307_f(i);
                }
                schem.setArchitects(architects);
            }
            return schem;
        }
        return null;
    }

    public static void writeToStream(OutputStream os, Blueprint schem) {
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)BlueprintUtil.writeBlueprintToNBT(schem), (OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int[] convertBlocksToSaveData(short[][][] multDimArray, short sizeX, short sizeY, short sizeZ) {
        int currentInt;
        short[] oneDimArray = new short[sizeX * sizeY * sizeZ];
        int j = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    oneDimArray[j++] = multDimArray[y][z][x];
                }
            }
        }
        int[] ints = new int[(int)Math.ceil((float)oneDimArray.length / 2.0f)];
        for (int i = 1; i < oneDimArray.length; i += 2) {
            currentInt = oneDimArray[i - 1];
            ints[(int)Math.ceil((double)((double)((float)i / 2.0f))) - 1] = currentInt = currentInt << 16 | oneDimArray[i];
        }
        if (oneDimArray.length % 2 == 1) {
            ints[ints.length - 1] = currentInt = oneDimArray[oneDimArray.length - 1] << 16;
        }
        return ints;
    }

    private static short[][][] convertSaveDataToBlocks(int[] ints, short sizeX, short sizeY, short sizeZ) {
        short[] oneDimArray = new short[ints.length * 2];
        for (int i = 0; i < ints.length; ++i) {
            oneDimArray[i * 2] = (short)(ints[i] >> 16);
            oneDimArray[i * 2 + 1] = (short)ints[i];
        }
        short[][][] multDimArray = new short[sizeY][sizeZ][sizeX];
        int i = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    multDimArray[y][z][x] = oneDimArray[i++];
                }
            }
        }
        return multDimArray;
    }
}

