/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.blueprints.v1;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.util.BlockInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;

public class Blueprint {
    private final List<String> requiredMods;
    private short sizeX;
    private short sizeY;
    private short sizeZ;
    private short palleteSize;
    private List<IBlockState> palette;
    private String name;
    private String[] architects;
    private String[] missingMods;
    private short[][][] structure;
    private NBTTagCompound[][][] tileEntities;
    private NBTTagCompound[][][] entities;

    protected Blueprint(short sizeX, short sizeY, short sizeZ, short palleteSize, List<IBlockState> pallete, short[][][] structure, NBTTagCompound[] tileEntities, List<String> requiredMods) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.palleteSize = palleteSize;
        this.palette = pallete;
        this.structure = structure;
        this.tileEntities = new NBTTagCompound[sizeY][sizeZ][sizeX];
        for (NBTTagCompound te : tileEntities) {
            if (te == null) continue;
            this.tileEntities[te.func_74765_d((String)"y")][te.func_74765_d((String)"z")][te.func_74765_d((String)"x")] = te;
        }
        this.requiredMods = requiredMods;
    }

    public Blueprint(short sizeX, short sizeY, short sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.structure = new short[sizeY][sizeZ][sizeX];
        this.tileEntities = new NBTTagCompound[sizeY][sizeZ][sizeX];
        this.entities = new NBTTagCompound[sizeY][sizeZ][sizeX];
        this.requiredMods = new ArrayList<String>();
        this.palette = new ArrayList<IBlockState>();
        this.palette.add(0, ModBlocks.blockSubstitution.func_176223_P());
    }

    public short getSizeX() {
        return this.sizeX;
    }

    public short getSizeY() {
        return this.sizeY;
    }

    public short getSizeZ() {
        return this.sizeZ;
    }

    public short getPalleteSize() {
        return this.palleteSize;
    }

    public IBlockState[] getPalette() {
        return this.palette.toArray(new IBlockState[0]);
    }

    public void addBlockState(BlockPos pos, IBlockState state) {
        int index = -1;
        for (int i = 0; i < this.palette.size(); ++i) {
            if (!this.palette.get(i).equals(state)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = this.palleteSize + 1;
            this.palleteSize = (short)(this.palleteSize + 1);
            this.palette.add(state);
        }
        this.structure[pos.func_177956_o()][pos.func_177952_p()][pos.func_177958_n()] = (short)index;
    }

    public short[][][] getStructure() {
        return this.structure;
    }

    public NBTTagCompound[][][] getTileEntities() {
        return this.tileEntities;
    }

    public NBTTagCompound[][][] getEntities() {
        return this.entities;
    }

    public void setEntities(NBTTagCompound[] entities) {
        this.entities = new NBTTagCompound[this.sizeY][this.sizeZ][this.sizeX];
        for (NBTTagCompound te : entities) {
            if (te == null) continue;
            this.entities[te.func_74765_d((String)"y")][te.func_74765_d((String)"z")][te.func_74765_d((String)"x")] = te;
        }
    }

    public List<String> getRequiredMods() {
        return this.requiredMods;
    }

    public String getName() {
        return this.name;
    }

    public Blueprint setName(String name) {
        this.name = name;
        return this;
    }

    public String[] getArchitects() {
        return this.architects;
    }

    public Blueprint setArchitects(String[] architects) {
        this.architects = architects;
        return this;
    }

    public String[] getMissingMods() {
        return this.missingMods;
    }

    public Blueprint setMissingMods(String ... missingMods) {
        this.missingMods = missingMods;
        return this;
    }

    public final List<Tuple<BlockPos, NBTTagCompound>> getEntitiesAsList() {
        ArrayList<Tuple<BlockPos, NBTTagCompound>> list = new ArrayList<Tuple<BlockPos, NBTTagCompound>>();
        for (short x = 0; x < this.sizeX; x = (short)(x + 1)) {
            for (short y = 0; y < this.sizeY; y = (short)(y + 1)) {
                for (short z = 0; z < this.sizeZ; z = (short)(z + 1)) {
                    list.add((Tuple<BlockPos, NBTTagCompound>)new Tuple((Object)new BlockPos((int)x, (int)y, (int)z), (Object)this.entities[y][z][x]));
                }
            }
        }
        return list;
    }

    public final List<BlockInfo> getBlockInfoAsList() {
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>();
        for (short x = 0; x < this.sizeX; x = (short)(x + 1)) {
            for (short y = 0; y < this.sizeY; y = (short)(y + 1)) {
                for (short z = 0; z < this.sizeZ; z = (short)(z + 1)) {
                    BlockPos tempPos = new BlockPos((int)x, (int)y, (int)z);
                    short value = this.structure[y][z][x];
                    IBlockState state = this.palette.get(value & 0xFFFF);
                    list.add(new BlockInfo(tempPos, state, this.tileEntities[y][z][x]));
                }
            }
        }
        return list;
    }

    public BlockPos rotateWithMirror(Rotation rotation, BlockPos pos, Mirror mirror) {
        BlockPos resultSize = Blueprint.transformedSize(new BlockPos((int)this.sizeX, (int)this.sizeY, (int)this.sizeZ), rotation);
        short newSizeX = (short)resultSize.func_177958_n();
        short newSizeY = (short)resultSize.func_177956_o();
        short newSizeZ = (short)resultSize.func_177952_p();
        short[][][] newStructure = new short[newSizeY][newSizeZ][newSizeX];
        NBTTagCompound[][][] newEntities = new NBTTagCompound[newSizeY][newSizeZ][newSizeX];
        NBTTagCompound[][][] newTileEntities = new NBTTagCompound[newSizeY][newSizeZ][newSizeX];
        ArrayList<IBlockState> palette = new ArrayList<IBlockState>();
        for (int i = 0; i < this.palette.size(); ++i) {
            palette.add(i, this.palette.get(i).func_185902_a(mirror).func_185907_a(rotation));
        }
        BlockPos extremes = Blueprint.transformedBlockPos(this.sizeX, this.sizeY, this.sizeZ, mirror, rotation);
        int minX = extremes.func_177958_n() < 0 ? -extremes.func_177958_n() - 1 : 0;
        int minY = extremes.func_177956_o() < 0 ? -extremes.func_177956_o() - 1 : 0;
        int minZ = extremes.func_177952_p() < 0 ? -extremes.func_177952_p() - 1 : 0;
        this.palette = palette;
        boolean foundAnchor = false;
        BlockPos offset = pos;
        for (short x = 0; x < this.sizeX; x = (short)(x + 1)) {
            for (short y = 0; y < this.sizeY; y = (short)(y + 1)) {
                for (short z = 0; z < this.sizeZ; z = (short)(z + 1)) {
                    BlockPos tempPos = Blueprint.transformedBlockPos(x, y, z, mirror, rotation).func_177982_a(minX, minY, minZ);
                    short value = this.structure[y][z][x];
                    IBlockState state = (IBlockState)palette.get(value & 0xFFFF);
                    if (state.func_177230_c() == Blocks.field_189881_dj) continue;
                    if (state.func_177230_c() instanceof IAnchorBlock) {
                        offset = tempPos;
                        foundAnchor = true;
                    }
                    newStructure[tempPos.func_177956_o()][tempPos.func_177952_p()][tempPos.func_177958_n()] = value;
                    NBTTagCompound compound = this.tileEntities[y][z][x];
                    if (compound != null) {
                        compound.func_74768_a("x", tempPos.func_177958_n());
                        compound.func_74768_a("y", tempPos.func_177956_o());
                        compound.func_74768_a("z", tempPos.func_177952_p());
                    }
                    newTileEntities[tempPos.func_177956_o()][tempPos.func_177952_p()][tempPos.func_177958_n()] = compound;
                    NBTTagCompound entitiesCompound = this.entities[y][z][x];
                    if (compound != null) {
                        compound.func_74768_a("x", tempPos.func_177958_n());
                        compound.func_74768_a("y", tempPos.func_177956_o());
                        compound.func_74768_a("z", tempPos.func_177952_p());
                    }
                    newEntities[tempPos.func_177956_o()][tempPos.func_177952_p()][tempPos.func_177958_n()] = entitiesCompound;
                }
            }
        }
        if (!foundAnchor) {
            BlockPos tempSize = new BlockPos((int)this.sizeX, 0, (int)this.sizeZ);
            if (rotation == Rotation.CLOCKWISE_90) {
                tempSize = new BlockPos((int)(-this.sizeZ), 0, (int)this.sizeX);
            }
            if (rotation == Rotation.CLOCKWISE_180) {
                tempSize = new BlockPos((int)(-this.sizeX), 0, (int)(-this.sizeZ));
            }
            if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                tempSize = new BlockPos((int)this.sizeZ, 0, (int)(-this.sizeX));
            }
            offset = new BlockPos(tempSize.func_177958_n() / 2, 0, tempSize.func_177952_p() / 2).func_177982_a(minX, minY, minZ);
        }
        this.sizeX = newSizeX;
        this.sizeY = newSizeY;
        this.sizeZ = newSizeZ;
        this.structure = newStructure;
        this.entities = newEntities;
        this.tileEntities = newTileEntities;
        return offset;
    }

    public static BlockPos transformedSize(BlockPos pos, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
        }
        return pos;
    }

    public static BlockPos transformedBlockPos(int xIn, int y, int zIn, Mirror mirror, Rotation rotation) {
        int x = xIn;
        int z = zIn;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -zIn;
                break;
            }
            case FRONT_BACK: {
                x = -xIn;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(z, y, -x);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-z, y, x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-x, y, -z);
            }
        }
        return flag ? new BlockPos(x, y, z) : new BlockPos(xIn, y, zIn);
    }
}

