/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.kjlib.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class ProgressBar
extends Gui {
    private ResourceLocation texture;
    private ProgressBarDirection direction;
    private int positionX;
    private int positionY;
    private int width;
    private int height;
    private int textureX;
    private int textureY;
    private float min;
    private float max = 0.0f;

    public ProgressBar(ResourceLocation texture, ProgressBarDirection direction, int width, int height, int positonX, int positionY, int textureX, int textureY) {
        this.texture = texture;
        this.direction = direction;
        this.width = width;
        this.height = height;
        this.positionX = positonX;
        this.positionY = positionY;
        this.textureX = textureX;
        this.textureY = textureY;
    }

    public ProgressBar setMin(int min) {
        this.min = min;
        return this;
    }

    public ProgressBar setMax(int max) {
        this.max = max;
        return this;
    }

    private int getAdjustedWidth() {
        return (int)(this.min != 0.0f && this.max != 0.0f ? this.min / this.max * (float)this.width : 0.0f);
    }

    private int getAdjustedHeight() {
        return (int)(this.min != 0.0f && this.max != 0.0f ? this.min / this.max * (float)this.height : 0.0f);
    }

    public void draw(Minecraft mc) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(this.texture);
        switch (this.direction) {
            case DIAGONAL_UP_LEFT: {
                this.func_73729_b(this.positionX, this.positionY, this.textureX, this.textureY, this.width, this.height);
                this.func_73729_b(this.positionX, this.positionY, this.positionX, this.positionY, this.width - this.getAdjustedWidth(), this.height - this.getAdjustedHeight());
                break;
            }
            case DIAGONAL_UP_RIGHT: {
                this.func_73729_b(this.positionX, this.positionY, this.textureX, this.textureY, this.width, this.height);
                this.func_73729_b(this.positionX + this.getAdjustedWidth(), this.positionY, this.positionX + this.getAdjustedWidth(), this.positionY, this.width - this.getAdjustedWidth(), this.height - this.getAdjustedHeight());
                break;
            }
            case DIAGONAL_DOWN_LEFT: {
                this.func_73729_b(this.positionX, this.positionY, this.textureX, this.textureY, this.width, this.height);
                this.func_73729_b(this.positionX, this.positionY + this.getAdjustedHeight(), this.positionX, this.positionY + this.getAdjustedHeight(), this.width - this.getAdjustedWidth(), this.height - this.getAdjustedHeight());
                break;
            }
            case DIAGONAL_DOWN_RIGHT: {
                this.func_73729_b(this.positionX, this.positionY, this.textureX, this.textureY, this.getAdjustedWidth(), this.getAdjustedHeight());
                break;
            }
            case DOWN_TO_UP: {
                this.func_73729_b(this.positionX, this.positionY, this.textureX, this.textureY, this.width, this.height);
                this.func_73729_b(this.positionX, this.positionY, this.positionX, this.positionY, this.width, this.height - this.getAdjustedHeight());
                break;
            }
            case LEFT_TO_RIGHT: {
                this.func_73729_b(this.positionX, this.positionY, this.textureX, this.textureY, this.getAdjustedWidth(), this.height);
                break;
            }
            case RIGHT_TO_LEFT: {
                this.func_73729_b(this.positionX, this.positionY, this.textureX, this.textureY, this.width, this.height);
                this.func_73729_b(this.positionX, this.positionY, this.positionX, this.positionY, this.width - this.getAdjustedWidth(), this.height);
                break;
            }
            case UP_TO_DOWN: {
                this.func_73729_b(this.positionX, this.positionY, this.textureX, this.textureY, this.width, this.getAdjustedHeight());
                break;
            }
            default: {
                this.func_73729_b(this.positionX, this.positionY, this.textureX, this.textureY, this.width, this.height);
            }
        }
    }

    public static enum ProgressBarDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT,
        UP_TO_DOWN,
        DOWN_TO_UP,
        DIAGONAL_UP_RIGHT,
        DIAGONAL_UP_LEFT,
        DIAGONAL_DOWN_RIGHT,
        DIAGONAL_DOWN_LEFT;

    }
}

