/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forestry.api.recipes.IFermenterRecipe;
import forestry.factory.recipes.FermenterRecipeManager;
import java.util.IdentityHashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackOredictionary;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler.CraftingProviderRecipeHandlerAdapter;

public class TileFermenterRecipeHandler
extends CraftingProviderRecipeHandlerAdapter<IFermenterRecipe> {
    public TileFermenterRecipeHandler() {
        super(new FermenterRecipeManager(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK, IngredientComponent.FLUIDSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.FLUIDSTACK}));
    }

    @Override
    protected IRecipeDefinition transformRecipe(IFermenterRecipe recipe) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        if (recipe.getResourceOreName() == null) {
            inputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, recipe.getResource(), 15)}))}));
        } else {
            inputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesItemStackOredictionary(Lists.newArrayList((Object[])new String[]{recipe.getResourceOreName()}), 15)}));
        }
        inputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, new FluidStack(recipe.getFluidResource(), recipe.getFermentationValue()), 7)}))}));
        outputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{new FluidStack(recipe.getOutput(), (int)(recipe.getModifier() * (float)recipe.getFermentationValue()))}));
        return new RecipeDefinition(inputs, new MixedIngredients(outputs));
    }

    @Override
    protected IFermenterRecipe findRecipe(IMixedIngredients input) {
        return FermenterRecipeManager.findMatchingRecipe((ItemStack)((ItemStack)Iterables.getFirst(input.getInstances(IngredientComponent.ITEMSTACK), (Object)ItemStack.field_190927_a)), (FluidStack)((FluidStack)Iterables.getFirst(input.getInstances(IngredientComponent.FLUIDSTACK), null)));
    }

    @Override
    public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
        return component == IngredientComponent.FLUIDSTACK && size == 1 || component == IngredientComponent.ITEMSTACK && size <= 1;
    }
}

