/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.NewConfigRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.helpers.RFCAdvancements;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.utils.DurabilityUtils;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import com.bafomdad.realfilingcabinet.utils.OreDictUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageUtils {
    public static int simpleFolderMatch(TileEntityRFC tile, ItemStack stack) {
        if (stack.func_190926_b()) {
            return -1;
        }
        for (int i = 0; i < tile.getInventory().getSlots(); ++i) {
            ItemStack folder;
            ItemStack loopinv = tile.getInventory().getStackFromFolder(i);
            if (loopinv.func_190926_b()) continue;
            if (UpgradeHelper.getUpgrade(tile, StringLibs.TAG_OREDICT) != null) {
                OreDictUtils.recreateOreDictionary(stack);
                if (OreDictUtils.hasOreDict() && OreDictUtils.areItemsEqual(stack, loopinv)) {
                    return i;
                }
            }
            if ((folder = tile.getInventory().getTrueStackInSlot(i)).func_77973_b() == RFCItems.folder && folder.func_77952_i() == ItemFolder.FolderType.NBT.ordinal()) {
                if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)loopinv)) continue;
                return i;
            }
            if (!StorageUtils.simpleMatch(stack, loopinv)) continue;
            if (folder.func_77973_b() == RFCItems.dyedFolder && ItemFolder.getFileSize(folder) < (long)NewConfigRFC.ConfigRFC.folderSizeLimit) {
                return i;
            }
            if (folder.func_77973_b() != RFCItems.folder) continue;
            return i;
        }
        return -1;
    }

    public static void addStackManually(TileEntityRFC tile, EntityPlayer player, ItemStack stack) {
        FluidStack fluid;
        if (tile.func_145831_w().field_72995_K) {
            return;
        }
        if (UpgradeHelper.getUpgrade(tile, StringLibs.TAG_FLUID) != null && (fluid = FluidUtil.getFluidContained((ItemStack)stack)) != null) {
            FluidActionResult far = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)tile.getFluidInventory(), (int)fluid.amount, (EntityPlayer)player, (boolean)true);
            if (far.success && !player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(EnumHand.MAIN_HAND, far.getResult());
            }
            return;
        }
        for (int i = 0; i < tile.getInventory().getSlots(); ++i) {
            ItemStack toInsert;
            ItemStack loopinv = tile.getInventory().getStackFromFolder(i);
            ItemStack folder = tile.getInventory().getTrueStackInSlot(i);
            if (UpgradeHelper.getUpgrade(tile, StringLibs.TAG_OREDICT) != null) {
                OreDictUtils.recreateOreDictionary(stack);
                if (OreDictUtils.hasOreDict() && !loopinv.func_190926_b() && OreDictUtils.areItemsEqual(stack, loopinv)) {
                    toInsert = ItemFolder.insert(folder, stack, false);
                    player.func_184611_a(EnumHand.MAIN_HAND, toInsert);
                    if (toInsert.func_190926_b()) break;
                    if (player instanceof EntityPlayerMP && folder.func_77973_b() == RFCItems.dyedFolder && ItemFolder.getFileSize(folder) >= (long)NewConfigRFC.ConfigRFC.folderSizeLimit) {
                        RFCAdvancements.advance((EntityPlayerMP)player, new ResourceLocation("realfilingcabinet", "main/limit_reach"), "code_triggered");
                    }
                }
            }
            if (!folder.func_190926_b()) {
                if (folder.func_77973_b() == RFCItems.folder && folder.func_77952_i() == ItemFolder.FolderType.DURA.ordinal()) {
                    if (!DurabilityUtils.matchDurability(tile, stack)) continue;
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    tile.markBlockForUpdate();
                    break;
                }
                if (folder.func_77973_b() == RFCItems.folder && folder.func_77952_i() == ItemFolder.FolderType.NBT.ordinal()) {
                    if (!ItemStack.func_77970_a((ItemStack)loopinv, (ItemStack)stack)) continue;
                    toInsert = ItemFolder.insert(tile.getInventory().getTrueStackInSlot(i), stack, false);
                    player.func_184611_a(EnumHand.MAIN_HAND, toInsert);
                    break;
                }
            }
            if (!StorageUtils.simpleMatch(loopinv, stack)) continue;
            toInsert = ItemFolder.insert(folder, stack, false);
            player.func_184611_a(EnumHand.MAIN_HAND, toInsert);
            if (toInsert.func_190926_b()) break;
            if (!(player instanceof EntityPlayerMP) || folder.func_77973_b() != RFCItems.dyedFolder || ItemFolder.getFileSize(folder) < (long)NewConfigRFC.ConfigRFC.folderSizeLimit) continue;
            RFCAdvancements.advance((EntityPlayerMP)player, new ResourceLocation("realfilingcabinet", "main/limit_reach"), "code_triggered");
        }
        tile.markBlockForUpdate();
    }

    public static void addAllStacksManually(TileEntityRFC tile, EntityPlayer player) {
        if (tile.func_145831_w().field_72995_K) {
            return;
        }
        boolean consume = false;
        block0: for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            FluidStack fluid;
            ItemStack loopinv = player.field_71071_by.func_70301_a(i);
            if (loopinv.func_190926_b() || loopinv.func_77973_b() == RFCItems.emptyFolder && loopinv.func_77973_b() == RFCItems.folder) continue;
            if (UpgradeHelper.getUpgrade(tile, StringLibs.TAG_FLUID) != null && (fluid = FluidUtil.getFluidContained((ItemStack)loopinv)) != null) {
                FluidActionResult far = FluidUtil.tryEmptyContainer((ItemStack)loopinv, (IFluidHandler)tile.getFluidInventory(), (int)fluid.amount, (EntityPlayer)player, (boolean)true);
                if (far.success) {
                    loopinv.func_190918_g(1);
                    player.field_71071_by.func_70441_a(far.getResult());
                }
                if (!consume) {
                    consume = true;
                }
            }
            for (int j = 0; j < tile.getInventory().getSlots(); ++j) {
                ItemStack tilestack = tile.getInventory().getTrueStackInSlot(j);
                if (tilestack.func_190926_b() || !(ItemFolder.getObject(tilestack) instanceof ItemStack)) continue;
                ItemStack folderstack = tile.getInventory().getStackFromFolder(j);
                if (!tilestack.func_190926_b() && tilestack.func_77973_b() == RFCItems.folder && tilestack.func_77952_i() == ItemFolder.FolderType.DURA.ordinal() && DurabilityUtils.matchDurability(tile, loopinv)) {
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                    consume = true;
                    continue block0;
                }
                if (!tilestack.func_190926_b() && tilestack.func_77973_b() == RFCItems.folder && tilestack.func_77952_i() == ItemFolder.FolderType.NBT.ordinal()) {
                    if (!ItemStack.func_77970_a((ItemStack)loopinv, (ItemStack)folderstack)) continue;
                    player.field_71071_by.func_70299_a(i, ItemFolder.insert(tilestack, loopinv, false));
                    consume = true;
                    continue block0;
                }
                if (!StorageUtils.simpleMatch(folderstack, loopinv)) continue;
                player.field_71071_by.func_70299_a(i, ItemFolder.insert(tilestack, loopinv, false));
                if (player instanceof EntityPlayerMP && tilestack.func_77973_b() == RFCItems.dyedFolder && ItemFolder.getFileSize(tilestack) >= (long)NewConfigRFC.ConfigRFC.folderSizeLimit) {
                    RFCAdvancements.advance((EntityPlayerMP)player, new ResourceLocation("realfilingcabinet", "limit_reach"), "code_triggered");
                }
                if (!loopinv.func_190926_b()) continue;
                consume = true;
                continue block0;
            }
        }
        if (consume) {
            StorageUtils.updatePlayerInventory(player);
            tile.func_70296_d();
        }
    }

    public static void extractStackManually(TileEntityRFC tile, EntityPlayer player, boolean crouching) {
        ItemStack stack = tile.getFilter();
        if (!stack.func_190926_b()) {
            for (int i = 0; i < tile.getInventory().getSlots(); ++i) {
                long count;
                ItemStack folder;
                ItemStack loopinv = tile.getInventory().getStackFromFolder(i);
                if (UpgradeHelper.getUpgrade(tile, StringLibs.TAG_FLUID) != null) {
                    ItemStack container = player.func_184614_ca();
                    if (!container.func_190926_b() && container.func_77973_b() == Items.field_151133_ar) {
                        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
                        if (fluid != null) {
                            FluidActionResult far = FluidUtil.tryFillContainer((ItemStack)container, (IFluidHandler)tile.getFluidInventory(), (int)1000, (EntityPlayer)player, (boolean)true);
                            if (far.success) {
                                container.func_190918_g(1);
                                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)far.getResult());
                            }
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (UpgradeHelper.getUpgrade(tile, StringLibs.TAG_OREDICT) != null) {
                    OreDictUtils.recreateOreDictionary(stack);
                    if (OreDictUtils.hasOreDict() && !loopinv.func_190926_b() && OreDictUtils.areItemsEqual(stack, loopinv)) {
                        folder = tile.getInventory().getTrueStackInSlot(i);
                        long count2 = ItemFolder.getFileSize(folder);
                        if (count2 == 0L) continue;
                        if (crouching) {
                            long extract = Math.min((long)stack.func_77976_d(), count2);
                            ItemStack stackExtract = new ItemStack(stack.func_77973_b(), (int)extract, stack.func_77952_i());
                            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackExtract);
                            if (!UpgradeHelper.isCreative(tile)) {
                                ItemFolder.remove(folder, extract);
                            }
                            tile.markBlockForUpdate();
                            break;
                        }
                        ItemStack stackExtract = new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i());
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackExtract);
                        if (!UpgradeHelper.isCreative(tile)) {
                            ItemFolder.remove(folder, 1L);
                        }
                        tile.markBlockForUpdate();
                        break;
                    }
                }
                if (loopinv.func_190926_b() || !StorageUtils.simpleMatch(loopinv, stack) || (count = ItemFolder.getFileSize(folder = tile.getInventory().getTrueStackInSlot(i))) == 0L) continue;
                if (folder.func_77952_i() == 5 && ItemStack.func_77970_a((ItemStack)loopinv, (ItemStack)stack)) {
                    player.field_71071_by.func_70441_a(stack.func_77946_l());
                    if (!UpgradeHelper.isCreative(tile)) {
                        ItemFolder.remove(folder, 1L);
                    }
                    tile.markBlockForUpdate();
                    break;
                }
                if (crouching) {
                    long extract = Math.min((long)stack.func_77976_d(), count);
                    ItemStack stackExtract = new ItemStack(stack.func_77973_b(), (int)extract, stack.func_77952_i());
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackExtract);
                    if (!UpgradeHelper.isCreative(tile)) {
                        ItemFolder.remove(folder, extract);
                    }
                    tile.markBlockForUpdate();
                    break;
                }
                ItemStack stackExtract = new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i());
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackExtract);
                if (!UpgradeHelper.isCreative(tile)) {
                    ItemFolder.remove(folder, 1L);
                }
                tile.markBlockForUpdate();
                break;
            }
        }
    }

    public static boolean simpleMatch(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i();
    }

    public static void updatePlayerInventory(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
        }
    }

    public static void checkTapeNBT(ItemStack stack, boolean setTaped) {
        if (stack.func_77952_i() == 1) {
            return;
        }
        NBTUtils.setBoolean(stack, StringLibs.RFC_TAPED, setTaped);
    }

    public static void folderExtract(TileEntityRFC tile, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (int i = tile.getInventory().getSlots() - 1; i >= 0; --i) {
            ItemStack folder = tile.getInventory().getTrueStackInSlot(i);
            if (folder.func_190926_b()) continue;
            tile.getInventory().setStackInSlot(i, ItemStack.field_190927_a);
            player.func_184611_a(EnumHand.MAIN_HAND, folder);
            tile.markBlockForUpdate();
            break;
        }
    }
}

