/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.RealFilingCabinet;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.integration.CraftTweakerRFC;
import com.bafomdad.realfilingcabinet.inventory.InventoryRFC;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.network.VanillaPacketDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AutocraftingUtils {
    private static int outputSize;

    private static IRecipe getRecipeFor(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (IRecipe recipe : CraftingManager.field_193380_a) {
                if (RealFilingCabinet.crtLoaded && (recipe = CraftTweakerRFC.getTweakedRecipe(stack)) != null) {
                    return recipe;
                }
                if (!(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe) && !(recipe instanceof ShapelessRecipes) && !(recipe instanceof ShapelessOreRecipe) || recipe.func_77571_b().func_77973_b() != stack.func_77973_b() || recipe.func_77571_b().func_77981_g() && recipe.func_77571_b().func_77952_i() != stack.func_77952_i()) continue;
                return recipe;
            }
        }
        return null;
    }

    private static IItemHandler getFakeInv(TileEntityRFC tile) {
        ItemStackHandler tempInv = new ItemStackHandler(tile.getInventory().getSlots());
        for (int i = 0; i < tile.getInventory().getSlots(); ++i) {
            ItemStack stack = tile.getInventory().getTrueStackInSlot(i);
            if (stack == ItemStack.field_190927_a) continue;
            tempInv.setStackInSlot(i, tile.getInventory().getTrueStackInSlot(i).func_77946_l());
        }
        return tempInv;
    }

    public static int getOutputSize() {
        return outputSize;
    }

    public static boolean canCraft(ItemStack input, TileEntityRFC tile) {
        if (AutocraftingUtils.isUncraftable(input, tile)) {
            return false;
        }
        IRecipe recipe = AutocraftingUtils.getRecipeFor(input);
        if (recipe == null) {
            AutocraftingUtils.setUncraftableItem(input, tile);
            return false;
        }
        return AutocraftingUtils.consumeRecipeIngredients(recipe, AutocraftingUtils.getFakeInv(tile));
    }

    public static void doCraft(ItemStack input, IItemHandler inv) {
        IRecipe recipe = AutocraftingUtils.getRecipeFor(input);
        AutocraftingUtils.consumeRecipeIngredients(recipe, inv);
    }

    private static void setUncraftableItem(ItemStack stack, TileEntityRFC tile) {
        tile.uncraftableItem = stack;
    }

    private static boolean isUncraftable(ItemStack stack, TileEntityRFC tile) {
        return stack.func_190926_b() || ItemStack.func_185132_d((ItemStack)stack, (ItemStack)tile.uncraftableItem);
    }

    public static boolean consumeRecipeIngredients(IRecipe recipe, IItemHandler inv) {
        NonNullList ingredients = recipe.func_192400_c();
        for (int i = 0; i < ingredients.size(); ++i) {
            boolean flag;
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            boolean bl = flag = ingredient.func_193365_a().length > 0;
            if (!flag) continue;
            ItemStack stack = ingredient.func_193365_a()[0];
            if (stack.func_190926_b()) {
                return false;
            }
            if (stack.func_190916_E() > 1) {
                stack.func_190920_e(1);
            }
            if (stack.func_77952_i() == -1 || stack.func_77952_i() == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
            if (AutocraftingUtils.consumeFromInventory(stack, inv)) continue;
            return false;
        }
        outputSize = recipe.func_77571_b().func_190916_E();
        if (inv instanceof InventoryRFC) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(((InventoryRFC)inv).getTile());
        }
        return true;
    }

    public static boolean consumeFromInventory(ItemStack stack, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack folder = inv.getStackInSlot(i);
            if (inv instanceof InventoryRFC) {
                folder = ((InventoryRFC)inv).getTrueStackInSlot(i);
            }
            if (folder.func_190926_b() || folder.func_77973_b() != RFCItems.folder || !(ItemFolder.getObject(folder) instanceof ItemStack) || ItemFolder.getObject(folder) == null || !stack.func_77969_a((ItemStack)ItemFolder.getObject(folder)) || ItemFolder.getFileSize(folder) <= 0L) continue;
            boolean consume = true;
            ItemStack container = ((ItemStack)ItemFolder.getObject(folder)).func_77973_b().getContainerItem((ItemStack)ItemFolder.getObject(folder));
            if (container != ItemStack.field_190927_a && inv instanceof InventoryRFC) {
                if (container == (ItemStack)ItemFolder.getObject(folder)) {
                    consume = false;
                }
                if (consume && !AutocraftingUtils.shuntContainerItem(container, inv)) {
                    AutocraftingUtils.shuntContainerItemOutside(container, inv);
                }
            }
            if (consume) {
                ItemFolder.remove(folder, 1L);
                if (ItemFolder.getFileSize(folder) < 0L) {
                    consume = false;
                }
            }
            return consume;
        }
        return false;
    }

    private static boolean shuntContainerItem(ItemStack container, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack folder = ((InventoryRFC)inv).getTrueStackInSlot(i);
            if (folder.func_190926_b() || folder.func_77973_b() != RFCItems.folder || ItemFolder.getObject(folder) == null || !container.func_77969_a((ItemStack)ItemFolder.getObject(folder))) continue;
            ItemFolder.add(folder, 1L);
            return true;
        }
        return false;
    }

    private static void shuntContainerItemOutside(ItemStack container, IItemHandler inv) {
        TileEntityRFC tile = ((InventoryRFC)inv).getTile();
        EntityItem ei = new EntityItem(tile.func_145831_w(), (double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 1.5, (double)tile.func_174877_v().func_177952_p() + 0.5, container);
        tile.func_145831_w().func_72838_d((Entity)ei);
    }
}

