/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items.capabilities;

import com.bafomdad.realfilingcabinet.NewConfigRFC;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.helpers.TextHelper;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.lwjgl.input.Keyboard;

public class CapabilityFolder
implements INBTSerializable<NBTTagCompound> {
    private final ItemStack rootStack;
    private String displayName = "";
    private Object contents;
    private long count = 0L;
    private int remSize = 0;

    public CapabilityFolder(ItemStack rootStack) {
        this.rootStack = rootStack;
    }

    public void addTooltips(World world, List<String> list, ITooltipFlag tooltipFlag) {
        if (this.rootStack.func_77973_b() == RFCItems.dyedFolder) {
            ItemStack item = this.getItemStack();
            list.add(Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? this.count + " " + item.func_82833_r() : TextHelper.format(this.count) + " " + item.func_82833_r());
            return;
        }
        if (this.rootStack.func_77952_i() == ItemFolder.FolderType.FLUID.ordinal() && this.isFluidStack()) {
            FluidStack fluid = this.getFluidStack();
            list.add(this.count + "mb " + fluid.getLocalizedName());
            list.add(NBTUtils.getBoolean(this.rootStack, StringLibs.RFC_PLACEMODE, false) ? TextFormatting.GREEN + TextHelper.localize("tooltip.realfilingcabinet.placemode.on") : TextFormatting.RED + TextHelper.localize("tooltip.realfilingcabinet.placemode.off"));
        } else if (this.rootStack.func_77952_i() == ItemFolder.FolderType.MOB.ordinal() && this.isEntity()) {
            list.add(this.count + " " + this.displayName);
            if (!NewConfigRFC.ConfigRFC.mobUpgrade) {
                list.add(TextHelper.localize("message.realfilingcabinet.disabled"));
            }
        } else if (this.isItemStack()) {
            ItemStack item = this.getItemStack();
            list.add(Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? this.count + " " + item.func_82833_r() : TextHelper.format(this.count) + " " + item.func_82833_r());
            if (this.rootStack.func_77952_i() == ItemFolder.FolderType.DURA.ordinal()) {
                list.add("Durability: " + this.remSize + " / " + item.func_77958_k());
                list.add(NBTUtils.getBoolean(this.rootStack, StringLibs.RFC_IGNORENBT, false) ? TextFormatting.GREEN + TextHelper.localize("tooltip.realfilingcabinet.ignorenbt.true") : TextFormatting.RED + TextHelper.localize("tooltip.realfilingcabinet.ignorenbt.false"));
            }
        }
    }

    public ItemStack extractItems(long amount, boolean sim) {
        if (!this.isItemStack() || this.count <= 0L) {
            return ItemStack.field_190927_a;
        }
        ItemStack items = this.getItemStack().func_77946_l();
        items.func_190920_e((int)Math.min(this.count, (long)items.func_77976_d()));
        if (!sim) {
            this.count -= (long)items.func_190916_E();
        }
        return items;
    }

    public ItemStack insertItems(ItemStack items, boolean sim) {
        ItemStack stack = this.getItemStack();
        if (this.rootStack.func_77973_b() == RFCItems.folder && this.rootStack.func_77952_i() == ItemFolder.FolderType.DURA.ordinal()) {
            return items;
        }
        if (this.rootStack.func_77973_b() == RFCItems.dyedFolder) {
            long newCount = Math.min(this.count + (long)items.func_190916_E(), (long)NewConfigRFC.ConfigRFC.folderSizeLimit);
            long remainder = (long)NewConfigRFC.ConfigRFC.folderSizeLimit - this.count;
            items.func_190920_e(items.func_190916_E() - (int)remainder);
            if (!sim) {
                this.count = newCount;
            }
            return items;
        }
        if (!sim) {
            this.count += (long)items.func_190916_E();
            items.func_190920_e(0);
        }
        return ItemStack.field_190927_a;
    }

    public boolean setContents(Object obj) {
        if (obj instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)obj;
            if (entity instanceof EntityPlayer || entity instanceof IEntityOwnable && ((IEntityOwnable)entity).func_184753_b() != null || !entity.func_184222_aU() || !(entity instanceof EntityZombie) && entity.func_70631_g_()) {
                return false;
            }
            this.displayName = EntityRegistry.getEntry(entity.getClass()).getName();
            this.contents = entity.getClass();
            this.count = 1L;
            return true;
        }
        if (obj instanceof ItemStack) {
            ItemStack stack = ((ItemStack)obj).func_77946_l();
            this.displayName = stack.func_82833_r();
            this.contents = stack.func_77946_l();
            this.count = 1L;
            stack.func_190920_e(1);
            if (this.rootStack.func_77973_b() == RFCItems.dyedFolder) {
                return true;
            }
            if (this.rootStack.func_77952_i() == ItemFolder.FolderType.DURA.ordinal()) {
                this.remSize = stack.func_77952_i();
            }
            if (this.rootStack.func_77952_i() != ItemFolder.FolderType.NBT.ordinal()) {
                stack.func_77982_d(null);
            }
            return true;
        }
        if (obj instanceof FluidStack) {
            this.displayName = ((FluidStack)obj).getLocalizedName();
            this.contents = ((FluidStack)obj).copy();
            this.count = ((FluidStack)obj).amount;
            return true;
        }
        if (obj instanceof IBlockState) {
            this.displayName = ((IBlockState)obj).func_177230_c().func_149732_F();
            this.contents = obj;
            this.count = 1L;
            return true;
        }
        if (obj == null) {
            this.displayName = "";
            this.contents = null;
            this.count = 0L;
            this.remSize = 0;
            return true;
        }
        return false;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Object getContents() {
        if (this.rootStack.func_77942_o() && this.rootStack.func_77978_p().func_74764_b("fileName")) {
            this.deserializeNBT(new NBTTagCompound());
        }
        if (this.isItemStack()) {
            ItemStack item = this.getItemStack().func_77946_l();
            item.func_190920_e(1);
        } else if (this.isFluidStack()) {
            return this.getFluidStack().copy();
        }
        return this.contents;
    }

    public boolean isItemStack() {
        return this.contents instanceof ItemStack;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long value) {
        this.count = value;
    }

    public int getRemaining() {
        return this.remSize;
    }

    public void setRemaining(int value) {
        this.remSize = value;
    }

    public ItemStack getItemStack() {
        return this.isItemStack() ? (ItemStack)this.contents : ItemStack.field_190927_a;
    }

    public boolean isFluidStack() {
        return this.contents instanceof FluidStack;
    }

    public FluidStack getFluidStack() {
        return this.isFluidStack() ? (FluidStack)this.contents : null;
    }

    public boolean isBlock() {
        return this.contents instanceof IBlockState;
    }

    public IBlockState getBlock() {
        return this.isBlock() ? (IBlockState)this.contents : Blocks.field_150350_a.func_176223_P();
    }

    public boolean isEntity() {
        return this.contents instanceof Class && EntityLivingBase.class.isAssignableFrom((Class)this.contents);
    }

    public Class<EntityLivingBase> getEntityClass() {
        return this.isEntity() ? (Class)this.contents : null;
    }

    public EntityLivingBase getEntity(World world) {
        return this.isEntity() ? (EntityLivingBase)EntityList.func_191304_a((Class)((Class)this.contents), (World)world) : null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.getContents() == null) {
            nbt.func_74774_a("folderType", (byte)0);
        } else if (this.isItemStack()) {
            ItemStack item = this.getItemStack();
            nbt.func_74774_a("folderType", (byte)1);
            nbt.func_74782_a("objectData", (NBTBase)item.func_77955_b(new NBTTagCompound()));
        } else if (this.isBlock()) {
            IBlockState blockState = this.getBlock();
            nbt.func_74774_a("folderType", (byte)2);
            NBTTagCompound dataTag = new NBTTagCompound();
            dataTag.func_74778_a("blockId", blockState.func_177230_c().getRegistryName().toString());
            dataTag.func_74768_a("blockMeta", blockState.func_177230_c().func_176201_c(blockState));
            nbt.func_74782_a("objectData", (NBTBase)dataTag);
        } else if (this.isFluidStack()) {
            FluidStack fluid = this.getFluidStack();
            nbt.func_74774_a("folderType", (byte)3);
            nbt.func_74782_a("objectData", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
        } else if (this.isEntity()) {
            nbt.func_74774_a("folderType", (byte)4);
            nbt.func_74778_a("objectData", EntityList.func_191306_a((Class)((Class)this.contents)).toString());
        }
        nbt.func_74772_a("folderSize", this.count);
        nbt.func_74768_a("folderRem", this.remSize);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (this.rootStack.func_77942_o() && this.rootStack.func_77978_p().func_74764_b("fileName")) {
            Class entity;
            NBTTagCompound rootTag = this.rootStack.func_77978_p();
            String fName = rootTag.func_74779_i("fileName");
            int fMeta = rootTag.func_74762_e("fileMeta");
            this.count = rootTag.func_74763_f("fileSize");
            this.remSize = rootTag.func_74762_e("leftoverSize");
            NBTTagCompound tags = rootTag.func_74775_l("itemTagCompound");
            rootTag.func_82580_o("fileName");
            rootTag.func_82580_o("fileMeta");
            rootTag.func_82580_o("fileSize");
            rootTag.func_82580_o("leftoverSize");
            rootTag.func_82580_o("itemTagCompound");
            this.displayName = fName;
            if (this.rootStack.func_77952_i() == ItemFolder.FolderType.FLUID.ordinal()) {
                Fluid fluid = FluidRegistry.getFluid((String)fName);
                if (fluid != null) {
                    this.contents = new FluidStack(fluid, 1);
                } else {
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(fName));
                    if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                        this.contents = new FluidStack(FluidRegistry.WATER, 1);
                    } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                        this.contents = new FluidStack(FluidRegistry.LAVA, 1);
                    }
                }
                return;
            }
            Item item = Item.func_111206_d((String)fName);
            if (item != null && item != Items.field_190931_a) {
                this.contents = new ItemStack(item, 1, fMeta);
                if (!tags.func_82582_d()) {
                    ((ItemStack)this.contents).func_77982_d(tags);
                }
                return;
            }
            Block block = Block.func_149684_b((String)fName);
            if (block != null && block != Blocks.field_150350_a) {
                this.contents = block.func_176203_a(fMeta);
            }
            if ((entity = EntityList.getClass((ResourceLocation)new ResourceLocation(fName))) != null || EntityLivingBase.class.isAssignableFrom(entity)) {
                this.contents = entity;
            }
            return;
        }
        if (this.rootStack.func_77942_o() && this.rootStack.func_77978_p().func_74764_b("folderCap")) {
            nbt = this.rootStack.func_77978_p().func_74775_l("folderCap");
        }
        byte type = nbt.func_74771_c("folderType");
        switch (type) {
            case 0: {
                this.displayName = "";
                this.contents = null;
                this.count = 0L;
                this.remSize = 0;
                break;
            }
            case 1: {
                this.contents = new ItemStack(nbt.func_74775_l("objectData"));
                ((ItemStack)this.contents).func_190920_e(1);
                this.displayName = ((ItemStack)this.contents).func_82833_r();
                break;
            }
            case 2: {
                NBTTagCompound tags = nbt.func_74775_l("objectData");
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(tags.func_74779_i("blockId")));
                if (block != Blocks.field_150350_a) {
                    this.contents = block.func_176203_a(tags.func_74762_e("blockMeta"));
                    this.displayName = block.func_149732_F();
                    break;
                }
                this.contents = null;
                this.displayName = "";
                break;
            }
            case 3: {
                this.contents = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("objectData"));
                if (this.contents == null) break;
                this.displayName = ((FluidStack)this.contents).getLocalizedName();
                break;
            }
            case 4: {
                this.contents = EntityList.getClass((ResourceLocation)new ResourceLocation(nbt.func_74779_i("objectData")));
                if (this.contents == null) break;
                this.displayName = EntityRegistry.getEntry(this.getEntityClass()).getName();
            }
        }
        this.count = nbt.func_74763_f("folderSize");
        this.remSize = nbt.func_74762_e("folderRem");
    }
}

