/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.inventory;

import com.bafomdad.realfilingcabinet.LogRFC;
import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.network.VanillaPacketDispatcher;
import com.bafomdad.realfilingcabinet.utils.DurabilityUtils;
import com.bafomdad.realfilingcabinet.utils.StorageUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryRFC
extends ItemStackHandler {
    final TileEntityRFC tile;

    public InventoryRFC(TileEntityRFC tile, int size) {
        this.tile = tile;
        this.setSize(size);
    }

    public void copyInv(InventoryRFC inv) {
        for (int i = 0; i < inv.stacks.size(); ++i) {
            this.stacks.set(i, (Object)inv.getTrueStackInSlot(i));
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        LogRFC.debug("Transfer stack: " + stack + " / Stack in slot: " + this.getStackInSlot(slot) + " / True stack in slot: " + this.getTrueStackInSlot(slot) + " / Slot #" + slot + " / Simulating: " + simulate);
        this.validateSlotIndex(slot);
        if (this.tile.isCabinetLocked()) {
            return stack;
        }
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!((ItemStack)this.stacks.get(slot)).func_190926_b() && ((ItemStack)this.stacks.get(slot)).func_77973_b() == RFCItems.folder && ((ItemStack)this.stacks.get(slot)).func_77952_i() == ItemFolder.FolderType.DURA.ordinal() && DurabilityUtils.matchDurability(this.tile, stack, slot, simulate)) {
            if (!simulate) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.tile.func_145831_w(), this.tile.func_174877_v());
            }
            return ItemStack.field_190927_a;
        }
        int slotIndex = StorageUtils.simpleFolderMatch(this.tile, stack);
        if (slotIndex != -1) {
            slot = slotIndex;
            ItemStack toInsert = ItemFolder.insert((ItemStack)this.stacks.get(slot), stack, simulate);
            if (!simulate) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.tile.func_145831_w(), this.tile.func_174877_v());
            }
            return toInsert;
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        LogRFC.debug("Extraction slot: " + slot + " / Extraction amount: " + amount + " / " + simulate);
        if (ItemFolder.getObject((ItemStack)this.stacks.get(slot)) instanceof ItemStack) {
            ItemStack stackFolder = this.getStackFromFolder(slot);
            if (stackFolder.func_190926_b() || this.tile.isCabinetLocked() || UpgradeHelper.getUpgrade(this.tile, StringLibs.TAG_CRAFT) != null) {
                return ItemStack.field_190927_a;
            }
            if (this.tile.hasItemFrame() && this.tile.getFilter().func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (!this.tile.getFilter().func_190926_b()) {
                int i = StorageUtils.simpleFolderMatch(this.tile, this.tile.getFilter());
                if (i != -1 && slot == i) {
                    stackFolder = this.getStackFromFolder(i);
                    long filterCount = ItemFolder.getFileSize(this.getTrueStackInSlot(i));
                    if (filterCount == 0L) {
                        return ItemStack.field_190927_a;
                    }
                    long filterExtract = Math.min((long)stackFolder.func_77976_d(), filterCount);
                    amount = Math.min((int)filterExtract, amount);
                    if (!simulate && !UpgradeHelper.isCreative(this.tile)) {
                        ItemFolder.remove(this.getTrueStackInSlot(i), amount);
                        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.tile.func_145831_w(), this.tile.func_174877_v());
                    }
                    stackFolder.func_190920_e(amount);
                    return stackFolder.func_77946_l();
                }
                return ItemStack.field_190927_a;
            }
            long count = ItemFolder.getFileSize(this.getTrueStackInSlot(slot));
            if (count == 0L) {
                return ItemStack.field_190927_a;
            }
            long extract = Math.min((long)stackFolder.func_77976_d(), count);
            amount = Math.min((int)extract, amount);
            if (!simulate && !UpgradeHelper.isCreative(this.tile)) {
                ItemFolder.remove(this.getTrueStackInSlot(slot), amount);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.tile.func_145831_w(), this.tile.func_174877_v());
            }
            stackFolder.func_190920_e(amount);
            return stackFolder.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.tile != null) {
            this.tile.func_70296_d();
        }
    }

    public ItemStack getTrueStackInSlot(int slot) {
        if (slot >= 0) {
            return (ItemStack)this.stacks.get(slot);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        if (!((ItemStack)this.stacks.get(slot)).func_190926_b() && !(((ItemStack)this.stacks.get(slot)).func_77973_b() instanceof IFolder) || slot == 8) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackFolder = this.getStackFromFolder(slot);
        if (!stackFolder.func_190926_b()) {
            long count = ItemFolder.getFileSize(this.getTrueStackInSlot(slot));
            if (count == 0L) {
                return ItemStack.field_190927_a;
            }
            long extract = Math.min(0x7FFFFFFEL, count);
            stackFolder.func_190920_e((int)extract);
        }
        return stackFolder;
    }

    public ItemStack getStackFromFolder(int slot) {
        ItemStack folder = this.getTrueStackInSlot(slot);
        if (ItemFolder.getObject(folder) == null) {
            return ItemStack.field_190927_a;
        }
        if (!folder.func_190926_b() && folder.func_77973_b() instanceof IFolder) {
            ItemStack bucket;
            ItemStack stack;
            if (ItemFolder.getObject(folder) instanceof ItemStack && !(stack = (ItemStack)ItemFolder.getObject(folder)).func_190926_b()) {
                return stack.func_77946_l();
            }
            if (UpgradeHelper.getUpgrade(this.tile, StringLibs.TAG_FLUID) != null && ItemFolder.getObject(folder) instanceof FluidStack && !(bucket = FluidUtil.getFilledBucket((FluidStack)((FluidStack)ItemFolder.getObject(folder)))).func_190926_b()) {
                return bucket.func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public TileEntityRFC getTile() {
        return this.tile;
    }
}

