/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.integration.storagedrawers;

import com.bafomdad.realfilingcabinet.NewConfigRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer", modid="storageDrawers", striprefs=true)
public class CabinetData
implements IDrawer {
    TileEntityRFC tile;
    int slot;

    public CabinetData(TileEntityRFC tile, int slot) {
        this.tile = tile;
        this.slot = slot;
    }

    public ItemStack getStoredItemPrototype() {
        if (!(ItemFolder.getObject(this.tile.getInventory().getTrueStackInSlot(this.slot)) instanceof ItemStack)) {
            return ItemStack.field_190927_a;
        }
        return this.tile.getInventory().getStackFromFolder(this.slot);
    }

    public IDrawer setStoredItem(ItemStack prototype) {
        return this;
    }

    public int getStoredItemCount() {
        return (int)Math.min(Integer.MAX_VALUE, ItemFolder.getFileSize(this.tile.getInventory().getTrueStackInSlot(this.slot)));
    }

    public void setStoredItemCount(int amount) {
        ItemFolder.setFileSize(this.tile.getInventory().getTrueStackInSlot(this.slot), amount);
    }

    public int getMaxCapacity(ItemStack prototype) {
        return 0;
    }

    public int getRemainingCapacity() {
        long size = ItemFolder.getFileSize(this.tile.getInventory().getTrueStackInSlot(this.slot));
        if (size >= Integer.MAX_VALUE) {
            return 0;
        }
        return Integer.MAX_VALUE - (int)size;
    }

    public boolean canItemBeStored(ItemStack prototype, Predicate<ItemStack> matchPredicate) {
        if (this.tile.getInventory().getTrueStackInSlot(this.slot).func_77973_b() == RFCItems.dyedFolder && ItemFolder.getFileSize(this.tile.getInventory().getTrueStackInSlot(this.slot)) >= (long)NewConfigRFC.ConfigRFC.folderSizeLimit) {
            return false;
        }
        ItemStack toMatch = this.tile.getInventory().getStackFromFolder(this.slot);
        return ItemStack.func_179545_c((ItemStack)toMatch, (ItemStack)prototype);
    }

    public boolean canItemBeExtracted(ItemStack prototype, Predicate<ItemStack> matchPredicate) {
        ItemStack toMatch = this.tile.getInventory().getStackInSlot(this.slot);
        return ItemStack.func_179545_c((ItemStack)toMatch, (ItemStack)prototype);
    }

    public boolean isEmpty() {
        return this.tile.getInventory().getTrueStackInSlot(this.slot).func_190926_b();
    }

    public int adjustStoredItemCount(int amount) {
        if (amount > 0) {
            int insert = Math.min(amount, this.getRemainingCapacity());
            this.setStoredItemCount(this.getStoredItemCount() + insert);
            return amount - insert;
        }
        if (amount < 0) {
            int stored = this.getStoredItemCount();
            int destroy = Math.min(Math.abs(amount), this.getStoredItemCount());
            this.setStoredItemCount(stored - destroy);
            return destroy;
        }
        return 0;
    }
}

