/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.crafting;

import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.utils.EnderUtils;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import com.bafomdad.realfilingcabinet.utils.StorageUtils;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FolderExtractRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private boolean canSync = false;
    private ItemStack foldy = ItemStack.field_190927_a;
    private ItemStack input;
    final String name;

    public FolderExtractRecipe(String name, ItemStack input) {
        this.name = name;
        this.input = input;
        this.setRegistryName(new ResourceLocation("realfilingcabinet", name));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean func_77569_a(InventoryCrafting ic, World world) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.input);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack stack = ic.func_70463_b(j, i);
                if (stack.func_190926_b()) continue;
                boolean flag = false;
                for (ItemStack stack1 : list) {
                    if (stack.func_77973_b() != stack1.func_77973_b()) continue;
                    flag = true;
                    list.remove(stack1);
                    break;
                }
                if (flag) continue;
                return false;
            }
        }
        return list.isEmpty();
    }

    public ItemStack func_77572_b(InventoryCrafting ic) {
        int folder = -1;
        for (int i = 0; i < ic.func_70302_i_(); ++i) {
            ItemStack stack = ic.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            folder = i;
        }
        if (folder >= 0) {
            ItemStack stack = ic.func_70301_a(folder);
            if (stack.func_77973_b() == RFCItems.dyedFolder && ItemFolder.getObject(stack) != null) {
                long count;
                StorageUtils.checkTapeNBT(ic.func_70301_a(folder), false);
                if (ItemFolder.getObject(stack) instanceof ItemStack && (count = ItemFolder.getFileSize(stack)) > 0L) {
                    ItemStack folderStack = (ItemStack)ItemFolder.getObject(stack);
                    int meta = folderStack.func_77952_i();
                    long extract = Math.min((long)folderStack.func_77976_d(), count);
                    return new ItemStack(folderStack.func_77973_b(), (int)extract, meta);
                }
            }
            if (stack.func_77973_b() == RFCItems.folder && ItemFolder.getObject(stack) != null) {
                StorageUtils.checkTapeNBT(ic.func_70301_a(folder), false);
                if (ItemFolder.getObject(stack) instanceof ItemStack) {
                    long count = ItemFolder.getFileSize(stack);
                    if (count > 0L) {
                        ItemStack folderStack = (ItemStack)ItemFolder.getObject(stack);
                        int meta = folderStack.func_77952_i();
                        long extract = Math.min((long)folderStack.func_77976_d(), count);
                        if (stack.func_77952_i() == 1) {
                            this.foldy = stack;
                            this.canSync = true;
                        }
                        if (stack.func_77952_i() == 5) {
                            NBTTagCompound itemtag = ItemFolder.getItemTag(stack);
                            ItemStack copystack = new ItemStack(folderStack.func_77973_b(), (int)extract, meta);
                            copystack.func_77982_d(itemtag);
                            return copystack;
                        }
                        return new ItemStack(folderStack.func_77973_b(), (int)extract, meta);
                    }
                    if (count == 0L && stack.func_77952_i() == 2 && ItemFolder.getRemSize(stack) > 0) {
                        ItemStack folderStack = (ItemStack)ItemFolder.getObject(stack);
                        int damage = folderStack.func_77958_k() - ItemFolder.getRemSize(stack);
                        return new ItemStack(folderStack.func_77973_b(), 1, damage);
                    }
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    public void enderFolderExtract(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting.func_77973_b() instanceof IFolder) {
            for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                ItemStack container = event.craftMatrix.func_70301_a(i);
                if (container.func_190926_b() || container.func_77973_b() instanceof IFolder || !container.func_77973_b().hasContainerItem(container)) continue;
                event.craftMatrix.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
        if (!event.player.func_130014_f_().field_72995_K && this.canSync) {
            if (!this.foldy.func_190926_b()) {
                EnderUtils.syncToTile(EnderUtils.getTileLoc(this.foldy), NBTUtils.getInt(this.foldy, StringLibs.RFC_DIM, 0), NBTUtils.getInt(this.foldy, StringLibs.RFC_SLOTINDEX, 0), ItemFolder.extractSize, true);
            }
            this.canSync = false;
        }
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Item)RFCItems.folder);
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting ic) {
        NonNullList ret = NonNullList.func_191197_a((int)ic.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); ++i) {
            if (ic.func_70301_a(i).func_77973_b() == RFCItems.folder || ic.func_70301_a(i).func_77973_b() == RFCItems.dyedFolder) {
                ret.set(i, (Object)ic.func_70301_a(i).func_77973_b().getContainerItem(ic.func_70301_a(i)));
                continue;
            }
            ret.set(i, (Object)ItemStack.field_190927_a);
        }
        return ret;
    }
}

