/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks;

import com.bafomdad.realfilingcabinet.TabRFC;
import com.bafomdad.realfilingcabinet.api.IFilingCabinet;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityAC;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemAspectFolder;
import com.bafomdad.realfilingcabinet.utils.AspectStorageUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.IEssentiaContainerItem;

public class BlockAC
extends Block
implements IFilingCabinet {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockAC() {
        super(Material.field_151575_d);
        this.setRegistryName("aspectcabinet");
        this.func_149663_c("realfilingcabinet.aspectcabinet");
        this.func_149711_c(2.0f);
        this.func_149752_b(1000.0f);
        this.func_149647_a(TabRFC.instance);
        GameRegistry.registerTileEntity(TileEntityAC.class, (String)"tileAspectCabinet");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN && side.func_176745_a() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && tile instanceof TileEntityAC) {
            this.leftClick(tile, player);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityAC) {
                this.rightClick(tile, player, facing, hitX, hitY, hitZ);
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)entity.func_174811_aO().func_176734_d()), 2);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAC && stack.func_77942_o()) {
            ((TileEntityAC)tile).readInv(stack.func_77978_p());
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.field_71075_bZ.field_75098_d && !world.field_72995_K) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184607_cu());
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        if (tile instanceof TileEntityAC) {
            ItemStack s = new ItemStack((Block)this);
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntityAC)tile).writeInv(tag, true);
            if (!tag.func_82582_d()) {
                s.func_77982_d(tag);
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), s));
                return;
            }
        }
        super.func_180657_a(world, player, pos, state, tile, stack);
    }

    @Override
    public void leftClick(TileEntity tile, EntityPlayer player) {
        TileEntityAC tileAC = (TileEntityAC)tile;
        AspectStorageUtils.extractAspect(tileAC, player, player.func_70093_af());
    }

    @Override
    public void rightClick(TileEntity tile, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        int i;
        TileEntityAC tileAC = (TileEntityAC)tile;
        ItemStack stack = player.func_184614_ca();
        if (!player.func_70093_af() && !stack.func_190926_b()) {
            if (stack.func_77973_b() == RFCItems.aspectFolder && !ItemAspectFolder.isAspectFolderEmpty(stack) && tileAC.isOpen) {
                if (!tileAC.func_145831_w().field_72995_K) {
                    for (i = 0; i < tileAC.getInv().getSlots(); ++i) {
                        ItemStack tileStack = tileAC.getInv().getStackInSlot(i);
                        if (!tileStack.func_190926_b()) continue;
                        tileAC.getInv().setStackInSlot(i, stack);
                        player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        tileAC.markBlockForUpdate();
                        return;
                    }
                }
            } else if (stack.func_77973_b() instanceof IEssentiaContainerItem && !tileAC.isOpen && !tileAC.func_145831_w().field_72995_K) {
                AspectStorageUtils.addAspect(tileAC, player, stack);
            }
        }
        if (!player.func_70093_af() && stack.func_190926_b()) {
            if (!tileAC.func_145831_w().field_72995_K) {
                tileAC.isOpen = !tileAC.isOpen;
                tileAC.func_70296_d();
            }
            tileAC.markBlockForUpdate();
        }
        if (player.func_70093_af() && stack.func_190926_b() && tileAC.isOpen) {
            for (i = tileAC.getInv().getSlots() - 1; i >= 0; --i) {
                ItemStack folder = tileAC.getInv().getStackInSlot(i);
                if (folder.func_190926_b()) continue;
                tileAC.getInv().setStackInSlot(i, ItemStack.field_190927_a);
                player.func_184611_a(EnumHand.MAIN_HAND, folder);
                tileAC.markBlockForUpdate();
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityAC();
    }
}

