/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static <T extends LayerRenderer<?>> T getRenderLayer(RenderLivingBase<?> renderer, Class<T> cls, boolean subclasses) {
        try {
            List layers = renderer.field_177097_h;
            for (LayerRenderer layer : layers) {
                if (!(subclasses ? cls.isInstance(layer) : cls == layer.getClass())) continue;
                return (T)layer;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    public static boolean doesRendererHaveLayer(RenderLivingBase<?> renderer, Class<? extends LayerRenderer<?>> cls, boolean subclasses) {
        return RenderUtils.getRenderLayer(renderer, cls, subclasses) != null;
    }

    public static int getBoundFramebuffer() {
        if (OpenGlHelper.field_148823_f) {
            switch (OpenGlHelper.field_153212_w) {
                case BASE: {
                    return GL11.glGetInteger((int)36006);
                }
                case ARB: {
                    return GL11.glGetInteger((int)36006);
                }
                case EXT: {
                    return GL11.glGetInteger((int)36006);
                }
            }
        }
        return -1;
    }

    public static void saveFboToFile(File file, Framebuffer fbo) {
        int prevFBO = RenderUtils.getBoundFramebuffer();
        fbo.func_147610_a(false);
        GL11.glReadBuffer((int)1028);
        int width = fbo.field_147621_c;
        int height = fbo.field_147618_d;
        int bpp = 4;
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * bpp));
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)buffer);
        String format = "PNG";
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int i = (x + width * y) * bpp;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                int a = buffer.get(i + 3) & 0xFF;
                image.setRGB(x, height - (y + 1), a << 24 | r << 16 | g << 8 | b);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, format, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153199_f, (int)prevFBO);
    }
}

