/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.tmg;

import com.m4thg33k.tombmanygraves2api.api.inventory.AbstractSpecialInventory;
import com.m4thg33k.tombmanygraves2api.api.inventory.SpecialInventoryHelper;
import com.m4thg33k.tombmanygraves2api.api.inventory.TransitionInventory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.registries.CapabilityRegistry;

public class TMGEquipmentInventory
extends AbstractSpecialInventory {
    public String getUniqueIdentifier() {
        return "TheBetweenlandsEquipment";
    }

    public NBTBase getNbtData(EntityPlayer player) {
        IEquipmentCapability equipmentCapability = (IEquipmentCapability)player.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
        if (equipmentCapability != null) {
            EnumEquipmentInventory[] equipmentInventories;
            NBTTagCompound compound = new NBTTagCompound();
            boolean setTag = false;
            for (EnumEquipmentInventory type : equipmentInventories = EnumEquipmentInventory.values()) {
                IInventory inv = equipmentCapability.getInventory(type);
                NBTTagList tagList = SpecialInventoryHelper.getTagListFromIInventory((IInventory)inv);
                if (tagList == null) continue;
                compound.func_74782_a(type.ordinal() + "", (NBTBase)tagList);
                setTag = true;
            }
            if (setTag) {
                return compound;
            }
            return null;
        }
        return null;
    }

    public void insertInventory(EntityPlayer player, NBTBase compound, boolean shouldForce) {
        if (compound instanceof NBTTagCompound) {
            EnumEquipmentInventory[] equipmentInventories = EnumEquipmentInventory.values();
            IEquipmentCapability equipmentCapability = (IEquipmentCapability)player.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            if (equipmentCapability != null) {
                for (EnumEquipmentInventory type : equipmentInventories) {
                    if (!((NBTTagCompound)compound).func_74764_b(type.ordinal() + "")) continue;
                    NBTTagList tagList = (NBTTagList)((NBTTagCompound)compound).func_74781_a(type.ordinal() + "");
                    TransitionInventory graveItems = new TransitionInventory(tagList);
                    IInventory currentInventory = equipmentCapability.getInventory(type);
                    for (int i = 0; i < graveItems.func_70302_i_(); ++i) {
                        ItemStack graveItem = graveItems.func_70301_a(i);
                        if (type == EnumEquipmentInventory.AMULET && i >= equipmentCapability.getAmuletSlots()) {
                            SpecialInventoryHelper.dropItem((EntityPlayer)player, (ItemStack)graveItem);
                            continue;
                        }
                        if (graveItem.func_190926_b()) continue;
                        ItemStack playerItem = currentInventory.func_70301_a(i).func_77946_l();
                        if (playerItem.func_190926_b()) {
                            currentInventory.func_70299_a(i, graveItem);
                            continue;
                        }
                        if (shouldForce) {
                            currentInventory.func_70299_a(i, graveItem);
                            SpecialInventoryHelper.dropItem((EntityPlayer)player, (ItemStack)playerItem);
                            continue;
                        }
                        SpecialInventoryHelper.dropItem((EntityPlayer)player, (ItemStack)graveItem);
                    }
                }
            }
        }
    }

    @Nonnull
    public List<ItemStack> getDrops(NBTBase compound) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (compound instanceof NBTTagCompound) {
            EnumEquipmentInventory[] equipmentInventories;
            for (EnumEquipmentInventory type : equipmentInventories = EnumEquipmentInventory.values()) {
                if (!((NBTTagCompound)compound).func_74764_b(type.ordinal() + "")) continue;
                NBTTagList tagList = (NBTTagList)((NBTTagCompound)compound).func_74781_a(type.ordinal() + "");
                ret.addAll(new TransitionInventory(tagList).getListOfNonEmptyItemStacks());
            }
        }
        return ret;
    }

    public String getInventoryDisplayNameForGui() {
        return "Betweenlands Equipment";
    }

    public int getInventoryDisplayNameColorForGui() {
        return 4632134;
    }
}

