/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.common.world.storage.LocalRegionData;
import thebetweenlands.common.world.storage.LocalStorageHandlerImpl;

public class LocalRegionCache {
    private final Map<LocalRegion, LocalRegionData> regionData = new HashMap<LocalRegion, LocalRegionData>();
    private final File dir;
    private final LocalStorageHandlerImpl handler;

    public LocalRegionCache(LocalStorageHandlerImpl handler, File dir) {
        this.dir = dir;
        this.handler = handler;
    }

    public LocalStorageHandlerImpl getLocalStorageHandler() {
        return this.handler;
    }

    public File getDir() {
        return this.dir;
    }

    public LocalRegionData getOrCreateRegion(LocalRegion region) {
        LocalRegionData data = this.regionData.get(region);
        if (data == null) {
            data = LocalRegionData.getOrCreateRegion(this, this.dir, region);
            this.regionData.put(region, data);
        }
        return data;
    }

    public void removeRegion(LocalRegion region) {
        this.regionData.remove(region);
    }

    public void saveAllRegions() {
        for (LocalRegionData data : this.regionData.values()) {
            if (!data.isDirty()) continue;
            data.saveRegion(this.dir);
        }
    }

    public void clearCache() {
        this.regionData.clear();
    }

    public Map<LocalRegion, LocalRegionData> getRegions() {
        return Collections.unmodifiableMap(this.regionData);
    }
}

