/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.plant.BlockMoss;
import thebetweenlands.common.block.terrain.BlockHanger;
import thebetweenlands.common.block.terrain.BlockLeavesBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.IBlockStateAccessOnly;
import thebetweenlands.util.CatmullRomSpline;

public class WorldGenGiantRoot
extends WorldGenerator {
    public final BlockPos start;
    public final BlockPos end;
    protected double minWidth;
    protected double maxWidth;
    protected double randXZOffsetRange;
    protected double randYOffsetRange;
    protected double maxArcHeight;
    protected boolean genLeafyBranches;
    protected boolean genSmallerRoots;
    protected boolean genLeaves;
    protected boolean genFungi;
    protected AxisAlignedBB genBounds;

    public WorldGenGiantRoot(BlockPos start, BlockPos end, int archHeight) {
        this(start, end, 2.0, 3.0, 8.0, 5.0, archHeight, true, false, true, true, null);
    }

    public WorldGenGiantRoot(BlockPos start, BlockPos end, double minWidth, double maxWidth, double randXZOffsetRange, double randYOffsetRange, double maxArcHeight, boolean genLeafyBranches, boolean genLeaves, boolean genFungi, boolean genSmallerRoots, AxisAlignedBB genBounds) {
        this.start = start;
        this.end = end;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.randXZOffsetRange = randXZOffsetRange;
        this.randYOffsetRange = randYOffsetRange;
        this.maxArcHeight = maxArcHeight;
        this.genLeafyBranches = genLeafyBranches;
        this.genLeaves = genLeaves;
        this.genFungi = genFungi;
        this.genSmallerRoots = genSmallerRoots;
        this.genBounds = genBounds;
    }

    public WorldGenGiantRoot setMaxWidth(int size) {
        this.maxWidth = size;
        return this;
    }

    public WorldGenGiantRoot setMinWidth(int size) {
        this.minWidth = size;
        return this;
    }

    public WorldGenGiantRoot setGenBounds(AxisAlignedBB aabb) {
        this.genBounds = aabb;
        return this;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        return this.generate(IBlockStateAccessOnly.from(worldIn), 0, 0, false, rand, position);
    }

    public boolean generate(IBlockStateAccessOnly worldIn, int chunkX, int chunkZ, boolean checkChunk, Random rand, BlockPos position) {
        BlockPos genPos;
        int zo;
        int yo;
        int xo;
        int radius;
        double widthMul;
        BlockPos pos;
        int i;
        boolean generated = true;
        Vec3d up = new Vec3d(0.0, 1.0, 0.0);
        Vec3d diff = new Vec3d((Vec3i)this.end.func_177973_b((Vec3i)this.start));
        Vec3d dir = diff.func_72432_b();
        Vec3d offsetDir = up.func_72431_c(dir);
        Vec3d controlPtStart = new Vec3d((Vec3i)this.start).func_178788_d(dir).func_72441_c(0.0, -16.0, 0.0);
        Vec3d controlPtEnd = new Vec3d((Vec3i)this.end).func_178787_e(dir).func_72441_c(0.0, -16.0, 0.0);
        ArrayList<Vec3d> pts = new ArrayList<Vec3d>();
        pts.add(controlPtStart);
        pts.add(new Vec3d((Vec3i)this.start));
        int randPts = 5;
        for (int i2 = 0; i2 < randPts; ++i2) {
            Vec3d pt = new Vec3d((Vec3i)this.start).func_178787_e(diff.func_186678_a((double)((float)i2 / (float)randPts))).func_72441_c(offsetDir.field_72450_a * (rand.nextDouble() - 0.5) * this.randXZOffsetRange * 2.0, (rand.nextDouble() - 0.5) * this.randYOffsetRange * 2.0 + Math.sin((double)((float)i2 / (float)randPts) * Math.PI) * this.maxArcHeight, offsetDir.field_72449_c * (rand.nextDouble() - 0.5) * this.randXZOffsetRange * 2.0);
            pts.add(pt);
        }
        pts.add(new Vec3d((Vec3i)this.end));
        pts.add(controlPtEnd);
        CatmullRomSpline spline = new CatmullRomSpline(pts.toArray(new Vec3d[0]));
        IBlockState bark = BlockRegistry.GIANT_ROOT.func_176223_P();
        IBlockState leaves = BlockRegistry.LEAVES_WEEDWOOD_TREE.func_176223_P().func_177226_a((IProperty)BlockLeavesBetweenlands.field_176236_b, (Comparable)Boolean.valueOf(false));
        IBlockState root = BlockRegistry.ROOT.func_176223_P();
        IBlockState hanger = BlockRegistry.HANGER.func_176223_P().func_177226_a((IProperty)BlockHanger.CAN_GROW, (Comparable)Boolean.valueOf(false));
        IBlockState fungus = BlockRegistry.SHELF_FUNGUS.func_176223_P();
        int steps = 20 + (int)(this.start.func_185332_f(this.end.func_177958_n(), this.end.func_177956_o(), this.end.func_177952_p()) * 4.0);
        long rootWidthRandSeed = rand.nextLong();
        Random rootWidthRand = new Random();
        Random smallerRootRand = new Random();
        smallerRootRand.setSeed(rand.nextLong());
        rootWidthRand.setSeed(rootWidthRandSeed);
        BlockPos prevPos = BlockPos.field_177992_a;
        for (i = 0; i < steps; ++i) {
            WorldGenGiantRoot smallRoot;
            pos = new BlockPos(spline.interpolate((float)i / (float)steps));
            if (pos.equals((Object)prevPos)) continue;
            prevPos = pos;
            if (this.genLeafyBranches && smallerRootRand.nextInt(12) == 0) {
                smallRoot = new WorldGenGiantRoot(pos, pos.func_177963_a(offsetDir.field_72450_a * (smallerRootRand.nextDouble() - 0.5) * 16.0, smallerRootRand.nextDouble() * 8.0, offsetDir.field_72449_c * (smallerRootRand.nextDouble() - 0.5) * 16.0), 0.5, 0.5, 3.0, 3.0, 0.0, false, true, false, false, this.genBounds);
                smallRoot.generate(worldIn, chunkX, chunkZ, checkChunk, smallerRootRand, pos);
            }
            if (this.genSmallerRoots && smallerRootRand.nextInt(12) == 0) {
                smallRoot = new WorldGenGiantRoot(pos, pos.func_177963_a(offsetDir.field_72450_a * (smallerRootRand.nextDouble() - 0.5) * 16.0, -smallerRootRand.nextDouble() * 8.0, offsetDir.field_72449_c * (smallerRootRand.nextDouble() - 0.5) * 16.0), 0.5, 0.5, 3.0, 3.0, 0.0, false, false, false, false, this.genBounds);
                smallRoot.generate(worldIn, chunkX, chunkZ, checkChunk, smallerRootRand, pos);
            }
            widthMul = 1.0f - (i > steps / 2 ? (float)(steps - i) / (float)steps * 2.0f : (float)i / (float)steps * 2.0f);
            radius = (int)(rootWidthRand.nextDouble() * (this.maxWidth - this.minWidth) * widthMul + this.minWidth);
            if (checkChunk && !this.shouldCheckAtPos(pos, chunkX, chunkZ, radius)) continue;
            for (xo = -radius; xo <= radius; ++xo) {
                for (yo = -radius; yo <= radius; ++yo) {
                    for (zo = -radius; zo <= radius; ++zo) {
                        genPos = pos.func_177982_a(xo, yo, zo);
                        if (!this.isInBounds(genPos) || xo * xo + yo * yo + zo * zo > radius * radius) continue;
                        worldIn.setBlockState(genPos, bark, 2);
                    }
                }
            }
        }
        if (this.genLeaves) {
            rootWidthRand.setSeed(rootWidthRandSeed);
            prevPos = BlockPos.field_177992_a;
            for (i = 0; i < steps; ++i) {
                pos = new BlockPos(spline.interpolate((float)i / (float)steps));
                if (pos.equals((Object)prevPos)) continue;
                prevPos = pos;
                widthMul = 1.0f - (i > steps / 2 ? (float)(steps - i) / (float)steps * 2.0f : (float)i / (float)steps * 2.0f);
                radius = 1 + (int)(rootWidthRand.nextDouble() * (this.maxWidth - this.minWidth) * widthMul + this.minWidth);
                if (checkChunk && !this.shouldCheckAtPos(pos, chunkX, chunkZ, radius)) continue;
                for (xo = -radius; xo <= radius; ++xo) {
                    for (yo = -radius; yo <= radius; ++yo) {
                        for (zo = -radius; zo <= radius; ++zo) {
                            genPos = pos.func_177982_a(xo, yo, zo);
                            if (!this.isInBounds(genPos) || worldIn.getBlockState(genPos) == bark || xo * xo + yo * yo + zo * zo <= (radius - 1) * (radius - 1) || xo * xo + yo * yo + zo * zo > radius * radius) continue;
                            worldIn.setBlockState(genPos, leaves, 2);
                        }
                    }
                }
            }
        }
        if (this.genFungi) {
            rootWidthRand.setSeed(rootWidthRandSeed);
            prevPos = BlockPos.field_177992_a;
            for (i = 0; i < steps; ++i) {
                pos = new BlockPos(spline.interpolate((float)i / (float)steps));
                if (pos.equals((Object)prevPos)) continue;
                prevPos = pos;
                widthMul = 1.0f - (i > steps / 2 ? (float)(steps - i) / (float)steps * 2.0f : (float)i / (float)steps * 2.0f);
                radius = (int)(rootWidthRand.nextDouble() * (this.maxWidth - this.minWidth) * widthMul + this.minWidth) - 1;
                if (checkChunk && !this.shouldCheckAtPos(pos, chunkX, chunkZ, radius + 4 + radius / 5)) continue;
                for (xo = -radius; xo <= radius; ++xo) {
                    for (yo = -radius + 1; yo <= radius - 1; ++yo) {
                        for (zo = -radius; zo <= radius; ++zo) {
                            genPos = pos.func_177982_a(xo, yo, zo);
                            if (xo * xo + yo * yo + zo * zo < radius * radius) continue;
                            Random fungiRand = new Random();
                            fungiRand.setSeed(MathHelper.func_180187_c((int)genPos.func_177958_n(), (int)genPos.func_177956_o(), (int)genPos.func_177952_p()));
                            if (fungiRand.nextInt(160) != 0) continue;
                            int fungiRadius = fungiRand.nextInt(2) + radius / 5 + 2;
                            for (int fx = -fungiRadius; fx <= fungiRadius; ++fx) {
                                for (int fz = -fungiRadius; fz <= fungiRadius; ++fz) {
                                    BlockPos fungiPos = genPos.func_177982_a(fx, 0, fz);
                                    if (!(((double)fx + 0.5) * ((double)fx + 0.5) + ((double)fz + 0.5) * ((double)fz + 0.5) <= (double)(fungiRadius * fungiRadius)) || !this.isInBounds(fungiPos) || worldIn.getBlockState(fungiPos) == bark) continue;
                                    worldIn.setBlockState(fungiPos, fungus);
                                }
                            }
                        }
                    }
                }
            }
        }
        Random foliageRand = new Random();
        foliageRand.setSeed(rand.nextLong());
        rootWidthRand.setSeed(rootWidthRandSeed);
        prevPos = BlockPos.field_177992_a;
        for (int i3 = 0; i3 < steps; ++i3) {
            BlockPos pos2 = new BlockPos(spline.interpolate((float)i3 / (float)steps));
            if (pos2.equals((Object)prevPos)) continue;
            prevPos = pos2;
            double widthMul2 = 1.0f - (i3 > steps / 2 ? (float)(steps - i3) / (float)steps * 2.0f : (float)i3 / (float)steps * 2.0f);
            int radius2 = 1 + (int)(rootWidthRand.nextDouble() * (this.maxWidth - this.minWidth) * widthMul2 + this.minWidth);
            if (checkChunk && !this.shouldCheckAtPos(pos2, chunkX, chunkZ, radius2)) continue;
            for (int xo2 = -radius2; xo2 <= radius2; ++xo2) {
                for (int yo2 = -radius2; yo2 <= radius2; ++yo2) {
                    for (int zo2 = -radius2; zo2 <= radius2; ++zo2) {
                        BlockPos genPos2 = pos2.func_177982_a(xo2, yo2, zo2);
                        if (this.genLeaves) continue;
                        if (this.isInBounds(genPos2) && foliageRand.nextInt(60) == 0 && yo2 >= radius2 - 2 && xo2 * xo2 + yo2 * yo2 + zo2 * zo2 <= (radius2 - 1) * (radius2 - 1) && !worldIn.isAirBlock(genPos2) && worldIn.isAirBlock(genPos2.func_177984_a()) && worldIn.isAirBlock(genPos2.func_177981_b(2))) {
                            BlockPos rootPos;
                            int maxRootHeight = 2 + foliageRand.nextInt(3);
                            for (int r = 0; r < maxRootHeight && worldIn.isAirBlock(rootPos = genPos2.func_177982_a(0, 1 + r, 0)); ++r) {
                                worldIn.setBlockState(rootPos, root, 2);
                            }
                        }
                        if (this.isInBounds(genPos2) && foliageRand.nextInt(10) == 0 && yo2 <= radius2 - 2 && xo2 * xo2 + yo2 * yo2 + zo2 * zo2 <= (radius2 - 1) * (radius2 - 1) && !worldIn.isAirBlock(genPos2) && worldIn.isAirBlock(genPos2.func_177977_b()) && worldIn.isAirBlock(genPos2.func_177979_c(2))) {
                            BlockPos hangerPos;
                            int maxHangersHeight = 3 + foliageRand.nextInt(16);
                            for (int r = 0; r < maxHangersHeight && worldIn.isAirBlock(hangerPos = genPos2.func_177982_a(0, -1 - r, 0)); ++r) {
                                worldIn.setBlockState(hangerPos, hanger, 2);
                            }
                        }
                        if (!this.isInBounds(genPos2) || foliageRand.nextInt(10) != 0 || xo2 * xo2 + yo2 * yo2 + zo2 * zo2 <= (radius2 - 1) * (radius2 - 1) || !worldIn.isAirBlock(genPos2)) continue;
                        List<EnumFacing> dirs = Arrays.asList(Arrays.copyOf(EnumFacing.field_82609_l, EnumFacing.field_82609_l.length));
                        Collections.shuffle(dirs, foliageRand);
                        for (EnumFacing facing : dirs) {
                            if ((xo2 + facing.func_82601_c()) * (xo2 + facing.func_82601_c()) + (yo2 + facing.func_96559_d()) * (yo2 + facing.func_96559_d()) + (zo2 + facing.func_82599_e()) * (zo2 + facing.func_82599_e()) > (radius2 - 1) * (radius2 - 1)) continue;
                            worldIn.setBlockState(genPos2, BlockRegistry.MOSS.func_176223_P().func_177226_a((IProperty)BlockMoss.field_176387_N, (Comparable)facing.func_176734_d()), 2);
                        }
                    }
                }
            }
        }
        return generated;
    }

    protected boolean shouldCheckAtPos(BlockPos pos, int chunkX, int chunkZ, int radius) {
        double dx = pos.func_177958_n() >= chunkX * 16 && pos.func_177958_n() <= chunkX * 16 + 16 ? 0.0 : (double)Math.min(Math.abs(chunkX * 16 - pos.func_177958_n()), Math.abs(pos.func_177958_n() - (chunkX * 16 + 16)));
        double dz = pos.func_177952_p() >= chunkZ * 16 && pos.func_177952_p() <= chunkZ * 16 + 16 ? 0.0 : (double)Math.min(Math.abs(chunkZ * 16 - pos.func_177952_p()), Math.abs(pos.func_177952_p() - (chunkZ * 16 + 16)));
        return dx * dx + dz * dz <= (double)(radius * radius);
    }

    protected boolean isInBounds(BlockPos pos) {
        return this.genBounds == null || this.genBounds.field_72340_a <= (double)pos.func_177958_n() && this.genBounds.field_72338_b <= (double)pos.func_177956_o() && this.genBounds.field_72339_c <= (double)pos.func_177952_p() && this.genBounds.field_72336_d >= (double)pos.func_177958_n() && this.genBounds.field_72337_e >= (double)pos.func_177956_o() && this.genBounds.field_72334_f >= (double)pos.func_177952_p();
    }
}

