/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IBLBoss;
import thebetweenlands.common.entity.mobs.EntityWight;

public class TileEntityRepeller
extends TileEntity
implements ITickable {
    private static final float MAX_RADIUS = 18.0f;
    private static final int DEPLOY_TIME = 80;
    private boolean hasShimmerstone = false;
    private int fuel = 0;
    private boolean prevRunning = false;
    private boolean running = false;
    private float lastRadius = 0.0f;
    private float radius = 0.0f;
    private int deployTicks = 0;
    private int radiusState = 0;
    private float accumulatedCost = 0.0f;
    public int renderTicks = 0;

    public void setRadiusState(int state) {
        if (this.running && state % 4 != this.radiusState) {
            this.deployTicks = 0;
        }
        this.radiusState = state % 4;
        this.func_70296_d();
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
    }

    public void cycleRadiusState() {
        this.radiusState = (this.radiusState + 1) % 4;
        if (this.running) {
            this.deployTicks = 0;
        }
        this.func_70296_d();
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
    }

    public void addShimmerstone() {
        this.hasShimmerstone = true;
        this.func_70296_d();
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
    }

    public boolean hasShimmerstone() {
        return this.hasShimmerstone;
    }

    public void removeShimmerstone() {
        this.hasShimmerstone = false;
        this.func_70296_d();
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
    }

    public int getMaxFuel() {
        return 10000;
    }

    public int addFuel(int amount) {
        int canAdd;
        if (amount != 0 && (canAdd = this.getMaxFuel() - this.fuel) > 0) {
            int added = Math.min(canAdd, amount);
            this.fuel += added;
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
            this.func_70296_d();
            return added;
        }
        return 0;
    }

    public int removeFuel(int amount) {
        int removed = Math.min(this.fuel, amount);
        if (amount != 0) {
            this.fuel -= amount;
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
            this.func_70296_d();
        }
        return removed;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void emptyFuel() {
        this.fuel = 0;
    }

    public boolean isRunning() {
        return this.running || this.radius > 0.0f;
    }

    public float getRadius(float partialTicks) {
        return this.lastRadius + (this.radius - this.lastRadius) * partialTicks;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IBlockState blockState;
            if (this.fuel > 0 && this.fuel <= 0) {
                this.fuel = 0;
                this.func_70296_d();
            }
            if (this.fuel > 0 && this.hasShimmerstone) {
                if (!this.running) {
                    this.running = true;
                    blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
                    this.func_70296_d();
                }
            } else if ((this.fuel <= 0 || !this.hasShimmerstone) && this.running) {
                this.running = false;
                blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
                this.func_70296_d();
            }
            if (this.fuel < 0) {
                this.fuel = 0;
                blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
                this.func_70296_d();
            } else {
                float fuelCost = 0.0f;
                double centerX = (float)this.field_174879_c.func_177958_n() + 0.5f;
                double centerY = (float)this.field_174879_c.func_177956_o() + 1.15f;
                double centerZ = (float)this.field_174879_c.func_177952_p() + 0.5f;
                AxisAlignedBB affectedBB = new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - this.radius - 5.0f), (double)((float)this.field_174879_c.func_177956_o() - this.radius - 5.0f), (double)((float)this.field_174879_c.func_177952_p() - this.radius - 5.0f), (double)((float)this.field_174879_c.func_177958_n() + this.radius + 5.0f), (double)((float)this.field_174879_c.func_177956_o() + this.radius + 5.0f), (double)((float)this.field_174879_c.func_177952_p() + this.radius + 5.0f));
                List affectedEntities = this.field_145850_b.func_72872_a(Entity.class, affectedBB);
                for (Entity entity : affectedEntities) {
                    Vec3d closestPoint;
                    if (entity instanceof IMob && !(entity instanceof EntityWight) && !(entity instanceof IBLBoss) && (closestPoint = this.getClosestAABBCorner(entity.func_174813_aQ(), centerX, centerY, centerZ)).func_186679_c(centerX, centerY, centerZ) < (double)(this.radius * this.radius)) {
                        double diffX = entity.field_70165_t - centerX;
                        double diffY = entity.field_70163_u - centerY;
                        double diffZ = entity.field_70161_v - centerZ;
                        entity.func_70091_d(MoverType.PISTON, diffX * (double)0.1f, 0.0, diffZ * (double)0.1f);
                        double len = Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
                        double speed = ((double)this.radius - len) / (double)this.radius * 1.5 + 0.5;
                        entity.field_70159_w = (double)((float)(diffX / len)) * speed;
                        entity.field_70179_y = (double)((float)(diffZ / len)) * speed;
                        if (entity instanceof EntityLivingBase) {
                            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 10, 6));
                        }
                        if (!entity.field_70123_F) {
                            fuelCost += 2.8E-4f * ((float)this.radiusState / 1.5f + 1.0f);
                        }
                    }
                    if (!(entity instanceof IProjectile) || !((closestPoint = this.getClosestAABBCorner(entity.func_174813_aQ(), centerX, centerY, centerZ)).func_186679_c(centerX, centerY, centerZ) < (double)(this.radius * this.radius))) continue;
                    double velocity = Math.sqrt(entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y);
                    double diffX = entity.field_70165_t - centerX;
                    double diffY = entity.field_70163_u - centerY;
                    double diffZ = entity.field_70161_v - centerZ;
                    double len = Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
                    entity.func_70091_d(MoverType.PISTON, diffX * (double)0.1f, 0.0, diffZ * (double)0.1f);
                    entity.field_70159_w = (double)((float)(diffX / len)) * velocity;
                    entity.field_70181_x = (double)((float)(diffY / len)) * velocity;
                    entity.field_70179_y = (double)((float)(diffZ / len)) * velocity;
                    ((IProjectile)entity).func_70186_c(diffX / len, diffY / len, diffZ / len, 1.0f, 1.0f);
                    entity.field_70133_I = true;
                    if (entity.field_70123_F || entity.field_70124_G || entity.field_70122_E) continue;
                    fuelCost += 4.0E-4f * ((float)this.radiusState / 1.5f + 1.0f);
                }
                boolean fuelConsumed = false;
                this.accumulatedCost += Math.min(fuelCost, 0.00125f) * 1000.0f;
                while (this.accumulatedCost > 1.0f) {
                    this.accumulatedCost -= 1.0f;
                    --this.fuel;
                    fuelConsumed = true;
                }
                if (fuelConsumed) {
                    IBlockState blockState2 = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, blockState2, blockState2, 3);
                }
                this.func_70296_d();
            }
        } else {
            ++this.renderTicks;
        }
        if (this.prevRunning != this.running) {
            this.deployTicks = 0;
            this.func_70296_d();
        }
        this.prevRunning = this.running;
        float desiredRadius = 4.5f * (float)(this.radiusState + 1);
        this.lastRadius = this.radius;
        if (this.running && this.radius < desiredRadius && this.deployTicks < 80) {
            ++this.deployTicks;
            this.radius = (float)this.easeInOut(this.deployTicks, this.radius, desiredRadius, 80.0f);
            if (this.radius > desiredRadius) {
                this.radius = desiredRadius;
            }
            this.func_70296_d();
        } else if (!this.running && this.radius > 0.0f || this.radius > desiredRadius) {
            ++this.deployTicks;
            this.radius = (float)this.easeInOut(this.deployTicks, !this.running ? desiredRadius : this.radius, -desiredRadius, 80.0f);
            if (!this.running && this.radius < 0.0f) {
                this.radius = 0.0f;
            } else if (this.running && this.radius < desiredRadius) {
                this.radius = desiredRadius;
            }
            this.func_70296_d();
        }
    }

    protected Vec3d getClosestAABBCorner(AxisAlignedBB bb, double centerX, double centerY, double centerZ) {
        Vec3d center = new Vec3d(centerX, centerY, centerZ);
        Vec3d closest = null;
        for (int bcx = 0; bcx <= 1; ++bcx) {
            for (int bcy = 0; bcy <= 1; ++bcy) {
                for (int bcz = 0; bcz <= 1; ++bcz) {
                    double cx = bcx == 1 ? bb.field_72336_d : bb.field_72340_a;
                    double cy = bcy == 1 ? bb.field_72337_e : bb.field_72338_b;
                    double cz = bcz == 1 ? bb.field_72334_f : bb.field_72339_c;
                    Vec3d current = new Vec3d(cx, cy, cz);
                    if (closest != null && !(current.func_72438_d(center) < closest.func_72438_d(center))) continue;
                    closest = current;
                }
            }
        }
        return closest;
    }

    protected double easeInOut(float t, float b, float c, float d) {
        if ((t /= d / 2.0f) < 1.0f) {
            return c / 2.0f * t * t * t * t * t + b;
        }
        return c / 2.0f * ((t -= 2.0f) * t * t * t * t + 2.0f) + b;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        double radius = this.getRadius(0.0f);
        return new AxisAlignedBB(this.field_174879_c).func_72314_b(radius, radius, radius).func_72321_a(0.0, 1.0, 0.0);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuel = nbt.func_74762_e("fuel");
        this.hasShimmerstone = nbt.func_74767_n("hasShimmerstone");
        this.deployTicks = nbt.func_74762_e("deployTicks");
        this.radius = nbt.func_74760_g("radius");
        this.prevRunning = this.running = nbt.func_74767_n("running");
        this.radiusState = nbt.func_74762_e("radiusState");
        this.accumulatedCost = nbt.func_74760_g("accumulatedCost");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("fuel", this.fuel);
        nbt.func_74757_a("hasShimmerstone", this.hasShimmerstone);
        nbt.func_74768_a("deployTicks", this.deployTicks);
        nbt.func_74776_a("radius", this.radius);
        nbt.func_74757_a("running", this.running);
        nbt.func_74768_a("radiusState", this.radiusState);
        nbt.func_74776_a("accumulatedCost", this.accumulatedCost);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("fuel", this.fuel);
        nbt.func_74757_a("hasShimmerstone", this.hasShimmerstone);
        nbt.func_74757_a("running", this.running);
        nbt.func_74768_a("deployTicks", this.deployTicks);
        nbt.func_74776_a("radius", this.radius);
        nbt.func_74768_a("radiusState", this.radiusState);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.fuel = nbt.func_74762_e("fuel");
        this.hasShimmerstone = nbt.func_74767_n("hasShimmerstone");
        this.deployTicks = nbt.func_74762_e("deployTicks");
        this.radius = nbt.func_74760_g("radius");
        this.prevRunning = this.running = nbt.func_74767_n("running");
        this.radiusState = nbt.func_74762_e("radiusState");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74768_a("fuel", this.fuel);
        nbt.func_74757_a("hasShimmerstone", this.hasShimmerstone);
        nbt.func_74757_a("running", this.running);
        nbt.func_74768_a("deployTicks", this.deployTicks);
        nbt.func_74776_a("radius", this.radius);
        nbt.func_74768_a("radiusState", this.radiusState);
        return nbt;
    }
}

