/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.terrain.BlockLifeCrystalStalactite;
import thebetweenlands.common.network.clientbound.MessageSoundRipple;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.BetweenlandsChunkStorage;
import thebetweenlands.util.NBTHelper;

public class ItemGemSinger
extends Item {
    public ItemGemSinger() {
        this.func_77637_a(BLCreativeTabs.SPECIALS);
        this.func_77625_d(1);
        this.func_77656_e(32);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getTargetPosition(stack) != null;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            if (playerIn.func_70093_af()) {
                this.setTarget(stack, null, null);
            } else {
                int chunkRange = 6;
                int maxDelay = 80;
                int attempts = 64;
                BlockPos gem = this.getTargetPosition(stack);
                if (gem != null) {
                    IntSet gems;
                    BetweenlandsChunkStorage storage;
                    Chunk chunk;
                    GemSingerTarget target = this.getTargetType(stack);
                    boolean valid = false;
                    if (target != null && (chunk = worldIn.func_72863_F().func_186026_b(gem.func_177958_n() >> 4, gem.func_177952_p() >> 4)) != null && (storage = BetweenlandsChunkStorage.forChunk(worldIn, chunk)) != null && (gems = storage.findGems(target)).contains(BetweenlandsChunkStorage.getGemSingerTargetIndex(gem.func_177958_n(), gem.func_177956_o(), gem.func_177952_p()))) {
                        valid = true;
                    }
                    if (!valid) {
                        this.setTarget(stack, null, null);
                        gem = null;
                    }
                }
                if (gem == null) {
                    for (int i = 0; i < 64; ++i) {
                        GemSingerTarget target;
                        BetweenlandsChunkStorage storage;
                        Chunk chunk = worldIn.func_72863_F().func_186026_b((MathHelper.func_76128_c((double)playerIn.field_70165_t) >> 4) + worldIn.field_73012_v.nextInt(13) - 6, (MathHelper.func_76128_c((double)playerIn.field_70161_v) >> 4) + worldIn.field_73012_v.nextInt(13) - 6);
                        if (chunk == null || (storage = BetweenlandsChunkStorage.forChunk(worldIn, chunk)) == null || (gem = storage.findRandomGem(target = GemSingerTarget.values()[worldIn.field_73012_v.nextInt(GemSingerTarget.values().length)], worldIn.field_73012_v, playerIn.func_180425_c(), 96.0f)) == null) continue;
                        this.setTarget(stack, gem, target);
                        this.spawnEffect(playerIn, gem, 96, 80);
                        break;
                    }
                } else {
                    this.spawnEffect(playerIn, gem, 96, 80);
                }
                stack.func_77972_a(1, (EntityLivingBase)playerIn);
                playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), 60);
            }
        }
        if (worldIn.field_72995_K && !playerIn.func_70093_af()) {
            worldIn.func_184148_a(playerIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, (SoundEvent)SoundRegistry.GEM_SINGER, SoundCategory.PLAYERS, 2.0f, 1.0f);
        }
        playerIn.func_184609_a(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    protected void spawnEffect(EntityPlayer player, BlockPos target, int maxRangeBlocks, int maxDelay) {
        if (player instanceof EntityPlayerMP) {
            int delay = Math.min((int)(Math.sqrt(player.func_174818_b(target)) / (double)maxRangeBlocks * (double)maxDelay), maxDelay);
            TheBetweenlands.networkWrapper.sendTo((IMessage)new MessageSoundRipple(target, delay), (EntityPlayerMP)player);
        }
    }

    protected void setTarget(ItemStack stack, @Nullable BlockPos pos, @Nullable GemSingerTarget target) {
        if (pos != null && target != null) {
            NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
            nbt.func_74772_a("targetPos", pos.func_177986_g());
            nbt.func_74768_a("targetType", target.getId());
        } else if (stack.func_77978_p() != null) {
            stack.func_77978_p().func_82580_o("targetPos");
            stack.func_77978_p().func_82580_o("targetType");
        }
    }

    @Nullable
    protected BlockPos getTargetPosition(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("targetPos", 4)) {
            return BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("targetPos"));
        }
        return null;
    }

    @Nullable
    protected GemSingerTarget getTargetType(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("targetType", 3)) {
            return GemSingerTarget.byId(stack.func_77978_p().func_74762_e("targetType"));
        }
        return null;
    }

    public static enum GemSingerTarget implements Predicate<IBlockState>
    {
        AQUA_MIDDLE_GEM(0, state -> state.func_177230_c() == BlockRegistry.AQUA_MIDDLE_GEM_ORE),
        CRIMSON_MIDDLE_GEM(1, state -> state.func_177230_c() == BlockRegistry.CRIMSON_MIDDLE_GEM_ORE),
        GREEN_MIDDLE_GEM(2, state -> state.func_177230_c() == BlockRegistry.GREEN_MIDDLE_GEM_ORE),
        LIFE_CRYSTAL(3, state -> state.func_177230_c() == BlockRegistry.LIFE_CRYSTAL_STALACTITE && state.func_177229_b(BlockLifeCrystalStalactite.VARIANT) == BlockLifeCrystalStalactite.EnumLifeCrystalType.ORE);

        private final int id;
        private final Predicate<IBlockState> predicate;

        private GemSingerTarget(int id, Predicate<IBlockState> predicate) {
            this.id = id;
            this.predicate = predicate;
        }

        public int getId() {
            return this.id;
        }

        @Nullable
        public static GemSingerTarget byId(int id) {
            for (GemSingerTarget target : GemSingerTarget.values()) {
                if (target.id != id) continue;
                return target;
            }
            return null;
        }

        @Override
        public boolean test(IBlockState state) {
            return this.predicate.test(state);
        }
    }
}

