/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book.widgets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.herblore.book.GuiManualHerblore;
import thebetweenlands.common.herblore.book.ManualManager;
import thebetweenlands.common.herblore.book.Page;
import thebetweenlands.common.herblore.book.widgets.ManualWidgetBase;
import thebetweenlands.common.herblore.book.widgets.text.FormatTags;
import thebetweenlands.common.herblore.book.widgets.text.TextContainer;
import thebetweenlands.util.AspectIconRenderer;

@SideOnly(value=Side.CLIENT)
public class ButtonWidget
extends ManualWidgetBase {
    public int pageNumber;
    public int color = 0x808080;
    public boolean isHidden;
    public int width = 100;
    public int height = 16;
    int currentItem;
    boolean renderSomething = true;
    boolean doMathWithIndexPages = true;
    private List<ItemStack> items = NonNullList.func_191196_a();
    private IAspectType aspect;
    private TextContainer textContainer;
    private ResourceLocation resourceLocation;
    private Page page;

    public ButtonWidget(int xStart, int yStart, Page page) {
        super(xStart, yStart);
        this.pageNumber = page.pageNumber;
        this.page = page;
        if (page.pageItems.size() > 0) {
            this.items.addAll(page.pageItems);
        } else if (page.pageAspects.size() > 0) {
            this.aspect = page.pageAspects.get(0);
        } else if (page.resourceLocation != null) {
            this.resourceLocation = new ResourceLocation(page.resourceLocation);
        }
        this.textContainer = new TextContainer(84.0, 22.0, page.pageName, Minecraft.func_71410_x().field_71466_p);
        this.isHidden = page.isHidden;
        this.init();
    }

    public ButtonWidget(int xStart, int yStart, int width, int height, int pageNumber, boolean doMathWithIndexPages) {
        super(xStart, yStart);
        this.width = width;
        this.height = height;
        this.pageNumber = pageNumber;
        this.renderSomething = false;
        this.doMathWithIndexPages = doMathWithIndexPages;
    }

    @Override
    public void init(GuiManualHerblore manual) {
        super.init(manual);
        if (this.page != null) {
            this.pageNumber = this.page.pageNumber;
        }
        if (this.isHidden) {
            this.isHidden = !ManualManager.hasFoundPage(manual.player, this.page.unlocalizedPageName, manual.manualType);
        }
    }

    @Override
    public void setPageToRight() {
        super.setPageToRight();
        if (this.renderSomething) {
            this.textContainer = new TextContainer(84.0, 22.0, this.page.pageName, Minecraft.func_71410_x().field_71466_p);
            this.init();
        }
    }

    public void init() {
        this.textContainer.setCurrentScale(1.0f).setCurrentColor(this.color);
        this.textContainer.registerTag(new FormatTags.TagScale(1.0f));
        this.textContainer.registerTag(new FormatTags.TagColor(0x808080));
        this.textContainer.registerTag(new FormatTags.TagTooltip("N/A"));
        this.textContainer.registerTag(new FormatTags.TagSimple("bold", TextFormatting.BOLD));
        this.textContainer.registerTag(new FormatTags.TagSimple("obfuscated", TextFormatting.OBFUSCATED));
        this.textContainer.registerTag(new FormatTags.TagSimple("italic", TextFormatting.ITALIC));
        this.textContainer.registerTag(new FormatTags.TagSimple("strikethrough", TextFormatting.STRIKETHROUGH));
        this.textContainer.registerTag(new FormatTags.TagSimple("underline", TextFormatting.UNDERLINE));
        try {
            this.textContainer.parse();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeGround() {
        if (this.renderSomething) {
            if (this.items.size() > 0) {
                this.renderItem(this.xStart, this.yStart, this.items.get(this.currentItem), false, false, this.manual.manualType);
            } else if (this.aspect != null) {
                AspectIconRenderer.renderIcon(this.xStart, this.yStart, 16, 16, this.aspect.getIcon());
            } else if (this.resourceLocation != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.resourceLocation);
                this.manual.drawTexture(this.xStart, this.yStart, 16, 16, this.page.textureWidth, this.page.textureHeight, this.page.xStartTexture, this.page.xEndTexture, this.page.yStartTexture, this.page.yEndTexture);
            }
            this.color = this.isHidden ? 0x666666 : 0x808080;
            TextContainer.TextPage page = this.textContainer.getPages().get(0);
            page.render(this.xStart + 18, this.yStart + 2);
        }
    }

    @Override
    public void drawToolTip() {
        if (this.aspect != null && this.mouseX >= this.xStart && this.mouseX <= this.xStart + 16 && this.mouseY >= this.yStart && this.mouseY <= this.yStart + 16) {
            ArrayList<String> tooltipData = new ArrayList<String>();
            tooltipData.add(this.aspect.getName());
            tooltipData.add(TextFormatting.GRAY + this.aspect.getType());
            ButtonWidget.renderTooltip(this.mouseX, this.mouseY, tooltipData, 0xFFFFFF, -267386864);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (mouseButton == 2 && x >= this.xStart && x <= this.xStart + 16 && y >= this.yStart && y <= this.yStart + this.height) {
            this.currentItem = this.currentItem + 1 < this.items.size() ? ++this.currentItem : 0;
            this.drawForeGround();
            this.manual.untilUpdate = 0;
        } else if (mouseButton == 0 && x >= this.xStart && x <= this.xStart + this.width && y >= this.yStart && y <= this.yStart + this.height && !this.isHidden) {
            this.manual.changeTo(this.pageNumber, this.doMathWithIndexPages);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.manual.untilUpdate % 20 == 0) {
            this.currentItem = this.currentItem + 1 < this.items.size() ? ++this.currentItem : 0;
            this.drawForeGround();
        }
    }

    @Override
    public void resize() {
        super.resize();
        if (this.renderSomething) {
            this.textContainer = new TextContainer(84.0, 22.0, this.page.pageName, Minecraft.func_71410_x().field_71466_p);
            this.init();
        }
    }
}

