/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import thebetweenlands.common.herblore.book.HLEntryRegistry;
import thebetweenlands.common.herblore.book.ManualCategory;
import thebetweenlands.common.herblore.book.ManualManager;
import thebetweenlands.common.registries.ItemRegistry;

public class GuiManualHerblore
extends GuiScreen {
    private static ResourceLocation book = new ResourceLocation("thebetweenlands:textures/gui/manual/manual_hl.png");
    public int xStart;
    public int xStartRightPage;
    public int yStart;
    public int WIDTH = 292;
    public int HEIGHT = 180;
    public EntityPlayer player;
    public int untilUpdate = 0;
    public ManualCategory currentCategory;
    public Item manualType;
    private ItemStack manual;
    private EnumHand hand;

    public GuiManualHerblore(EntityPlayer player, ItemStack manual, EnumHand hand) {
        this.player = player;
        this.manual = manual;
        this.hand = hand;
    }

    public void func_73866_w_() {
        this.manualType = ItemRegistry.MANUAL_HL;
        this.xStart = this.field_146294_l / 2 - 146;
        this.xStartRightPage = this.xStart + 146;
        this.yStart = (this.field_146295_m - this.HEIGHT) / 2;
        this.untilUpdate = 0;
        HLEntryRegistry.CATEGORIES.forEach(manualCategory -> manualCategory.init(this, true));
        ManualCategory currCategory = ManualManager.getCurrentCategory(this.manual);
        int currPage = ManualManager.getCurrentPageNumber(this.manual);
        this.changeCategory(currCategory == null ? HLEntryRegistry.aspectCategory : currCategory, currPage == -1 ? 1 : currPage);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        ManualManager.setCurrentPage(this.currentCategory.getName(), this.currentCategory.getCurrentPage(), this.manualType, this.player, this.hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_73863_a(int mouseX, int mouseY, float renderPartials) {
        this.field_146297_k.field_71446_o.func_110577_a(book);
        this.drawTexture(this.xStart, this.yStart, this.WIDTH, this.HEIGHT, 1024.0, 1024.0, 0.0, 292.0, 0.0, 180.0);
        if (this.currentCategory != null) {
            if (this.currentCategory.getCurrentPage() - 2 >= 1) {
                if (mouseX >= this.xStart + 15 && mouseX <= this.xStart + 15 + 19 && mouseY >= this.yStart + 160 && mouseY <= this.yStart + 160 + 8) {
                    this.drawTexture(this.xStart + 15, this.yStart + 160, 19, 8, 1024.0, 1024.0, 292.0, 311.0, 9.0, 18.0);
                } else {
                    this.drawTexture(this.xStart + 15, this.yStart + 160, 19, 8, 1024.0, 1024.0, 292.0, 311.0, 0.0, 9.0);
                }
            }
            if (this.currentCategory.getCurrentPage() + 2 <= this.currentCategory.getVisiblePages().size()) {
                if (mouseX >= this.xStart + 256 && mouseX <= this.xStart + 256 + 19 && mouseY >= this.yStart + 160 && mouseY <= this.yStart + 160 + 8) {
                    this.drawTexture(this.xStart + 256, this.yStart + 160, 19, 8, 1024.0, 1024.0, 311.0, 330.0, 9.0, 18.0);
                } else {
                    this.drawTexture(this.xStart + 256, this.yStart + 160, 19, 8, 1024.0, 1024.0, 311.0, 330.0, 0.0, 9.0);
                }
            }
            this.drawTexture(this.xStart, this.yStart + 10, 14, 22 * this.currentCategory.getCategoryNumber(), 1024.0, 1024.0, 293.0, 306.0, 18.0, 18.0 + 22.0 * (double)this.currentCategory.getCategoryNumber());
            this.drawTexture(this.xStart + 279, this.yStart + 10 + 22 * this.currentCategory.getCategoryNumber(), 14, 44 - 22 * this.currentCategory.getCategoryNumber(), 1024.0, 1024.0, 306.0, 293.0, 18.0 + 22.0 * (double)this.currentCategory.getCategoryNumber(), 62.0);
            if (this.currentCategory.getCategoryNumber() == 2) {
                this.drawTexture(this.xStart, this.yStart + 33, 14, 20, 1024.0, 1024.0, 312.0, 325.0, 42.0, 62.0);
            } else {
                this.drawTexture(this.xStart + 278, this.yStart + 33, 14, 20, 1024.0, 1024.0, 315.0, 329.0, 42.0, 62.0);
            }
            this.drawTexture(this.xStart, this.yStart + 11, 14, 20, 1024.0, 1024.0, 312.0, 325.0, 20.0, 39.0);
            this.currentCategory.draw(mouseX, mouseY);
        }
        this.renderPageNumbers(mouseX, mouseY, renderPartials);
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        if (this.currentCategory != null) {
            if (mouseX >= this.xStart + 15 && mouseX <= this.xStart + 15 + 19 && mouseY >= this.yStart + 160 && mouseY <= this.yStart + 160 + 8 && button == 0) {
                this.currentCategory.previousPage(this);
            }
            if (mouseX >= this.xStart + 256 && mouseX <= this.xStart + 256 + 19 && mouseY >= this.yStart + 160 && mouseY <= this.yStart + 160 + 8 && button == 0) {
                this.currentCategory.nextPage(this);
            }
            if (mouseX >= this.xStart + (this.currentCategory.getCategoryNumber() >= 1 ? 0 : 279) && mouseX <= this.xStart + (this.currentCategory.getCategoryNumber() >= 1 ? 0 : 279) + 14 && mouseY >= this.yStart + 11 && mouseY <= this.yStart + 10 + 20 && button == 0) {
                this.changeCategory(HLEntryRegistry.aspectCategory);
            }
            if (mouseX >= this.xStart + (this.currentCategory.getCategoryNumber() >= 2 ? 0 : 279) && mouseX <= this.xStart + (this.currentCategory.getCategoryNumber() >= 2 ? 0 : 279) + 14 && mouseY >= this.yStart + 33 && mouseY <= this.yStart + 32 + 20 && button == 0) {
                this.changeCategory(HLEntryRegistry.elixirCategory);
            }
            this.currentCategory.mouseClicked(mouseX, mouseY, button);
        }
    }

    protected void renderPageNumbers(int mouseX, int mouseY, float partialTicks) {
        if (this.currentCategory != null) {
            int leftPageStrWidth = this.field_146289_q.func_78256_a(String.valueOf(this.currentCategory.getCurrentPage()));
            GlStateManager.func_179147_l();
            this.field_146289_q.func_78276_b(String.valueOf(this.currentCategory.getCurrentPage()), this.xStart + this.WIDTH / 2 - 11 - leftPageStrWidth, this.yStart + this.HEIGHT - 17, -2142289132);
            this.field_146289_q.func_78276_b(String.valueOf(this.currentCategory.getCurrentPage() + 1), this.xStart + this.WIDTH / 2 + 11, this.yStart + this.HEIGHT - 17, -2142289132);
        }
    }

    public void drawTexture(int xStart, int yStart, int width, int height, double textureWidth, double textureHeight, double textureXStart, double textureXEnd, double textureYStart, double textureYEnd) {
        double umin = 1.0 / textureWidth * textureXStart;
        double umax = 1.0 / textureWidth * textureXEnd;
        double vmin = 1.0 / textureHeight * textureYStart;
        double vmax = 1.0 / textureHeight * textureYEnd;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vetrexBuffer = tessellator.func_178180_c();
        vetrexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vetrexBuffer.func_181662_b((double)xStart, (double)yStart, (double)this.field_73735_i).func_187315_a(umin, vmin).func_181675_d();
        vetrexBuffer.func_181662_b((double)xStart, (double)(yStart + height), (double)this.field_73735_i).func_187315_a(umin, vmax).func_181675_d();
        vetrexBuffer.func_181662_b((double)(xStart + width), (double)(yStart + height), (double)this.field_73735_i).func_187315_a(umax, vmax).func_181675_d();
        vetrexBuffer.func_181662_b((double)(xStart + width), (double)yStart, (double)this.field_73735_i).func_187315_a(umax, vmin).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void func_73869_a(char c, int key) {
        switch (key) {
            case 1: {
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 14: {
                if (this.currentCategory == null) break;
                this.currentCategory.previousOpenPage(this);
            }
        }
        if (this.currentCategory != null) {
            GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
            if (key == gameSettings.field_74370_x.func_151463_i()) {
                this.currentCategory.previousPage(this);
            } else if (key == gameSettings.field_74366_z.func_151463_i()) {
                this.currentCategory.nextPage(this);
            }
            this.currentCategory.keyTyped(c, key);
        }
    }

    public void func_146274_d() {
        try {
            super.func_146274_d();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int mouseScroll = Mouse.getEventDWheel();
        if (mouseScroll != 0) {
            if (mouseScroll > 1) {
                this.currentCategory.nextPage(this);
            } else if (mouseScroll < -1) {
                this.currentCategory.previousPage(this);
            }
        }
    }

    public void changeTo(int pageNumber, boolean doMathWithIndexPages) {
        this.currentCategory.setPage(pageNumber + (doMathWithIndexPages ? this.currentCategory.getIndexPages() : 0), this);
    }

    public void changeCategory(ManualCategory category) {
        this.currentCategory = category;
        this.currentCategory.init(this, true);
        this.currentCategory.setPage(1, this);
    }

    public void changeCategory(ManualCategory category, int page) {
        this.currentCategory = category;
        this.currentCategory.init(this, false);
        this.currentCategory.setPage(page, this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_73876_c() {
        ++this.untilUpdate;
        if (this.currentCategory != null) {
            this.currentCategory.updateScreen();
        }
    }

    public boolean matches(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack2.func_77973_b() == itemStack1.func_77973_b() && itemStack2.func_77952_i() == itemStack1.func_77952_i();
    }
}

