/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class FlyingPathFinder
extends PathFinder {
    private final PathHeap path = new PathHeap();
    private final Set<PathPoint> closedSet = Sets.newHashSet();
    private final PathPoint[] pathOptions = new PathPoint[32];
    private final NodeProcessor nodeProcessor;

    public FlyingPathFinder(NodeProcessor processor) {
        super(processor);
        this.nodeProcessor = processor;
    }

    @Nullable
    public Path func_186333_a(IBlockAccess worldIn, EntityLiving entitylivingIn, Entity targetEntity, float maxDistance) {
        return this.findPath(worldIn, entitylivingIn, targetEntity.field_70165_t, targetEntity.func_174813_aQ().field_72338_b, targetEntity.field_70161_v, maxDistance);
    }

    @Nullable
    public Path func_186336_a(IBlockAccess worldIn, EntityLiving entitylivingIn, BlockPos targetPos, float maxDistance) {
        return this.findPath(worldIn, entitylivingIn, (float)targetPos.func_177958_n() + 0.5f, (float)targetPos.func_177956_o() + 0.5f, (float)targetPos.func_177952_p() + 0.5f, maxDistance);
    }

    @Nullable
    private Path findPath(IBlockAccess worldIn, EntityLiving entitylivingIn, double x, double y, double z, float maxDistance) {
        this.path.func_75848_a();
        this.nodeProcessor.func_186315_a(worldIn, entitylivingIn);
        PathPoint pathpoint = this.nodeProcessor.func_186318_b();
        PathPoint pathpoint1 = this.nodeProcessor.func_186325_a(x, y, z);
        Path path = this.findPath(pathpoint, pathpoint1, maxDistance);
        this.nodeProcessor.func_176163_a();
        return path;
    }

    @Nullable
    private Path findPath(PathPoint pathFrom, PathPoint pathTo, float maxDistance) {
        pathFrom.field_75836_e = 0.0f;
        pathFrom.field_75834_g = pathFrom.field_75833_f = pathFrom.func_186281_c(pathTo);
        this.path.func_75848_a();
        this.closedSet.clear();
        this.path.func_75849_a(pathFrom);
        PathPoint pathpoint = pathFrom;
        int i = 0;
        while (!this.path.func_75845_e() && ++i < 1000) {
            PathPoint pathpoint1 = this.path.func_75844_c();
            if (pathpoint1.equals((Object)pathTo)) {
                pathpoint = pathTo;
                break;
            }
            if (pathpoint1.func_186281_c(pathTo) < pathpoint.func_186281_c(pathTo)) {
                pathpoint = pathpoint1;
            }
            pathpoint1.field_75842_i = true;
            int j = this.nodeProcessor.func_186320_a(this.pathOptions, pathpoint1, pathTo, maxDistance);
            for (int k = 0; k < j; ++k) {
                PathPoint pathpoint2 = this.pathOptions[k];
                float f = pathpoint1.func_186281_c(pathpoint2);
                pathpoint2.field_186284_j = pathpoint1.field_186284_j + f;
                pathpoint2.field_186285_k = f + pathpoint2.field_186286_l;
                float f1 = pathpoint1.field_75836_e + pathpoint2.field_186285_k;
                if (!(pathpoint2.field_186284_j < maxDistance) || pathpoint2.func_75831_a() && !(f1 < pathpoint2.field_75836_e)) continue;
                pathpoint2.field_75841_h = pathpoint1;
                pathpoint2.field_75836_e = f1;
                pathpoint2.field_75833_f = pathpoint2.func_186281_c(pathTo) + pathpoint2.field_186286_l;
                if (pathpoint2.func_75831_a()) {
                    this.path.func_75850_a(pathpoint2, pathpoint2.field_75836_e + pathpoint2.field_75833_f);
                    continue;
                }
                pathpoint2.field_75834_g = pathpoint2.field_75836_e + pathpoint2.field_75833_f;
                this.path.func_75849_a(pathpoint2);
            }
        }
        if (pathpoint == pathFrom) {
            return null;
        }
        Path path = this.createPath(pathFrom, pathpoint);
        return path;
    }

    private Path createPath(PathPoint start, PathPoint end) {
        int i = 1;
        PathPoint pathpoint = end;
        while (pathpoint.field_75841_h != null) {
            ++i;
            pathpoint = pathpoint.field_75841_h;
        }
        PathPoint[] apathpoint = new PathPoint[i];
        PathPoint pathpoint1 = end;
        apathpoint[--i] = end;
        while (pathpoint1.field_75841_h != null) {
            pathpoint1 = pathpoint1.field_75841_h;
            apathpoint[--i] = pathpoint1;
        }
        return new Path(apathpoint);
    }
}

