/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class FlyingNodeProcessorBL
extends NodeProcessor {
    public int preferredMinHeight = -1;

    public FlyingNodeProcessorBL() {
        this.preferredMinHeight = -1;
    }

    public FlyingNodeProcessorBL(int preferredMinHeight) {
        this.preferredMinHeight = preferredMinHeight;
    }

    public PathPoint func_186318_b() {
        int startY = MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5));
        BlockPos blockpos1 = new BlockPos((Entity)this.field_186326_b);
        PathNodeType startNodeType = this.isFree(blockpos1.func_177958_n(), startY, blockpos1.func_177952_p());
        if (this.field_186326_b.func_184643_a(startNodeType) < 0.0f) {
            HashSet set = Sets.newHashSet();
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)startY, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)startY, this.field_186326_b.func_174813_aQ().field_72334_f));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)startY, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)startY, this.field_186326_b.func_174813_aQ().field_72334_f));
            for (BlockPos blockpos : set) {
                PathNodeType pathnodetype = this.isFree(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
                if (pathnodetype == PathNodeType.BLOCKED) continue;
                return this.func_176159_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            }
        }
        return this.func_176159_a(blockpos1.func_177958_n(), startY, blockpos1.func_177952_p());
    }

    public PathPoint func_186325_a(double x, double y, double z) {
        return this.func_176159_a(MathHelper.func_76128_c((double)(x - (double)(this.field_186326_b.field_70130_N / 2.0f))), MathHelper.func_76128_c((double)(y + 0.5)), MathHelper.func_76128_c((double)(z - (double)(this.field_186326_b.field_70130_N / 2.0f))));
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            PathPoint pathpoint = this.getAirNode(currentPoint.field_75839_a + enumfacing.func_82601_c(), currentPoint.field_75837_b + enumfacing.func_96559_d(), currentPoint.field_75838_c + enumfacing.func_82599_e(), targetPoint);
            if (pathpoint == null || pathpoint.field_75842_i || !(pathpoint.func_75829_a(targetPoint) < maxDistance)) continue;
            pathOptions[i++] = pathpoint;
        }
        return i;
    }

    public PathNodeType func_186319_a(IBlockAccess blockaccessIn, int x, int y, int z, EntityLiving entitylivingIn, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        return this.isFree(x, y, z);
    }

    public PathNodeType func_186330_a(IBlockAccess blockaccessIn, int x, int y, int z) {
        return this.isFree(x, y, z);
    }

    @Nullable
    private PathPoint getAirNode(int x, int y, int z, PathPoint targetPoint) {
        PathNodeType pathnodetype = this.isFree(x, y, z);
        if (pathnodetype == PathNodeType.OPEN) {
            PathPoint pathPoint = this.func_176159_a(x, y, z);
            if (this.preferredMinHeight > 0) {
                PathPoint cached;
                int height = 0;
                for (int yOff = 0; !(yOff > this.preferredMinHeight || (cached = (PathPoint)this.field_176167_b.func_76041_a(PathPoint.func_75830_a((int)x, (int)(y - yOff), (int)z))) != null && cached.field_75842_i && cached.field_186287_m == PathNodeType.BLOCKED || this.isFree(x, y - yOff, z) == PathNodeType.BLOCKED); ++yOff) {
                    ++height;
                }
                if (height <= this.preferredMinHeight && height > 0) {
                    double heightCostPenalty = ((double)height / (double)this.preferredMinHeight * 4.0 + 1.0) * 2.0 * Math.sqrt(MathHelper.func_151237_a((double)((double)(targetPoint.func_75829_a(pathPoint) - (float)height) / (double)height), (double)0.0, (double)1.0));
                    pathPoint.field_186286_l = (float)((double)pathPoint.field_186286_l + heightCostPenalty);
                }
            }
            return pathPoint;
        }
        return null;
    }

    private PathNodeType isFree(int x, int y, int z) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int i = x; i < x + this.field_176168_c; ++i) {
            for (int j = y; j < y + this.field_176165_d; ++j) {
                for (int k = z; k < z + this.field_176166_e; ++k) {
                    checkPos.func_181079_c(i, j, k);
                    IBlockState state = this.field_176169_a.func_180495_p((BlockPos)checkPos);
                    state = state.func_185899_b(this.field_176169_a, (BlockPos)checkPos);
                    ArrayList collidingAABBs = new ArrayList();
                    state.func_185908_a(this.field_186326_b.field_70170_p, (BlockPos)checkPos, new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + this.field_176168_c), (double)(y + this.field_176165_d), (double)(z + this.field_176166_e)), collidingAABBs, (Entity)this.field_186326_b, true);
                    if (collidingAABBs.isEmpty()) continue;
                    return PathNodeType.BLOCKED;
                }
            }
        }
        return PathNodeType.OPEN;
    }
}

