/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.equipment;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.inventory.InventoryEquipment;
import thebetweenlands.common.inventory.InventoryEquipmentAmulets;
import thebetweenlands.common.registries.CapabilityRegistry;

public class EquipmentEntityCapability
extends EntityCapability<EquipmentEntityCapability, IEquipmentCapability, EntityPlayer>
implements IEquipmentCapability,
ISerializableCapability {
    private Map<EnumEquipmentInventory, NonNullList<ItemStack>> allInventoryStacks = new EnumMap<EnumEquipmentInventory, NonNullList<ItemStack>>(EnumEquipmentInventory.class);
    private Map<EnumEquipmentInventory, IInventory> inventories = new EnumMap<EnumEquipmentInventory, IInventory>(EnumEquipmentInventory.class);
    private int amuletSlots = 1;

    public EquipmentEntityCapability() {
        for (EnumEquipmentInventory inventory : EnumEquipmentInventory.values()) {
            this.allInventoryStacks.put(inventory, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)inventory.maxSize, (Object)ItemStack.field_190927_a));
        }
    }

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "equipment");
    }

    @Override
    protected Capability<IEquipmentCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_EQUIPMENT;
    }

    @Override
    protected Class<IEquipmentCapability> getCapabilityClass() {
        return IEquipmentCapability.class;
    }

    @Override
    protected EquipmentEntityCapability getDefaultCapabilityImplementation() {
        return new EquipmentEntityCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityLivingBase;
    }

    @Override
    public boolean isPersistent(EntityPlayer oldPlayer, EntityPlayer newPlayer, boolean wasDead) {
        return !wasDead || ((EntityPlayer)this.getEntity()).field_70170_p.func_82736_K().func_82766_b("keepInventory");
    }

    @Override
    public IInventory getInventory(EnumEquipmentInventory inventoryType) {
        IInventory inventory = this.inventories.get((Object)inventoryType);
        if (inventory == null) {
            switch (inventoryType) {
                case AMULET: {
                    inventory = new InventoryEquipmentAmulets(this, this.allInventoryStacks.get((Object)inventoryType));
                    break;
                }
                default: {
                    inventory = new InventoryEquipment(this, this.allInventoryStacks.get((Object)inventoryType));
                }
            }
            this.inventories.put(inventoryType, inventory);
        }
        return inventory;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("amuletSlots", this.amuletSlots);
        NBTTagList inventoryList = new NBTTagList();
        for (EnumEquipmentInventory inventoryType : EnumEquipmentInventory.values()) {
            NonNullList<ItemStack> inventoryStacks = this.allInventoryStacks.get((Object)inventoryType);
            NBTTagCompound inventoryNbt = new NBTTagCompound();
            NBTTagList slotList = new NBTTagList();
            for (int c = 0; c < inventoryStacks.size(); ++c) {
                ItemStack stack = (ItemStack)inventoryStacks.get(c);
                if (stack.func_190926_b()) continue;
                NBTTagCompound slotNbt = new NBTTagCompound();
                slotNbt.func_74768_a("slot", c);
                slotNbt.func_74782_a("stack", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
                slotList.func_74742_a((NBTBase)slotNbt);
            }
            if (slotList.func_74745_c() <= 0) continue;
            inventoryNbt.func_74768_a("id", inventoryType.id);
            inventoryNbt.func_74782_a("items", (NBTBase)slotList);
            inventoryList.func_74742_a((NBTBase)inventoryNbt);
        }
        if (inventoryList.func_74745_c() > 0) {
            nbt.func_74782_a("inventories", (NBTBase)inventoryList);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.inventories.clear();
        for (EnumEquipmentInventory inventory : EnumEquipmentInventory.values()) {
            this.allInventoryStacks.put(inventory, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)inventory.maxSize, (Object)ItemStack.field_190927_a));
        }
        if (nbt.func_74764_b("amuletSlots")) {
            this.amuletSlots = nbt.func_74762_e("amuletSlots");
        }
        if (nbt.func_74764_b("inventories")) {
            NBTTagList inventoryList = nbt.func_150295_c("inventories", 10);
            for (int i = 0; i < inventoryList.func_74745_c(); ++i) {
                int id;
                EnumEquipmentInventory inventoryType;
                NBTTagCompound inventoryNbt = inventoryList.func_150305_b(i);
                if (!inventoryNbt.func_74764_b("items") || (inventoryType = EnumEquipmentInventory.fromID(id = inventoryNbt.func_74762_e("id"))) == null) continue;
                NonNullList<ItemStack> inventoryStacks = this.allInventoryStacks.get((Object)inventoryType);
                NBTTagList slotList = inventoryNbt.func_150295_c("items", 10);
                for (int c = 0; c < slotList.func_74745_c(); ++c) {
                    NBTTagCompound slotNbt = slotList.func_150305_b(c);
                    int slot = slotNbt.func_74762_e("slot");
                    if (slot >= inventoryStacks.size()) continue;
                    inventoryStacks.set(slot, (Object)new ItemStack(slotNbt.func_74775_l("stack")));
                }
            }
        }
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 10;
    }

    @Override
    public int getAmuletSlots() {
        return this.amuletSlots;
    }

    @Override
    public void setAmuletSlots(int slots) {
        this.amuletSlots = slots;
    }
}

