/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.block.BlockStateContainerHelper;
import thebetweenlands.common.block.terrain.BlockLogBetweenlands;

public class BlockHearthgroveLog
extends BlockLogBetweenlands {
    public static final PropertyBool TARRED = PropertyBool.func_177716_a((String)"tarred");

    public BlockHearthgroveLog() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TARRED, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        List<String> strings = ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.hearthgrove_log", (Object[])new Object[0]), 0);
        if (stack.func_77960_j() == 5 || stack.func_77960_j() == 7) {
            strings.remove(strings.size() - 1);
        }
        tooltip.addAll(strings);
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        IBlockState offsetState;
        BlockPos.PooledMutableBlockPos checkPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        boolean hasWater = false;
        for (EnumFacing offset : EnumFacing.field_176754_o) {
            float z;
            float y;
            float x;
            int i;
            offsetState = worldIn.func_180495_p((BlockPos)checkPos.func_181079_c(pos.func_177958_n() + offset.func_82601_c(), pos.func_177956_o(), pos.func_177952_p() + offset.func_82599_e()));
            IBlockState offsetStateDown = worldIn.func_180495_p((BlockPos)checkPos.func_181079_c(pos.func_177958_n() + offset.func_82601_c(), pos.func_177956_o() - 1, pos.func_177952_p() + offset.func_82599_e()));
            if (offsetStateDown.func_185904_a() == Material.field_151586_h && offsetState.func_185904_a() != Material.field_151586_h && rand.nextInt(8) == 0) {
                for (i = 0; i < 5; ++i) {
                    x = (float)pos.func_177958_n() + (offset.func_82601_c() > 0 ? 1.05f : (offset.func_82601_c() == 0 ? rand.nextFloat() : -0.05f));
                    y = (float)pos.func_177956_o() - 0.1f;
                    z = (float)pos.func_177952_p() + (offset.func_82599_e() > 0 ? 1.05f : (offset.func_82599_e() == 0 ? rand.nextFloat() : -0.05f));
                    BLParticles.PURIFIER_STEAM.spawn(worldIn, x, y, z);
                }
            }
            if (offsetState.func_185904_a() != Material.field_151586_h) continue;
            if (rand.nextInt(8) == 0) {
                for (i = 0; i < 5; ++i) {
                    x = (float)pos.func_177958_n() + (offset.func_82601_c() > 0 ? 1.1f : (offset.func_82601_c() == 0 ? rand.nextFloat() : -0.1f));
                    y = (float)pos.func_177956_o() + rand.nextFloat();
                    z = (float)pos.func_177952_p() + (offset.func_82599_e() > 0 ? 1.1f : (offset.func_82599_e() == 0 ? rand.nextFloat() : -0.1f));
                    worldIn.func_175688_a(EnumParticleTypes.WATER_BUBBLE, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            hasWater = true;
        }
        if (!hasWater) {
            block7: for (EnumFacing offset : EnumFacing.field_176754_o) {
                if (!(rand.nextFloat() < 0.04f)) continue;
                checkPos.func_181079_c(pos.func_177958_n() + offset.func_82601_c(), pos.func_177956_o(), pos.func_177952_p() + offset.func_82599_e());
                offsetState = worldIn.func_180495_p((BlockPos)checkPos);
                if (offsetState.isSideSolid((IBlockAccess)worldIn, (BlockPos)checkPos, offset.func_176734_d())) continue;
                float x = (float)pos.func_177958_n() + (offset.func_82601_c() > 0 ? 1.05f : (offset.func_82601_c() == 0 ? rand.nextFloat() : -0.05f));
                float y = (float)pos.func_177956_o() + rand.nextFloat();
                float z = (float)pos.func_177952_p() + (offset.func_82599_e() > 0 ? 1.05f : (offset.func_82599_e() == 0 ? rand.nextFloat() : -0.05f));
                switch (rand.nextInt(3)) {
                    default: {
                        BLParticles.EMBER_1.spawn(worldIn, x, y, z);
                        continue block7;
                    }
                    case 1: {
                        BLParticles.EMBER_2.spawn(worldIn, x, y, z);
                        continue block7;
                    }
                    case 2: {
                        BLParticles.EMBER_3.spawn(worldIn, x, y, z);
                    }
                }
            }
        }
        checkPos.func_185344_t();
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176203_a(meta);
        if (state.func_177229_b((IProperty)field_176299_a) != BlockLog.EnumAxis.NONE) {
            return state.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k()));
        }
        return state;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        BlockLog.EnumAxis axis;
        int axisIndex = meta & 3;
        switch (axisIndex) {
            default: {
                axis = BlockLog.EnumAxis.X;
                break;
            }
            case 1: {
                axis = BlockLog.EnumAxis.Y;
                break;
            }
            case 2: {
                axis = BlockLog.EnumAxis.Z;
                break;
            }
            case 3: {
                axis = BlockLog.EnumAxis.NONE;
            }
        }
        boolean tarred = meta >> 2 != 0;
        return this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)axis).func_177226_a((IProperty)TARRED, (Comparable)Boolean.valueOf(tarred));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = 0;
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)) {
            case X: {
                meta = 0;
                break;
            }
            case Y: {
                meta = 1;
                break;
            }
            case Z: {
                meta = 2;
                break;
            }
            case NONE: {
                meta = 3;
            }
        }
        return meta |= (Boolean)state.func_177229_b((IProperty)TARRED) != false ? 4 : 0;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return BlockStateContainerHelper.extendBlockstateContainer(super.func_180661_e(), new IProperty[]{TARRED});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)TARRED, (Comparable)Boolean.valueOf(false)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)TARRED, (Comparable)Boolean.valueOf(true)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a((IProperty)TARRED, (Comparable)Boolean.valueOf(false)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a((IProperty)TARRED, (Comparable)Boolean.valueOf(true)))));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        BlockLog.EnumAxis axis = (BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a);
        if (axis == BlockLog.EnumAxis.X || axis == BlockLog.EnumAxis.Z) {
            state = state.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
        }
        return this.func_176201_c(state);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.func_180643_i(state);
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.func_180643_i(state);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_180651_a(state));
    }

    @Override
    public int getSubtypeNumber() {
        return 4;
    }

    @Override
    public int getSubtypeMeta(int subtype) {
        switch (subtype) {
            default: {
                return this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)TARRED, (Comparable)Boolean.valueOf(false)));
            }
            case 1: {
                return this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)TARRED, (Comparable)Boolean.valueOf(true)));
            }
            case 2: {
                return this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a((IProperty)TARRED, (Comparable)Boolean.valueOf(false)));
            }
            case 3: 
        }
        return this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a((IProperty)TARRED, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public String getSubtypeName(int meta) {
        IBlockState state = this.func_176203_a(meta);
        String name = "%s";
        if (state.func_177229_b((IProperty)field_176299_a) == BlockLog.EnumAxis.NONE) {
            name = name + "_full";
        }
        if (((Boolean)state.func_177229_b((IProperty)TARRED)).booleanValue()) {
            name = name + "_tarred";
        }
        return name;
    }

    @Override
    public ItemBlock getItemBlock() {
        ItemBlock item = new ItemBlock((Block)this){

            public String func_77667_c(ItemStack stack) {
                IBlockState state = this.field_150939_a.func_176203_a(this.func_77647_b(stack.func_77952_i()));
                return this.field_150939_a.func_149739_a() + ((Boolean)state.func_177229_b((IProperty)TARRED) != false ? "_tarred" : "");
            }

            public int func_77647_b(int damage) {
                return damage;
            }
        };
        item.func_77627_a(true);
        return item;
    }
}

