/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IPortalCapability;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.block.structure.BlockPortalFrame;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationPortal;
import thebetweenlands.common.world.teleporter.TeleporterHandler;

public class BlockTreePortal
extends BasicBlock
implements BlockRegistry.ICustomItemBlock {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    protected static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockTreePortal() {
        super(Material.field_151567_E);
        this.func_149715_a(1.0f);
        this.func_149722_s();
        this.setSoundType2(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
        this.func_149647_a(null);
    }

    public static boolean makePortalX(World world, BlockPos pos) {
        world.func_175656_a(pos.func_177982_a(0, 2, -1), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.CORNER_TOP_RIGHT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177982_a(0, 2, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.TOP)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177982_a(0, 2, 1), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.CORNER_TOP_LEFT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177982_a(0, 1, -1), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.SIDE_RIGHT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177982_a(0, 1, 1), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.SIDE_LEFT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177982_a(0, 0, -1), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.SIDE_RIGHT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177982_a(0, 0, 1), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.SIDE_LEFT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177982_a(0, -1, -1), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.CORNER_BOTTOM_RIGHT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177982_a(0, -1, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.BOTTOM)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177982_a(0, -1, 1), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.CORNER_BOTTOM_LEFT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(true)));
        if (BlockTreePortal.isPatternValidX((IBlockAccess)world, pos)) {
            world.func_180501_a(pos, BlockRegistry.TREE_PORTAL.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z), 2);
            world.func_180501_a(pos.func_177984_a(), BlockRegistry.TREE_PORTAL.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z), 2);
            return true;
        }
        return false;
    }

    public static boolean makePortalZ(World world, BlockPos pos) {
        world.func_175656_a(pos.func_177982_a(-1, 2, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.CORNER_TOP_RIGHT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos.func_177982_a(0, 2, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.TOP)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos.func_177982_a(1, 2, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.CORNER_TOP_LEFT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos.func_177982_a(-1, 1, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.SIDE_RIGHT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos.func_177982_a(1, 1, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.SIDE_LEFT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos.func_177982_a(-1, 0, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.SIDE_RIGHT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos.func_177982_a(1, 0, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.SIDE_LEFT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos.func_177982_a(-1, -1, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.CORNER_BOTTOM_RIGHT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos.func_177982_a(0, -1, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.BOTTOM)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos.func_177982_a(1, -1, 0), BlockRegistry.PORTAL_FRAME.func_176223_P().func_177226_a(BlockPortalFrame.FRAME_POSITION, (Comparable)((Object)BlockPortalFrame.EnumPortalFrame.CORNER_BOTTOM_LEFT)).func_177226_a((IProperty)BlockPortalFrame.X_AXIS, (Comparable)Boolean.valueOf(false)));
        if (BlockTreePortal.isPatternValidZ((IBlockAccess)world, pos)) {
            world.func_180501_a(pos, BlockRegistry.TREE_PORTAL.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X), 2);
            world.func_180501_a(pos.func_177984_a(), BlockRegistry.TREE_PORTAL.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X), 2);
            return true;
        }
        return false;
    }

    public static boolean isPatternValidX(IBlockAccess world, BlockPos pos) {
        if (!BlockTreePortal.check(world, pos.func_177977_b(), BlockRegistry.PORTAL_FRAME) && !BlockTreePortal.checkPortal(world, pos.func_177977_b(), BlockRegistry.TREE_PORTAL, EnumFacing.Axis.Z)) {
            return false;
        }
        if (!BlockTreePortal.check(world, pos.func_177978_c(), BlockRegistry.PORTAL_FRAME)) {
            return false;
        }
        if (!BlockTreePortal.check(world, pos.func_177968_d(), BlockRegistry.PORTAL_FRAME)) {
            return false;
        }
        if (!BlockTreePortal.check(world, pos.func_177984_a().func_177978_c(), BlockRegistry.PORTAL_FRAME)) {
            return false;
        }
        if (!BlockTreePortal.check(world, pos.func_177984_a().func_177968_d(), BlockRegistry.PORTAL_FRAME)) {
            return false;
        }
        return BlockTreePortal.check(world, pos.func_177981_b(2), BlockRegistry.PORTAL_FRAME);
    }

    public static boolean isPatternValidZ(IBlockAccess world, BlockPos pos) {
        if (!BlockTreePortal.check(world, pos.func_177977_b(), BlockRegistry.PORTAL_FRAME) && !BlockTreePortal.checkPortal(world, pos.func_177977_b(), BlockRegistry.TREE_PORTAL, EnumFacing.Axis.X)) {
            return false;
        }
        if (!BlockTreePortal.check(world, pos.func_177976_e(), BlockRegistry.PORTAL_FRAME)) {
            return false;
        }
        if (!BlockTreePortal.check(world, pos.func_177974_f(), BlockRegistry.PORTAL_FRAME)) {
            return false;
        }
        if (!BlockTreePortal.check(world, pos.func_177984_a().func_177976_e(), BlockRegistry.PORTAL_FRAME)) {
            return false;
        }
        if (!BlockTreePortal.check(world, pos.func_177984_a().func_177974_f(), BlockRegistry.PORTAL_FRAME)) {
            return false;
        }
        return BlockTreePortal.check(world, pos.func_177981_b(2), BlockRegistry.PORTAL_FRAME);
    }

    private static boolean check(IBlockAccess world, BlockPos pos, Block target) {
        return world.func_180495_p(pos).func_177230_c() == target;
    }

    private static boolean checkPortal(IBlockAccess world, BlockPos pos, Block target, EnumFacing.Axis axis) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == target && state.func_177229_b(AXIS) == axis;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return X_AABB;
            }
            default: {
                return Y_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.canBlockStay(worldIn, pos);
    }

    protected boolean canBlockStay(World world, BlockPos pos) {
        if (BlockTreePortal.checkPortal((IBlockAccess)world, pos.func_177984_a(), BlockRegistry.TREE_PORTAL, EnumFacing.Axis.Z) && BlockTreePortal.isPatternValidX((IBlockAccess)world, pos)) {
            return true;
        }
        if (BlockTreePortal.checkPortal((IBlockAccess)world, pos.func_177977_b(), BlockRegistry.TREE_PORTAL, EnumFacing.Axis.Z) && BlockTreePortal.isPatternValidX((IBlockAccess)world, pos.func_177977_b())) {
            return true;
        }
        if (BlockTreePortal.checkPortal((IBlockAccess)world, pos.func_177984_a(), BlockRegistry.TREE_PORTAL, EnumFacing.Axis.X) && BlockTreePortal.isPatternValidZ((IBlockAccess)world, pos)) {
            return true;
        }
        if (BlockTreePortal.checkPortal((IBlockAccess)world, pos.func_177977_b(), BlockRegistry.TREE_PORTAL, EnumFacing.Axis.X) && BlockTreePortal.isPatternValidZ((IBlockAccess)world, pos.func_177977_b())) {
            return true;
        }
        world.func_180498_a(null, 2001, pos, Block.func_149682_b((Block)BlockRegistry.TREE_PORTAL));
        world.func_175698_g(pos);
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        return axis == EnumFacing.Axis.X ? 1 : (axis == EnumFacing.Axis.Z ? 2 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((meta & 3) == 2 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        AxisAlignedBB aabb;
        if (!entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.field_71088_bW <= 0 && BetweenlandsConfig.WORLD_AND_DIMENSION.portalDimensionWhitelistSet.isListed(entityIn.field_71093_bK) && (aabb = state.func_185900_c((IBlockAccess)worldIn, pos)) != null && aabb.func_186670_a(pos).func_72326_a(entityIn.func_174813_aQ())) {
            BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(worldIn);
            AxisAlignedBB entityAabb = entityIn.func_174813_aQ();
            List<LocationPortal> portals = worldStorage.getLocalStorageHandler().getLocalStorages(LocationPortal.class, entityAabb, loc -> loc.intersects(entityAabb));
            LocationPortal portal = null;
            if (!portals.isEmpty()) {
                portal = portals.get(0);
            }
            int targetDim = BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId;
            if (portal != null && (portal.getOtherPortalPosition() != null || portal.hasTargetDimension())) {
                targetDim = portal.getOtherPortalDimension();
            } else if (entityIn.field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
                targetDim = BetweenlandsConfig.WORLD_AND_DIMENSION.portalDefaultReturnDimension;
            }
            if (targetDim != entityIn.field_71093_bK) {
                if (entityIn.hasCapability(CapabilityRegistry.CAPABILITY_PORTAL, null)) {
                    IPortalCapability cap = (IPortalCapability)entityIn.getCapability(CapabilityRegistry.CAPABILITY_PORTAL, null);
                    cap.setInPortal(true);
                } else if (!worldIn.field_72995_K && worldIn instanceof WorldServer) {
                    WorldServer otherDim = ((WorldServer)worldIn).func_73046_m().func_71218_a(targetDim);
                    if (otherDim != null) {
                        TeleporterHandler.transferToDim(entityIn, (World)otherDim);
                    }
                    entityIn.field_71088_bW = entityIn.func_82147_ab();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN || side != EnumFacing.UP;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double particleX = (float)pos.func_177958_n() + rand.nextFloat();
            double particleY = (float)pos.func_177956_o() + rand.nextFloat();
            double particleZ = (float)pos.func_177952_p() + rand.nextFloat();
            float multi = (rand.nextFloat() * 2.0f - 1.0f) / 4.0f;
            double motionX = ((double)rand.nextFloat() - 0.5) * 0.25;
            double motionY = ((double)rand.nextFloat() - 0.5) * 0.25;
            double motionZ = ((double)rand.nextFloat() - 0.5) * 0.25;
            if (worldIn.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c() != this && worldIn.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c() != this) {
                particleX = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)multi;
                motionX = rand.nextFloat() * 2.0f * multi;
            } else {
                particleZ = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)multi;
                motionZ = rand.nextFloat() * 2.0f * multi;
            }
            BLParticles.PORTAL.spawn(worldIn, particleX, particleY, particleZ, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(motionX, motionY, motionZ));
        }
        if (rand.nextInt(20) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundEvent)SoundRegistry.PORTAL, SoundCategory.BLOCKS, 0.3f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(worldIn);
        List<LocationPortal> portals = worldStorage.getLocalStorageHandler().getLocalStorages(LocationPortal.class, new AxisAlignedBB(pos).func_72314_b(1.0, 1.0, 1.0), null);
        for (LocationPortal portal : portals) {
            portal.validateAndRemove();
        }
    }

    @Override
    public ItemBlock getItemBlock() {
        return null;
    }
}

