/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import thebetweenlands.client.render.model.baked.ModelCombined;
import thebetweenlands.client.render.model.baked.ModelFromModelBase;
import thebetweenlands.client.render.model.baked.ModelRubberTapLiquid;
import thebetweenlands.client.render.model.baked.modelbase.ModelRubberTap;

public class ModelRubberTapCombined
implements IModel {
    private final IModel tapModel;
    private final int height;
    private final ResourceLocation tapTexture;
    private final ResourceLocation particleTexture;
    private final ResourceLocation fluidTexture;

    public ModelRubberTapCombined(ResourceLocation texture) {
        this(texture, texture, null, 0);
    }

    public ModelRubberTapCombined(ResourceLocation texture, ResourceLocation particleTexture, ResourceLocation fluidTexture, int height) {
        this.tapModel = new ModelCombined(new ModelFromModelBase((ModelBase)new ModelRubberTap(), texture, particleTexture, 128, 128), new ModelRubberTapLiquid(fluidTexture, height));
        this.tapTexture = texture;
        this.particleTexture = particleTexture;
        this.height = height;
        this.fluidTexture = fluidTexture;
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.tapModel.getDependencies();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.tapModel.getTextures();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return this.tapModel.bake(state, format, bakedTextureGetter);
    }

    public IModelState getDefaultState() {
        return this.tapModel.getDefaultState();
    }

    public ModelRubberTapCombined process(ImmutableMap<String, String> customData) {
        JsonParser parser = new JsonParser();
        ResourceLocation fluidTexture = this.fluidTexture;
        if (customData.containsKey((Object)"fluid_texture")) {
            fluidTexture = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"fluid_texture")), (String)"fluid_texture"));
        }
        if (fluidTexture == null) {
            fluidTexture = TextureMap.field_174945_f;
        }
        int height = this.height;
        if (customData.containsKey((Object)"fluid_height")) {
            String fluidHeightJsonStr = (String)customData.get((Object)"fluid_height");
            height = JsonUtils.func_151215_f((JsonElement)parser.parse(fluidHeightJsonStr), (String)"fluid_height");
        }
        ResourceLocation particleTexture = this.particleTexture;
        if (customData.containsKey((Object)"particle_texture")) {
            String particleTextureJsonStr = (String)customData.get((Object)"particle_texture");
            particleTexture = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse(particleTextureJsonStr), (String)"particle_texture"));
        }
        return new ModelRubberTapCombined(this.tapTexture, particleTexture, fluidTexture, height);
    }
}

