/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.entity.EntityRootGrabber;

@SideOnly(value=Side.CLIENT)
public class RenderRootGrabber
extends Render<EntityRootGrabber> {
    protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/blocks/destroy_stage_0.png"), new ResourceLocation("textures/blocks/destroy_stage_1.png"), new ResourceLocation("textures/blocks/destroy_stage_2.png"), new ResourceLocation("textures/blocks/destroy_stage_3.png"), new ResourceLocation("textures/blocks/destroy_stage_4.png"), new ResourceLocation("textures/blocks/destroy_stage_5.png"), new ResourceLocation("textures/blocks/destroy_stage_6.png"), new ResourceLocation("textures/blocks/destroy_stage_7.png"), new ResourceLocation("textures/blocks/destroy_stage_8.png"), new ResourceLocation("textures/blocks/destroy_stage_9.png")};

    public RenderRootGrabber(RenderManager rendermanagerIn) {
        super(rendermanagerIn);
    }

    public void doRender(EntityRootGrabber entity, double x, double y, double z, float yaw, float partialTicks) {
        this.renderRoots(entity, x, y, z, yaw, partialTicks);
    }

    public void renderRoots(EntityRootGrabber entity, double x, double y, double z, float yaw, float partialTicks) {
        entity.initRootModels();
        if (entity.modelParts != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)x, (double)(y + 1.0), (double)z);
            for (EntityRootGrabber.RootPart part : entity.modelParts) {
                GlStateManager.func_179094_E();
                this.func_180548_c(entity);
                GlStateManager.func_179109_b((float)part.x, (float)part.y, (float)part.z);
                GlStateManager.func_179114_b((float)(part.yaw - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)part.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)entity.getRootYOffset(partialTicks), (float)0.0f);
                float animationTicks = (float)entity.field_70173_aa + partialTicks;
                GlStateManager.func_179114_b((float)((float)Math.cos(animationTicks / 4.0f) * 0.5f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)((float)Math.sin(animationTicks / 5.0f) * 0.8f), (float)1.0f, (float)0.0f, (float)0.0f);
                part.renderer.render();
                int damage = MathHelper.func_76123_f((float)(entity.getDamage() * 10.0f));
                if (damage > 0 && damage <= 10) {
                    this.func_110776_a(DESTROY_STAGES[damage - 1]);
                    TextureAtlasSprite sprite = part.renderer.getSprite();
                    this.preRenderDamagedBlocks();
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179096_D();
                    GlStateManager.func_179152_a((float)(1.0f / (sprite.func_94212_f() - sprite.func_94209_e())), (float)(1.0f / (sprite.func_94210_h() - sprite.func_94206_g())), (float)0.0f);
                    GlStateManager.func_179109_b((float)(-sprite.func_94209_e()), (float)(-sprite.func_94206_g()), (float)0.0f);
                    GlStateManager.func_179128_n((int)5888);
                    part.renderer.render();
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179128_n((int)5888);
                    this.postRenderDamagedBlocks();
                }
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }

    private void preRenderDamagedBlocks() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
    }

    private void postRenderDamagedBlocks() {
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected ResourceLocation getEntityTexture(EntityRootGrabber entity) {
        return TextureMap.field_110575_b;
    }
}

