/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.openal.AL10;
import paulscode.sound.Library;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.Source;
import paulscode.sound.libraries.ChannelLWJGLOpenAL;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;
import paulscode.sound.libraries.SourceLWJGLOpenAL;

public class SoundSystemOpenALAccess {
    private static final AtomicInteger ACCESS_THREAD_ID = new AtomicInteger(0);
    private static final Logger LOGGER = LogManager.getLogger();
    private static Field fieldSoundLibrary;
    private static Field fieldSourceMap;
    private static Field fieldChannelOpenAL;
    private volatile boolean initialized = false;
    private SoundManager soundManager;
    private LibraryLWJGLOpenAL library;
    private ExecutorService service;
    private boolean errored = false;

    public synchronized void init(SoundManager soundManager) {
        this.cleanup();
        this.errored = true;
        if (fieldSoundLibrary != null && fieldSourceMap != null && fieldChannelOpenAL != null) {
            try {
                Library library = (Library)fieldSoundLibrary.get(soundManager.field_148620_e);
                if (library instanceof LibraryLWJGLOpenAL) {
                    this.library = (LibraryLWJGLOpenAL)library;
                    this.soundManager = soundManager;
                    this.service = Executors.newFixedThreadPool(1, task -> {
                        Thread thread = new Thread(task);
                        thread.setDaemon(true);
                        thread.setName("Betweenlands Sound System Access #" + ACCESS_THREAD_ID.getAndIncrement());
                        return thread;
                    });
                    this.errored = false;
                    this.initialized = true;
                } else {
                    LOGGER.info("Sound library is not OpenAL library");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                LOGGER.error("Failed accessing 'soundLibrary' field of SoundSystem", (Throwable)ex);
            }
        }
    }

    public synchronized void cleanup() {
        this.errored = false;
        this.initialized = false;
        this.library = null;
        this.soundManager = null;
        if (this.service != null) {
            this.service.shutdownNow();
            this.service = null;
        }
    }

    @Nullable
    public synchronized <T> Future<T> submitToSoundSystem(Callable<T> task) {
        return this.service != null ? this.service.submit(() -> {
            SoundSystemOpenALAccess soundSystemOpenALAccess = this;
            synchronized (soundSystemOpenALAccess) {
                Object object = SoundSystemConfig.THREAD_SYNC;
                synchronized (object) {
                    return task.call();
                }
            }
        }) : null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isErrored() {
        return this.errored;
    }

    @Nullable
    public SourceLWJGLOpenAL getSourceAsync(ISound sound) throws OpenALAccessInitException {
        if (!this.initialized) {
            return null;
        }
        try {
            Source source;
            String sourceName = (String)this.soundManager.field_148630_i.get(sound);
            if (sourceName != null && (source = (Source)((Map)fieldSourceMap.get(this.library)).get(sourceName)) instanceof SourceLWJGLOpenAL) {
                return (SourceLWJGLOpenAL)source;
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            this.initialized = false;
            this.errored = true;
            throw new OpenALAccessInitException("Failed retrieving SourceLWJGLOpenAL from sound system", ex);
        }
    }

    @Nullable
    public ChannelLWJGLOpenAL getChannelAsync(ISound sound) {
        try {
            SourceLWJGLOpenAL source = this.getSourceAsync(sound);
            if (source != null && source.channel instanceof ChannelLWJGLOpenAL) {
                return (ChannelLWJGLOpenAL)source.channel;
            }
        }
        catch (OpenALAccessInitException ex) {
            LOGGER.info("Failed retrieving OpenAL channel", (Throwable)ex);
        }
        return null;
    }

    public boolean setOffsetSecondsAsync(ISound sound, float seconds) {
        int sourceId;
        ChannelLWJGLOpenAL channel = this.getChannelAsync(sound);
        if (channel != null && channel.ALSource != null && channel.attachedSource != null && (sourceId = channel.ALSource.get(0)) >= 0) {
            AL10.alSourcef((int)sourceId, (int)4132, (float)seconds);
            return true;
        }
        return false;
    }

    public float getOffsetSecondsAsync(ISound sound) {
        int sourceId;
        ChannelLWJGLOpenAL channel = this.getChannelAsync(sound);
        if (channel != null && channel.ALSource != null && (sourceId = channel.ALSource.get(0)) >= 0) {
            return AL10.alGetSourcef((int)sourceId, (int)4132);
        }
        return -1.0f;
    }

    @Nullable
    public Future<Boolean> setOffsetSeconds(ISound sound, float seconds) {
        return this.submitToSoundSystem(() -> this.setOffsetSecondsAsync(sound, seconds));
    }

    @Nullable
    public Future<Float> getOffsetSeconds(ISound sound) {
        return this.submitToSoundSystem(() -> Float.valueOf(this.getOffsetSecondsAsync(sound)));
    }

    static {
        try {
            fieldSoundLibrary = SoundSystem.class.getDeclaredField("soundLibrary");
            fieldSoundLibrary.setAccessible(true);
        }
        catch (Exception ex) {
            LOGGER.error("Failed retrieving 'soundLibrary' field from SoundSystem", (Throwable)ex);
        }
        try {
            fieldSourceMap = Library.class.getDeclaredField("sourceMap");
            fieldSourceMap.setAccessible(true);
        }
        catch (Exception ex) {
            LOGGER.error("Failed retrieving 'sourceMap' field from Library", (Throwable)ex);
        }
        try {
            fieldChannelOpenAL = SourceLWJGLOpenAL.class.getDeclaredField("channelOpenAL");
            fieldChannelOpenAL.setAccessible(true);
        }
        catch (Exception ex) {
            LOGGER.error("Failed retrieving 'channelOpenAL' field from SourceLWJGLOpenAL", (Throwable)ex);
        }
    }

    public static final class OpenALAccessInitException
    extends Exception {
        private static final long serialVersionUID = -8924694992857474053L;

        private OpenALAccessInitException(String msg, Throwable ex) {
            super(msg, ex);
        }
    }
}

