/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.storage;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.network.IGenericDataManagerAccess;
import thebetweenlands.api.storage.IChunkStorage;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.LocalStorageReference;
import thebetweenlands.api.storage.StorageID;

public interface ILocalStorage
extends ICapabilityProvider {
    public IWorldStorage getWorldStorage();

    @Nullable
    public AxisAlignedBB getBoundingBox();

    public boolean isLoaded();

    public StorageID getID();

    @Nullable
    public LocalRegion getRegion();

    public void readFromNBT(NBTTagCompound var1);

    public NBTTagCompound writeToNBT(NBTTagCompound var1);

    public void readInitialPacket(NBTTagCompound var1);

    public NBTTagCompound writeInitialPacket(NBTTagCompound var1);

    public void markDirty();

    public void setDirty(boolean var1);

    public boolean isDirty();

    public List<ChunkPos> getLinkedChunks();

    @SideOnly(value=Side.CLIENT)
    public void setLinkedChunks(List<ChunkPos> var1);

    public void onLoaded();

    public void onUnloaded();

    public void onRemoved();

    public Collection<LocalStorageReference> getLoadedReferences();

    public boolean loadReference(LocalStorageReference var1);

    public boolean unloadReference(LocalStorageReference var1);

    public boolean addWatcher(IChunkStorage var1, EntityPlayerMP var2);

    public boolean removeWatcher(IChunkStorage var1, EntityPlayerMP var2);

    public Collection<EntityPlayerMP> getWatchers();

    public boolean unlinkAllChunks();

    public boolean linkChunk(Chunk var1);

    public boolean unlinkChunk(Chunk var1);

    @Nullable
    public IGenericDataManagerAccess getDataManager();
}

