/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.nbt;

import com.google.common.base.Optional;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class NBTHelper {
    @Nonnull
    public static NBTTagCompound getPersistentData(Entity entity) {
        return NBTHelper.getPersistentData(entity.getEntityData());
    }

    @Nonnull
    public static NBTTagCompound getPersistentData(ItemStack item) {
        return NBTHelper.getPersistentData(NBTHelper.getData(item));
    }

    @Nonnull
    public static NBTTagCompound getPersistentData(NBTTagCompound base) {
        NBTTagCompound compound;
        if (NBTHelper.hasPersistentData(base)) {
            compound = base.func_74775_l("astralsorcery");
        } else {
            compound = new NBTTagCompound();
            base.func_74782_a("astralsorcery", (NBTBase)compound);
        }
        return compound;
    }

    public static boolean hasPersistentData(Entity entity) {
        return NBTHelper.hasPersistentData(entity.getEntityData());
    }

    public static boolean hasPersistentData(ItemStack item) {
        return item.func_77978_p() != null && NBTHelper.hasPersistentData(item.func_77978_p());
    }

    public static boolean hasPersistentData(NBTTagCompound base) {
        return base.func_74764_b("astralsorcery") && base.func_74781_a("astralsorcery") instanceof NBTTagCompound;
    }

    public static void removePersistentData(Entity entity) {
        NBTHelper.removePersistentData(entity.getEntityData());
    }

    public static void removePersistentData(ItemStack item) {
        if (item.func_77942_o()) {
            NBTHelper.removePersistentData(item.func_77978_p());
        }
    }

    public static void removePersistentData(NBTTagCompound base) {
        base.func_82580_o("astralsorcery");
    }

    public static NBTTagCompound getData(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        return compound;
    }

    public static void setBlockState(NBTTagCompound cmp, String key, IBlockState state) {
        NBTTagCompound serialized = NBTHelper.getBlockStateNBTTag(state);
        if (serialized != null) {
            cmp.func_74782_a(key, (NBTBase)serialized);
        }
    }

    @Nullable
    public static IBlockState getBlockState(NBTTagCompound cmp, String key) {
        return NBTHelper.getBlockStateFromTag(cmp.func_74775_l(key));
    }

    @Nonnull
    public static NBTTagCompound getBlockStateNBTTag(IBlockState state) {
        if (state.func_177230_c().getRegistryName() == null) {
            state = Blocks.field_150350_a.func_176223_P();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("registryName", state.func_177230_c().getRegistryName().toString());
        NBTTagList properties = new NBTTagList();
        for (IProperty property : state.func_177227_a()) {
            NBTTagCompound propTag = new NBTTagCompound();
            try {
                propTag.func_74778_a("value", property.func_177702_a(state.func_177229_b(property)));
            }
            catch (Exception exc) {
                continue;
            }
            propTag.func_74778_a("property", property.func_177701_a());
            properties.func_74742_a((NBTBase)propTag);
        }
        tag.func_74782_a("properties", (NBTBase)properties);
        return tag;
    }

    @Nullable
    public static <T extends Comparable<T>> IBlockState getBlockStateFromTag(NBTTagCompound cmp) {
        return NBTHelper.getBlockStateFromTag(cmp, null);
    }

    @Nullable
    public static <T extends Comparable<T>> IBlockState getBlockStateFromTag(NBTTagCompound cmp, IBlockState _default) {
        ResourceLocation key = new ResourceLocation(cmp.func_74779_i("registryName"));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
        if (block == null || block == Blocks.field_150350_a) {
            return _default;
        }
        IBlockState state = block.func_176223_P();
        Collection properties = state.func_177227_a();
        NBTTagList list = cmp.func_150295_c("properties", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound propertyTag = list.func_150305_b(i);
            String valueStr = propertyTag.func_74779_i("value");
            String propertyStr = propertyTag.func_74779_i("property");
            IProperty match = MiscUtils.iterativeSearch(properties, prop -> prop.func_177701_a().equalsIgnoreCase(propertyStr));
            if (match == null) continue;
            try {
                Optional opt = match.func_185929_b(valueStr);
                if (!opt.isPresent()) continue;
                state = state.func_177226_a(match, (Comparable)opt.get());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return state;
    }

    public static void setStack(NBTTagCompound compound, String tag, ItemStack stack) {
        NBTTagCompound stackCompound = new NBTTagCompound();
        stack.func_77955_b(stackCompound);
        compound.func_74782_a(tag, (NBTBase)stackCompound);
    }

    public static void removeUUID(NBTTagCompound compound, String key) {
        compound.func_82580_o(key + "Most");
        compound.func_82580_o(key + "Least");
    }

    public static ItemStack getStack(NBTTagCompound compound, String tag) {
        return NBTHelper.getStack(compound, tag, ItemStack.field_190927_a);
    }

    public static ItemStack getStack(NBTTagCompound compound, String tag, ItemStack defaultValue) {
        if (compound.func_74764_b(tag)) {
            return new ItemStack(compound.func_74775_l(tag));
        }
        return defaultValue;
    }

    public static boolean getBoolean(NBTTagCompound compound, String tag, boolean defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74767_n(tag) : defaultValue;
    }

    public static String getString(NBTTagCompound compound, String tag, String defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74779_i(tag) : defaultValue;
    }

    public static int getInteger(NBTTagCompound compound, String tag, int defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74762_e(tag) : defaultValue;
    }

    public static double getDouble(NBTTagCompound compound, String tag, double defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74769_h(tag) : defaultValue;
    }

    public static float getFloat(NBTTagCompound compound, String tag, float defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74760_g(tag) : defaultValue;
    }

    public static byte getByte(NBTTagCompound compound, String tag, byte defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74771_c(tag) : defaultValue;
    }

    public static short getShort(NBTTagCompound compound, String tag, short defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74765_d(tag) : defaultValue;
    }

    public static long getLong(NBTTagCompound compound, String tag, long defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74763_f(tag) : defaultValue;
    }

    public static void writeBlockPosToNBT(BlockPos pos, NBTTagCompound compound) {
        compound.func_74768_a("bposX", pos.func_177958_n());
        compound.func_74768_a("bposY", pos.func_177956_o());
        compound.func_74768_a("bposZ", pos.func_177952_p());
    }

    public static BlockPos readBlockPosFromNBT(NBTTagCompound compound) {
        int x = compound.func_74762_e("bposX");
        int y = compound.func_74762_e("bposY");
        int z = compound.func_74762_e("bposZ");
        return new BlockPos(x, y, z);
    }

    public static NBTTagCompound writeVector3(Vector3 v) {
        NBTTagCompound cmp = new NBTTagCompound();
        NBTHelper.writeVector3(v, cmp);
        return cmp;
    }

    public static void writeVector3(Vector3 v, NBTTagCompound compound) {
        compound.func_74780_a("vecPosX", v.getX());
        compound.func_74780_a("vecPosY", v.getY());
        compound.func_74780_a("vecPosZ", v.getZ());
    }

    public static Vector3 readVector3(NBTTagCompound compound) {
        return new Vector3(compound.func_74769_h("vecPosX"), compound.func_74769_h("vecPosY"), compound.func_74769_h("vecPosZ"));
    }

    public static void writeBoundingBox(AxisAlignedBB box, NBTTagCompound tag) {
        tag.func_74780_a("boxMinX", box.field_72340_a);
        tag.func_74780_a("boxMinY", box.field_72338_b);
        tag.func_74780_a("boxMinZ", box.field_72339_c);
        tag.func_74780_a("boxMaxX", box.field_72336_d);
        tag.func_74780_a("boxMaxY", box.field_72337_e);
        tag.func_74780_a("boxMaxZ", box.field_72334_f);
    }

    public static AxisAlignedBB readBoundingBox(NBTTagCompound tag) {
        return new AxisAlignedBB(tag.func_74769_h("boxMinX"), tag.func_74769_h("boxMinY"), tag.func_74769_h("boxMinZ"), tag.func_74769_h("boxMaxX"), tag.func_74769_h("boxMaxY"), tag.func_74769_h("boxMaxZ"));
    }
}

