/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.structure.change;

import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.StructureMatchingBuffer;
import hellfirepvp.astralsorcery.common.event.BlockModifyEvent;
import hellfirepvp.astralsorcery.common.structure.BlockStructureObserver;
import hellfirepvp.astralsorcery.common.structure.change.ChangeSubscriber;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class StructureIntegrityObserver {
    public static final StructureIntegrityObserver INSTANCE = new StructureIntegrityObserver();

    private StructureIntegrityObserver() {
    }

    @SubscribeEvent
    public void onChange(BlockModifyEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K || !event.getChunk().func_177419_t()) {
            return;
        }
        StructureMatchingBuffer buf = (StructureMatchingBuffer)WorldCacheManager.getOrLoadData(world, WorldCacheManager.SaveKey.STRUCTURE_MATCH);
        ChunkPos ch = event.getChunk().func_76632_l();
        BlockPos pos = event.getPos();
        IBlockState oldS = event.getOldState();
        IBlockState newS = event.getNewState();
        List<ChangeSubscriber<?>> subscribers = buf.getSubscribers(ch);
        for (ChangeSubscriber<?> subscriber : subscribers) {
            if (!subscriber.observes(pos)) continue;
            subscriber.addChange(pos, oldS, newS);
            buf.markDirty();
        }
        if (oldS.func_177230_c() instanceof BlockStructureObserver && ((BlockStructureObserver)oldS.func_177230_c()).removeWithNewState((IBlockAccess)world, pos, oldS, newS)) {
            buf.removeSubscriber(pos);
        }
    }
}

