/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationCrafttweaker;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.BaseTweaker;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.AltarRecipeAttunement;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.AltarRecipeConstellation;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.AltarRecipeDiscovery;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.AltarRecipeRemove;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.AltarRecipeTrait;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.astralsorcery.Altar")
public class AltarRecipe
extends BaseTweaker {
    protected static final String name = "AstralSorcery Altar Crafting";
    public static int SLOT_COUNT_T1 = 9;
    public static int SLOT_COUNT_T2 = 13;
    public static int SLOT_COUNT_T3 = 21;
    public static int SLOT_COUNT_T4 = 25;

    @ZenMethod
    public static void removeAltarRecipe(String recipeRegistryName) {
        ModIntegrationCrafttweaker.recipeModifications.add(new AltarRecipeRemove(recipeRegistryName));
    }

    @ZenMethod
    @Deprecated
    public static void removeAltarRecipe(IItemStack output, int altarLevel) {
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Using deprecated 'removeAltarRecipe'! Use the new method to remove recipes by their registry-name!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Enable the F3-Debug screen and hover over the receipe output of an altar recipe to see existing ones!");
        ItemStack out = AltarRecipe.convertToItemStack(output);
        if (out.func_190926_b()) {
            CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Skipping recipe-removal due to invalid output.");
            return;
        }
        if (altarLevel < 0 || altarLevel >= TileAltar.AltarLevel.values().length) {
            CraftTweakerAPI.logError((String)("[AstralSorcery Altar Crafting] Skipping recipe-removal - No altar level with index " + altarLevel));
            return;
        }
        TileAltar.AltarLevel al = TileAltar.AltarLevel.values()[altarLevel];
        ModIntegrationCrafttweaker.recipeModifications.add(new AltarRecipeRemove(out, al));
    }

    @ZenMethod
    public static void addDiscoveryAltarRecipe(String recipeRegistryName, IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs) {
        if (!AltarRecipe.matchNeededSlots(inputs, TileAltar.AltarLevel.DISCOVERY)) {
            return;
        }
        ItemStack out = AltarRecipe.convertToItemStack(output);
        if (out.func_190926_b()) {
            CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Skipping recipe-addition due to invalid output itemstack.");
            return;
        }
        ItemHandle[] handles = new ItemHandle[SLOT_COUNT_T1];
        for (int i = 0; i < SLOT_COUNT_T1; ++i) {
            handles[i] = AltarRecipe.convertToHandle(inputs[i]);
        }
        ModIntegrationCrafttweaker.recipeModifications.add(new AltarRecipeDiscovery(recipeRegistryName, handles, out, starlightRequired, craftingTickTime));
    }

    @ZenMethod
    @Deprecated
    public static void addDiscoveryAltarRecipe(IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs) {
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Using deprecated 'addDiscoveryAltarRecipe'! Use the new method with an additional registry-name parameter!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Enable the F3-Debug screen and hover over the receipe output of an altar recipe to see existing ones!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Should you try to replace an existing crafting recipe, make sure you use the same recipe name!");
        AltarRecipe.addDiscoveryAltarRecipe("ct/null", output, starlightRequired, craftingTickTime, inputs);
    }

    @ZenMethod
    public static void addAttunementAltarRecipe(String recipeRegistryName, IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs) {
        if (!AltarRecipe.matchNeededSlots(inputs, TileAltar.AltarLevel.ATTUNEMENT)) {
            return;
        }
        ItemStack out = AltarRecipe.convertToItemStack(output);
        if (out.func_190926_b()) {
            CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Skipping recipe-addition due to invalid output itemstack.");
            return;
        }
        ItemHandle[] handles = new ItemHandle[SLOT_COUNT_T2];
        for (int i = 0; i < SLOT_COUNT_T2; ++i) {
            handles[i] = AltarRecipe.convertToHandle(inputs[i]);
        }
        ModIntegrationCrafttweaker.recipeModifications.add(new AltarRecipeAttunement(recipeRegistryName, handles, out, starlightRequired, craftingTickTime));
    }

    @ZenMethod
    @Deprecated
    public static void addAttunmentAltarRecipe(String recipeRegistryName, IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs) {
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Using deprecated 'addAttunmentAltarRecipe' with the TYPO! This method will be removed in an upcoming update!");
        AltarRecipe.addAttunementAltarRecipe(recipeRegistryName, output, starlightRequired, craftingTickTime, inputs);
    }

    @ZenMethod
    @Deprecated
    public static void addAttunementAltarRecipe(IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs) {
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Using deprecated 'addAttunementAltarRecipe'! Use the new method with an additional registry-name parameter!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Enable the F3-Debug screen and hover over the receipe output of an altar recipe to see existing ones!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Should you try to replace an existing crafting recipe, make sure you use the same recipe name!");
        AltarRecipe.addAttunmentAltarRecipe("ct/null", output, starlightRequired, craftingTickTime, inputs);
    }

    @ZenMethod
    @Deprecated
    public static void addAttunmentAltarRecipe(IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs) {
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Using deprecated 'addAttunmentAltarRecipe'! Use the new method with an additional registry-name parameter!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Enable the F3-Debug screen and hover over the receipe output of an altar recipe to see existing ones!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Using deprecated 'addAttunmentAltarRecipe' with the TYPO! This method will be removed in an upcoming update!");
        AltarRecipe.addAttunementAltarRecipe(output, starlightRequired, craftingTickTime, inputs);
    }

    @ZenMethod
    public static void addConstellationAltarRecipe(String recipeRegistryName, IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs) {
        if (!AltarRecipe.matchNeededSlots(inputs, TileAltar.AltarLevel.CONSTELLATION_CRAFT)) {
            return;
        }
        ItemStack out = AltarRecipe.convertToItemStack(output);
        if (out.func_190926_b()) {
            CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Skipping recipe-addition due to invalid output itemstack.");
            return;
        }
        ItemHandle[] handles = new ItemHandle[SLOT_COUNT_T3];
        for (int i = 0; i < SLOT_COUNT_T3; ++i) {
            handles[i] = AltarRecipe.convertToHandle(inputs[i]);
        }
        ModIntegrationCrafttweaker.recipeModifications.add(new AltarRecipeConstellation(recipeRegistryName, handles, out, starlightRequired, craftingTickTime));
    }

    @ZenMethod
    @Deprecated
    public static void addConstellationAltarRecipe(IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs) {
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Using deprecated 'addConstellationAltarRecipe'! Use the new method with an additional registry-name parameter!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Enable the F3-Debug screen and hover over the receipe output of an altar recipe to see existing ones!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Should you try to replace an existing crafting recipe, make sure you use the same recipe name!");
        AltarRecipe.addConstellationAltarRecipe("ct/null", output, starlightRequired, craftingTickTime, inputs);
    }

    @ZenMethod
    public static void addTraitAltarRecipe(String recipeRegistryName, IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs, @Nullable String iRequiredConstellationFocusName) {
        if (!AltarRecipe.matchNeededSlots(inputs, TileAltar.AltarLevel.TRAIT_CRAFT)) {
            return;
        }
        ItemStack out = AltarRecipe.convertToItemStack(output);
        if (out.func_190926_b()) {
            CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Skipping recipe-addition due to invalid output itemstack.");
            return;
        }
        IConstellation cst = null;
        if (iRequiredConstellationFocusName != null && (cst = ConstellationRegistry.getConstellationByName(iRequiredConstellationFocusName)) == null) {
            CraftTweakerAPI.logError((String)("[AstralSorcery Altar Crafting] Skipping recipe-addition due to unknown constellation: " + iRequiredConstellationFocusName));
            return;
        }
        ItemHandle[] handles = new ItemHandle[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            handles[i] = AltarRecipe.convertToHandle(inputs[i]);
        }
        ModIntegrationCrafttweaker.recipeModifications.add(new AltarRecipeTrait(recipeRegistryName, handles, out, starlightRequired, craftingTickTime, cst));
    }

    @ZenMethod
    public static void addTraitAltarRecipe(String recipeRegistryName, IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs) {
        AltarRecipe.addTraitAltarRecipe(recipeRegistryName, output, starlightRequired, craftingTickTime, inputs, null);
    }

    @ZenMethod
    @Deprecated
    public static void addTraitAltarRecipe(IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs) {
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Using deprecated 'addTraitAltarRecipe'! Use the new method with an additional registry-name parameter!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Enable the F3-Debug screen and hover over the receipe output of an altar recipe to see existing ones!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Should you try to replace an existing crafting recipe, make sure you use the same recipe name!");
        AltarRecipe.addTraitAltarRecipe("ct/null", output, starlightRequired, craftingTickTime, inputs, null);
    }

    @ZenMethod
    @Deprecated
    public static void addTraitAltarRecipe(IItemStack output, int starlightRequired, int craftingTickTime, IIngredient[] inputs, @Nullable String iRequiredConstellationFocusName) {
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Using deprecated 'addTraitAltarRecipe'! Use the new method with an additional registry-name parameter!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Enable the F3-Debug screen and hover over the receipe output of an altar recipe to see existing ones!");
        CraftTweakerAPI.logError((String)"[AstralSorcery Altar Crafting] Should you try to replace an existing crafting recipe, make sure you use the same recipe name!");
        AltarRecipe.addTraitAltarRecipe("ct/null", output, starlightRequired, craftingTickTime, inputs, iRequiredConstellationFocusName);
    }

    private static boolean matchNeededSlots(IIngredient[] inputs, TileAltar.AltarLevel altarLevel) {
        int reqSlots;
        switch (altarLevel) {
            case DISCOVERY: {
                reqSlots = SLOT_COUNT_T1;
                break;
            }
            case ATTUNEMENT: {
                reqSlots = SLOT_COUNT_T2;
                break;
            }
            case CONSTELLATION_CRAFT: {
                reqSlots = SLOT_COUNT_T3;
                break;
            }
            default: {
                reqSlots = SLOT_COUNT_T4;
            }
        }
        if (inputs == null || inputs.length < reqSlots) {
            CraftTweakerAPI.logError((String)("[AstralSorcery Altar Crafting] Not enough slots defined for altar level " + altarLevel.name()));
            return false;
        }
        return true;
    }
}

