/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier0;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import reborncore.api.IToolDrop;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.recipes.RecipeTranslator;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.Reference;
import techreborn.api.recipe.machines.AlloySmelterRecipe;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileIronAlloyFurnace
extends TileLegacyMachineBase
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(4, "TileIronAlloyFurnace", 64, (TileEntity)this);
    public int burnTime;
    public int currentItemBurnTime;
    public int cookTime;
    int input1 = 0;
    int input2 = 1;
    int outputSlot = 2;
    int fuel = 3;

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return (int)((double)TileEntityFurnace.func_145952_a((ItemStack)stack) * 1.25);
    }

    public boolean hasAllInputs(IBaseRecipeType recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (Object input : recipeType.getInputs()) {
            boolean hasItem = false;
            boolean useOreDict = input instanceof String || recipeType.useOreDic();
            boolean checkSize = input instanceof ItemStack;
            for (int inputslot = 0; inputslot < 2; ++inputslot) {
                if (!ItemUtils.isInputEqual(input, (ItemStack)this.inventory.func_70301_a(inputslot), (boolean)true, (boolean)true, (boolean)useOreDict)) continue;
                ItemStack inputStack = RecipeTranslator.getStackFromObject(input);
                if (checkSize && this.inventory.func_70301_a(inputslot).func_190916_E() < inputStack.func_190916_E()) continue;
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    private boolean canSmelt() {
        if (this.func_70301_a(this.input1).func_190926_b() || this.func_70301_a(this.input2).func_190926_b()) {
            return false;
        }
        ItemStack outputStack = null;
        for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)Reference.ALLOY_SMELTER_RECIPE)) {
            if (!this.hasAllInputs(recipeType)) continue;
            outputStack = recipeType.getOutput(0);
            break;
        }
        if (outputStack == null) {
            return false;
        }
        ItemStack outputSlotStack = this.func_70301_a(this.outputSlot);
        if (outputSlotStack.func_190926_b()) {
            return true;
        }
        if (!outputSlotStack.func_77969_a(outputStack)) {
            return false;
        }
        int result = outputSlotStack.func_190916_E() + outputStack.func_190916_E();
        return result <= this.func_70297_j_() && result <= outputSlotStack.func_77976_d();
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTime * scale / this.currentItemBurnTime;
    }

    public int getCookProgressScaled(int scale) {
        return this.cookTime * scale / 200;
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack outputStack = ItemStack.field_190927_a;
        IBaseRecipeType alloySmelterRecipe = null;
        for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)Reference.ALLOY_SMELTER_RECIPE)) {
            if (!this.hasAllInputs(recipeType)) continue;
            alloySmelterRecipe = recipeType;
            outputStack = recipeType.getOutput(0);
            break;
        }
        if (alloySmelterRecipe == null || outputStack.func_190926_b()) {
            return;
        }
        ItemStack outputSlotStack = this.func_70301_a(this.outputSlot);
        if (outputSlotStack.func_190926_b()) {
            this.func_70299_a(this.outputSlot, outputStack.func_77946_l());
        } else if (this.func_70301_a(this.outputSlot).func_77973_b() == outputStack.func_77973_b()) {
            this.func_70298_a(this.outputSlot, -outputStack.func_190916_E());
        }
        for (Object input : alloySmelterRecipe.getInputs()) {
            boolean useOreDict = input instanceof String || alloySmelterRecipe.useOreDic();
            for (int inputSlot = 0; inputSlot < 2; ++inputSlot) {
                if (!ItemUtils.isInputEqual(input, (ItemStack)this.inventory.func_70301_a(inputSlot), (boolean)true, (boolean)true, (boolean)useOreDict)) continue;
                int count = RecipeTranslator.getStackFromObject(input).func_190916_E();
                this.inventory.func_70298_a(inputSlot, count);
            }
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (burning) {
            --this.burnTime;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack fuelStack = this.func_70301_a(this.fuel);
        if (this.burnTime != 0 || !this.func_70301_a(this.input1).func_190926_b() && !fuelStack.func_190926_b()) {
            if (this.burnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.burnTime = TileIronAlloyFurnace.getItemBurnTime(fuelStack);
                if (this.burnTime > 0) {
                    updateInventory = true;
                    if (!fuelStack.func_190926_b()) {
                        this.func_70298_a(this.fuel, 1);
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                if (!this.isActive()) {
                    this.setActive(true);
                }
                ++this.cookTime;
                if (this.cookTime == 200) {
                    this.cookTime = 0;
                    this.smeltItem();
                    updateInventory = true;
                    this.setActive(false);
                }
            } else {
                this.cookTime = 0;
                this.setActive(false);
            }
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.func_70296_d();
        }
    }

    public void setActive(boolean active) {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block instanceof BlockMachineBase) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(active)));
        }
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.IRON_ALLOY_FURNACE, 1);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("alloyfurnace").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).filterSlot(0, 47, 17, stack -> RecipeHandler.recipeList.stream().anyMatch(recipe -> recipe instanceof AlloySmelterRecipe && ItemUtils.isInputEqual(recipe.getInputs().get(0), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)true))).filterSlot(1, 65, 17, stack -> RecipeHandler.recipeList.stream().anyMatch(recipe -> recipe instanceof AlloySmelterRecipe && ItemUtils.isInputEqual(recipe.getInputs().get(1), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)true))).outputSlot(2, 116, 35).fuelSlot(3, 56, 53).syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getCookTime, this::setCookTime).syncIntegerValue(this::getCurrentItemBurnTime, this::setCurrentItemBurnTime).addInventory().create((TileLegacyMachineBase)this);
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getCurrentItemBurnTime() {
        return this.currentItemBurnTime;
    }

    public void setCurrentItemBurnTime(int currentItemBurnTime) {
        this.currentItemBurnTime = currentItemBurnTime;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(int cookTime) {
        this.cookTime = cookTime;
    }
}

