/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Tank;

@RebornRegistry(modID="techreborn")
public class TilePump
extends TilePowerAcceptor {
    @ConfigRegistry(config="machines", category="pump", key="PumpEUCost", comment="Pump cost for one block of fluid (Value in EU)")
    public static int pumpExtractEU = 20;
    public Tank tank = new Tank("TilePump", 10000, (TileLegacyMachineBase)this);

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L && !this.tank.isFull() && this.tank.getCapacity() - this.tank.getFluidAmount() >= 1000 && this.canUseEnergy(pumpExtractEU)) {
            FluidStack fluidStack = TilePump.drainBlock(this.field_145850_b, this.field_174879_c.func_177977_b(), false);
            if (fluidStack != null) {
                this.tank.fill(TilePump.drainBlock(this.field_145850_b, this.field_174879_c.func_177977_b(), true), true);
                this.useEnergy(pumpExtractEU);
            }
            this.tank.compareAndUpdate();
        }
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        super.addInfo(info, isRealTile);
        info.add(TextFormatting.LIGHT_PURPLE + "Eu per extract " + TextFormatting.GREEN + PowerSystem.getLocaliszedPower((int)pumpExtractEU));
        info.add(TextFormatting.LIGHT_PURPLE + "Speed: " + TextFormatting.GREEN + "1000mb/5 sec");
    }

    public static FluidStack drainBlock(World world, BlockPos pos, boolean doDrain) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid != null && FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            if (block instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)block;
                if (!fluidBlock.canDrain(world, pos)) {
                    return null;
                }
                return fluidBlock.drain(world, pos, doDrain);
            }
            int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            if (level != 0) {
                return null;
            }
            if (doDrain) {
                world.func_175698_g(pos);
            }
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    public double getBaseMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return 32.0;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readFromNBTWithoutCoords(tagCompound);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.tank.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.writeToNBTWithoutCoords(tagCompound);
        return tagCompound;
    }

    public NBTTagCompound writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

