/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.ItemUtils;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.items.tools.ItemChainsaw;
import techreborn.lib.MessageIDs;

public class ItemAdvancedChainsaw
extends ItemChainsaw {
    private static final EnumFacing[] SEARCH_ORDER = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.UP};

    public ItemAdvancedChainsaw() {
        super(Item.ToolMaterial.DIAMOND, "techreborn.advancedChainsaw", ConfigTechReborn.AdvancedChainsawCharge, 1.0f);
        this.cost = 250;
        this.transferLimit = 1000.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        ItemStack stack = new ItemStack(ModItems.ADVANCED_CHAINSAW);
        ItemStack charged = stack.func_77946_l();
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(charged);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        itemList.add((Object)stack);
        itemList.add((Object)charged);
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        IBlockState state;
        if (ItemUtils.isActive((ItemStack)stack) && !worldIn.field_72995_K && (state = worldIn.func_180495_p(pos)).func_177230_c() instanceof IShearable && ((IShearable)state.func_177230_c()).isShearable(stack, (IBlockAccess)worldIn, pos)) {
            List results = ((IShearable)state.func_177230_c()).onSheared(stack, (IBlockAccess)worldIn, pos, 0);
            results.forEach(itemStack -> InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack));
            return super.func_179218_a(stack, worldIn, blockIn, pos, entityLiving);
        }
        ArrayList<BlockPos> wood = new ArrayList<BlockPos>();
        this.findWood(worldIn, pos, wood, new ArrayList<BlockPos>());
        wood.forEach(pos1 -> this.breakBlock((BlockPos)pos1, stack, worldIn, entityLiving, pos));
        return super.func_179218_a(stack, worldIn, blockIn, pos, entityLiving);
    }

    private void findWood(World world, BlockPos pos, List<BlockPos> wood, List<BlockPos> leaves) {
        if (wood.size() >= 64) {
            return;
        }
        if (leaves.size() >= 150) {
            return;
        }
        for (EnumFacing facing : SEARCH_ORDER) {
            BlockPos checkPos = pos.func_177972_a(facing);
            if (wood.contains(checkPos) || leaves.contains(checkPos)) continue;
            IBlockState state = world.func_180495_p(checkPos);
            if (state.func_177230_c().isWood((IBlockAccess)world, checkPos)) {
                wood.add(checkPos);
                this.findWood(world, checkPos, wood, leaves);
                continue;
            }
            if (!state.func_177230_c().isLeaves(state, (IBlockAccess)world, checkPos)) continue;
            leaves.add(checkPos);
            this.findWood(world, checkPos, wood, leaves);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (new ForgePowerItemManager(stack).getEnergyStored() < this.cost) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.nanosaberEnergyErrorTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberActivate", (Object[])new Object[0])));
            } else if (!ItemUtils.isActive((ItemStack)stack)) {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74757_a("isActive", true);
                if (world.field_72995_K) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.setTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberActive", (Object[])new Object[0])));
                }
            } else {
                stack.func_77978_p().func_74757_a("isActive", false);
                if (world.field_72995_K) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.setTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberInactive", (Object[])new Object[0])));
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ItemUtils.isActive((ItemStack)stack) && new ForgePowerItemManager(stack).getEnergyStored() < this.cost) {
            if (worldIn.field_72995_K) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.nanosaberEnergyError", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberDeactivating", (Object[])new Object[0])));
            }
            stack.func_77978_p().func_74757_a("isActive", false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!ItemUtils.isActive((ItemStack)stack)) {
            tooltip.add(TextFormatting.YELLOW + "Shear: " + TextFormatting.RED + I18n.func_135052_a((String)"techreborn.message.nanosaberInactive", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.YELLOW + "Shear: " + TextFormatting.GREEN + I18n.func_135052_a((String)"techreborn.message.nanosaberActive", (Object[])new Object[0]));
        }
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return Items.field_151056_x.func_150897_b(blockIn);
    }

    public void breakBlock(BlockPos pos, ItemStack stack, World world, EntityLivingBase entityLiving, BlockPos oldPos) {
        if (oldPos == pos) {
            return;
        }
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        if (capEnergy.getEnergyStored() < this.cost) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_185887_b(world, pos) == -1.0f) {
            return;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        capEnergy.extractEnergy(this.cost, false);
        ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)entityLiving);
        blockState.func_177230_c().func_180657_a(world, (EntityPlayer)entityLiving, pos, blockState, world.func_175625_s(pos), stack);
        world.func_175698_g(pos);
        world.func_175713_t(pos);
    }
}

